/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import opencard.core.util.Tracer;

public class URLClassLoader
extends ClassLoader {
    private Tracer itracer = new Tracer((Object)this, URLClassLoader.class);
    protected Hashtable classCache = new Hashtable();
    protected Hashtable byteCache = new Hashtable();
    protected URL url = null;
    protected String archive = null;
    protected boolean archiveLoaded = false;

    public URLClassLoader(URL uRL) {
        this.url = uRL;
    }

    public URLClassLoader(URL uRL, String string) {
        this(uRL);
        this.archive = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz;
        boolean bl2;
        SecurityManager securityManager = System.getSecurityManager();
        int n = string.lastIndexOf(46);
        String string2 = n >= 0 ? string.substring(0, n) : null;
        boolean bl3 = bl2 = securityManager != null && string2 != null;
        if (bl2) {
            securityManager.checkPackageAccess(string2);
        }
        Hashtable hashtable = this.classCache;
        synchronized (hashtable) {
            if (this.classCache.containsKey(string)) {
                return (Class)this.classCache.get(string);
            }
            try {
                Class<?> clazz2 = this.findSystemClass(string);
                this.itracer.debug("loadClass", "Found System Class: " + string);
                this.classCache.put(string, clazz2);
                return clazz2;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl2) {
                    securityManager.checkPackageDefinition(string2);
                }
                byte[] byArray = this.loadClassData(string);
                clazz = this.defineClass(string, byArray, 0, byArray.length);
                this.classCache.put(string, clazz);
                this.itracer.debug("loadClass", "Loaded class from URL: " + string);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected synchronized byte[] loadClassData(String string) throws ClassNotFoundException {
        String string2 = string.replace('.', '/');
        String string3 = string2 + ".class";
        if (this.archive != null) {
            if (!this.archiveLoaded) {
                this.loadArchive(this.url, this.archive);
            }
            if (this.byteCache.containsKey(string3)) {
                byte[] byArray = (byte[])this.byteCache.get(string3);
                this.byteCache.remove(string3);
                return byArray;
            }
            throw new ClassNotFoundException("archive: " + this.archive + " does not contain:" + string3);
        }
        BufferedInputStream bufferedInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            URL uRL = new URL(this.url, string3);
            InputStream inputStream = uRL.openStream();
            bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = this.inputStreamToByteArray(bufferedInputStream);
            return byArray;
        }
        catch (MalformedURLException malformedURLException) {
            throw new ClassNotFoundException(malformedURLException.toString());
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(iOException.toString());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new ClassNotFoundException(throwable.toString());
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void loadArchive(URL uRL, String string) throws ClassNotFoundException {
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            URL uRL2 = new URL(uRL, string);
            InputStream inputStream = uRL2.openStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            zipInputStream = new ZipInputStream(bufferedInputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string2 = zipEntry.getName();
                byte[] byArray = this.inputStreamToByteArray(zipInputStream);
                this.byteCache.put(string2, byArray);
            }
            this.archiveLoaded = true;
        }
        catch (MalformedURLException malformedURLException) {
            throw new ClassNotFoundException(malformedURLException.toString());
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(iOException.toString());
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] inputStreamToByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            byteArrayOutputStream.close();
        }
    }
}

