/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.util;

public class Tag {
    private int tag;
    private byte tagclass;
    private boolean constructed;

    public Tag() {
        this.tag = 0;
        this.tagclass = 0;
        this.constructed = false;
    }

    public Tag(Tag tag) {
        this.tag = tag.tag;
        this.tagclass = tag.tagclass;
        this.constructed = tag.constructed;
    }

    public Tag(int n, byte by, boolean bl) {
        this.tag = n;
        this.tagclass = by;
        this.constructed = bl;
    }

    public Tag(byte[] byArray, int[] nArray) {
        this.fromBinary(byArray, nArray);
    }

    public Tag(byte[] byArray) {
        int[] nArray = new int[]{0};
        this.fromBinary(byArray, nArray);
    }

    public int size() {
        if (this.tag < 31) {
            return 1;
        }
        if (this.tag < 128) {
            return 2;
        }
        if (this.tag < 16384) {
            return 3;
        }
        if (this.tag < 0x200000) {
            return 4;
        }
        return 5;
    }

    public void fromBinary(byte[] byArray, int[] nArray) {
        this.tagclass = (byte)((byArray[nArray[0]] & 0xC0) >>> 6);
        this.constructed = (byArray[nArray[0]] & 0x20) == 32;
        this.tag = 0;
        if ((byArray[nArray[0]] & 0x1F) == 31) {
            do {
                nArray[0] = nArray[0] + 1;
                this.tag *= 128;
                this.tag += byArray[nArray[0]] & 0x7F;
            } while ((byArray[nArray[0]] & 0x80) == 128);
        } else {
            this.tag = byArray[nArray[0]] & 0x1F;
        }
        nArray[0] = nArray[0] + 1;
    }

    public byte[] getBytes() {
        int[] nArray = new int[]{0};
        byte[] byArray = new byte[this.size()];
        this.toBinary(byArray, nArray);
        return byArray;
    }

    public void toBinary(byte[] byArray, int[] nArray) {
        byte[] byArray2 = new byte[]{0, 64, -128, -64};
        int n = 0;
        int n2 = nArray[0];
        byArray[n2] = (byte)(byArray[n2] | byArray2[this.tagclass]);
        if (this.constructed) {
            int n3 = nArray[0];
            byArray[n3] = (byte)(byArray[n3] | 0x20);
        }
        if (this.tag < 31) {
            int n4 = nArray[0];
            byArray[n4] = (byte)(byArray[n4] | (byte)this.tag);
        } else {
            int n5 = nArray[0];
            byArray[n5] = (byte)(byArray[n5] | 0x1F);
            for (n = this.size() - 2; n > 0; --n) {
                nArray[0] = nArray[0] + 1;
                byArray[nArray[0]] = (byte)(0x80 | this.tag >> n * 7 & 0x7F);
            }
            nArray[0] = nArray[0] + 1;
            byArray[nArray[0]] = (byte)(this.tag & 0x7F);
        }
        nArray[0] = nArray[0] + 1;
    }

    public void set(int n, byte by, boolean bl) {
        this.tag = n;
        this.tagclass = by;
        this.constructed = bl;
    }

    public void setConstructed(boolean bl) {
        this.constructed = bl;
    }

    public int code() {
        return this.tag;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    public int hashCode() {
        return this.tag + this.tagclass;
    }

    public boolean equals(Object object) {
        return this.tag == ((Tag)object).tag && this.tagclass == ((Tag)object).tagclass;
    }

    public String toString() {
        return "(" + this.tag + "," + this.tagclass + "," + this.constructed + ")";
    }
}

