/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.util;

import java.util.Hashtable;
import opencard.core.util.HexString;
import opencard.opt.util.Tag;

public class TLV {
    private Tag tag;
    private int length;
    private byte[] value;
    private TLV parent;
    private TLV sibling;
    private TLV child;
    private TLV lastChild;

    public TLV() {
        this.tag = new Tag(0, 0, false);
        this.length = 0;
        this.value = null;
        this.parent = null;
        this.sibling = null;
        this.child = null;
        this.lastChild = null;
    }

    public TLV(byte[] byArray) {
        int[] nArray = new int[]{0};
        this.tag = new Tag(0, 0, false);
        this.length = 0;
        this.value = null;
        this.parent = null;
        this.sibling = null;
        this.child = null;
        this.lastChild = null;
        TLV.fromBinary(byArray, nArray, this, null);
    }

    public TLV(byte[] byArray, int[] nArray) {
        this.tag = new Tag(0, 0, false);
        this.length = 0;
        this.value = null;
        this.parent = null;
        this.sibling = null;
        this.child = null;
        this.lastChild = null;
        TLV.fromBinary(byArray, nArray, this, null);
    }

    public TLV(Tag tag, byte[] byArray) {
        int[] nArray = new int[]{0};
        TLV tLV = new TLV();
        this.tag = new Tag(tag);
        if (this.tag.isConstructed()) {
            while (nArray[0] < byArray.length) {
                TLV.fromBinary(byArray, nArray, tLV, this);
            }
        } else {
            this.length = byArray != null ? byArray.length : 0;
            this.value = byArray;
            this.child = null;
            this.lastChild = null;
        }
        this.parent = null;
        this.sibling = null;
    }

    public TLV(Tag tag, int n) {
        int n2 = 0;
        this.tag = new Tag(tag);
        this.value = n < 256 ? new byte[1] : (n < 65536 ? new byte[2] : (n < 0x1000000 ? new byte[3] : new byte[4]));
        for (n2 = this.value.length - 1; n2 >= 0; --n2) {
            this.value[n2] = (byte)(n % 256);
            n /= 256;
        }
        this.length = this.value.length;
        this.child = null;
        this.lastChild = null;
        this.parent = null;
        this.sibling = null;
    }

    public TLV(Tag tag, TLV tLV) {
        this.tag = new Tag(tag);
        this.tag.setConstructed(true);
        this.value = null;
        this.parent = null;
        this.sibling = null;
        this.child = tLV;
        this.lastChild = tLV;
        this.length = tLV != null ? tLV.tag.size() + tLV.lenBytes() + tLV.length : 0;
    }

    public TLV add(TLV tLV) {
        int n = 0;
        int n2 = 0;
        if (this.tag.isConstructed()) {
            tLV.parent = this;
            tLV.sibling = null;
            if (this.lastChild != null) {
                this.lastChild.sibling = tLV;
            }
            this.lastChild = tLV;
            TLV tLV2 = this;
            while (tLV2 != null) {
                n = tLV2.lenBytes();
                tLV2.length += tLV.length + tLV.tag.size() + tLV.lenBytes() + n2;
                n2 += tLV2.lenBytes() - n;
                tLV2 = tLV2.parent;
            }
            return this;
        }
        return null;
    }

    public TLV findTag(Tag tag, TLV tLV) {
        TLV tLV2 = tLV == null ? this.child : tLV.sibling;
        if (tag == null) {
            return tLV2;
        }
        while (tLV2 != null) {
            if (tLV2.tag.equals(tag)) {
                return tLV2;
            }
            tLV2 = tLV2.sibling;
        }
        return null;
    }

    public static void fromBinary(byte[] byArray, int[] nArray, TLV tLV, TLV tLV2) {
        boolean bl = false;
        int n = nArray[0];
        TLV tLV3 = null;
        tLV.tag.fromBinary(byArray, nArray);
        tLV.length = 0;
        if ((byArray[nArray[0]] & 0xFFFFFF80) == 0) {
            tLV.length += byArray[nArray[0]];
        } else {
            int n2 = 0;
            for (int i = byArray[nArray[0]] & 0x7F; i > 0; --i) {
                nArray[0] = nArray[0] + 1;
                n2 = byArray[nArray[0]];
                tLV.length = tLV.length + (n2 < 0 ? (n2 += 256) : n2);
                if (i <= 1) continue;
                tLV.length *= 256;
            }
        }
        nArray[0] = nArray[0] + 1;
        if (tLV.tag.isConstructed()) {
            tLV.value = null;
            if (tLV.length > 0) {
                tLV.child = new TLV();
                TLV.fromBinary(byArray, nArray, tLV.child, tLV);
                tLV3 = tLV.child;
                while (nArray[0] <= n + tLV.length) {
                    tLV3.sibling = new TLV();
                    TLV.fromBinary(byArray, nArray, tLV3.sibling, tLV);
                    tLV3 = tLV3.sibling;
                }
                tLV.lastChild = tLV3;
            } else {
                tLV.child = null;
            }
        } else {
            tLV.child = null;
            tLV.sibling = null;
            tLV.value = new byte[tLV.length];
            System.arraycopy(byArray, nArray[0], tLV.value, 0, tLV.length);
            nArray[0] = nArray[0] + tLV.length;
        }
        tLV.parent = tLV2;
    }

    private int lenBytes() {
        if (this.length < 128) {
            return 1;
        }
        if (this.length < 256) {
            return 2;
        }
        if (this.length < 65536) {
            return 3;
        }
        if (this.length < 0x1000000) {
            return 4;
        }
        return 5;
    }

    public static int lenBytes(int n) {
        if (n < 128) {
            return 1;
        }
        if (n < 256) {
            return 2;
        }
        if (n < 65536) {
            return 3;
        }
        if (n < 0x1000000) {
            return 4;
        }
        return 5;
    }

    public int length() {
        return this.length;
    }

    public static byte[] lengthToBinary(int n) {
        byte[] byArray = new byte[TLV.lenBytes(n)];
        if (n < 128) {
            byArray[0] = (byte)n;
        } else if (n < 256) {
            byArray[0] = -127;
            byArray[1] = (byte)n;
        } else if (n < 65536) {
            byArray[0] = -126;
            byArray[1] = (byte)(n / 256);
            byArray[2] = (byte)(n % 256);
        } else if (n < 0x1000000) {
            byArray[0] = -125;
            byArray[1] = (byte)(n / 65536);
            byArray[2] = (byte)(n / 256);
            byArray[3] = (byte)(n % 256);
        }
        return byArray;
    }

    public void setValue(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        n = this.lenBytes();
        int n3 = this.length;
        this.value = byArray;
        this.length = byArray != null ? this.value.length : 0;
        n2 = this.lenBytes() - n;
        TLV tLV = this.parent;
        while (tLV != null) {
            n = tLV.lenBytes();
            tLV.length += this.length - n3 + n2;
            n2 += tLV.lenBytes() - n;
            tLV = tLV.parent;
        }
    }

    public Tag tag() {
        return this.tag;
    }

    public byte[] toBinary() {
        int[] nArray = new int[]{0};
        int n = this.tag.size() + this.lenBytes() + this.length;
        byte[] byArray = new byte[n];
        this.toBinaryHelper(byArray, nArray, n);
        return byArray;
    }

    public byte[] toBinaryContent() {
        int[] nArray = new int[]{0};
        int n = this.length;
        byte[] byArray = new byte[n];
        this.toBinaryHelperContent(byArray, nArray, n);
        return byArray;
    }

    private void toBinaryHelper(byte[] byArray, int[] nArray, int n) {
        boolean bl = false;
        this.tag.toBinary(byArray, nArray);
        this.toBinaryLength(byArray, nArray);
        if (this.child != null) {
            this.child.toBinaryHelper(byArray, nArray, n);
        } else if (this.value != null) {
            System.arraycopy(this.value, 0, byArray, nArray[0], this.value.length);
            nArray[0] = nArray[0] + this.value.length;
        }
        if (this.sibling != null && nArray[0] < n) {
            this.sibling.toBinaryHelper(byArray, nArray, n);
        }
    }

    private void toBinaryHelperContent(byte[] byArray, int[] nArray, int n) {
        boolean bl = false;
        if (this.child != null) {
            this.child.toBinaryHelper(byArray, nArray, n);
        } else if (this.value != null) {
            System.arraycopy(this.value, 0, byArray, nArray[0], this.value.length);
            nArray[0] = nArray[0] + this.value.length;
        }
    }

    private void toBinaryLength(byte[] byArray, int[] nArray) {
        if (this.length < 128) {
            byArray[nArray[0]] = (byte)this.length;
        } else if (this.length < 256) {
            byArray[nArray[0]] = -127;
            nArray[0] = nArray[0] + 1;
            byArray[nArray[0]] = (byte)this.length;
        } else if (this.length < 65536) {
            byArray[nArray[0]] = -126;
            nArray[0] = nArray[0] + 1;
            byArray[nArray[0]] = (byte)(this.length / 256);
            nArray[0] = nArray[0] + 1;
            byArray[nArray[0]] = (byte)(this.length % 256);
        } else if (this.length < 0x1000000) {
            byArray[nArray[0]] = -125;
            nArray[0] = nArray[0] + 1;
            byArray[nArray[0]] = (byte)(this.length / 65536);
            nArray[0] = nArray[0] + 1;
            byArray[nArray[0]] = (byte)(this.length / 256);
            nArray[0] = nArray[0] + 1;
            byArray[nArray[0]] = (byte)(this.length % 256);
        }
        nArray[0] = nArray[0] + 1;
    }

    public String toString() {
        return this.toString(null, 0);
    }

    public String toString(Hashtable hashtable, int n) {
        String string = new String("");
        int n2 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            string = string + " ";
        }
        string = hashtable == null ? string + "[" + this.tag + " " + this.length + "] " : string + hashtable.get(this.tag) + " ";
        if (this.tag.isConstructed()) {
            string = string + "\n";
            for (n2 = 0; n2 < n; ++n2) {
                string = string + " ";
            }
        }
        string = string + "( ";
        if (this.tag.isConstructed()) {
            string = string + "\n";
            string = string + this.child.toString(hashtable, n + 2);
            for (n2 = 0; n2 < n; ++n2) {
                string = string + " ";
            }
            string = string + ")\n";
        } else {
            boolean bl = true;
            if (this.value != null) {
                for (n2 = 0; n2 < this.value.length; ++n2) {
                    if (this.value[n2] >= 32) continue;
                    bl = false;
                }
                if (bl) {
                    string = string + "\"" + new String(this.value) + "\"";
                } else {
                    string = string + "'";
                    for (n2 = 0; n2 < this.value.length; ++n2) {
                        string = string + HexString.hexify(this.value[n2]);
                    }
                    string = string + "'";
                }
            }
            string = string + " )\n";
        }
        if (this.sibling != null) {
            string = string + this.sibling.toString(hashtable, n);
        }
        return string;
    }

    public byte[] valueAsByteArray() {
        return this.value;
    }

    public int valueAsNumber() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.value.length; ++n) {
            n2 = this.value[n];
            n3 = n3 * 256 + (n2 < 0 ? (n2 += 256) : n2);
        }
        return n3;
    }
}

