/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.terminal.protocol;

import opencard.core.util.Tracer;
import opencard.opt.terminal.protocol.T1Block;
import opencard.opt.terminal.protocol.T1BlockEDCErrorException;
import opencard.opt.terminal.protocol.T1BlockFactory;
import opencard.opt.terminal.protocol.T1BlockLengthException;
import opencard.opt.terminal.protocol.T1Exception;
import opencard.opt.terminal.protocol.T1IOException;
import opencard.opt.terminal.protocol.T1TimeoutException;
import opencard.opt.terminal.protocol.T1UnknownBlockException;

public abstract class T1Protocol {
    private static Tracer ctracer = new Tracer(T1Protocol.class);
    private int hostAddress = 0;
    private int remoteAddress = 0;
    private int blockWaitingTime = 0;
    private int sBlockCounter = 0;
    private int rBlockCounter = 0;
    private int ifs = 32;
    private T1Block[] blockSequence = new T1Block[2];

    T1Protocol() {
        this.setBlockWaitingTime(0);
    }

    public T1Protocol(int n, int n2, int n3) {
        this.hostAddress = n;
        this.remoteAddress = n2;
        this.setBlockWaitingTime(n3);
    }

    public void open() throws T1Exception {
        this.initProtocol();
    }

    public void close() {
    }

    public int getBlockWaitingTime() {
        return this.blockWaitingTime;
    }

    public void setBlockWaitingTime(int n) {
        this.blockWaitingTime = n;
    }

    public int getHostAddress() {
        return this.hostAddress;
    }

    public int getRemoteAddress() {
        return this.remoteAddress;
    }

    public int getSendSequenceCounter() {
        return this.sBlockCounter;
    }

    public void setSendSequenceCounter(int n) {
        this.sBlockCounter = n;
    }

    public void incSendSequenceCounter() {
        ++this.sBlockCounter;
    }

    public int getRecvSequenceCounter() {
        return this.rBlockCounter;
    }

    public void setRecvSequenceCounter(int n) {
        this.rBlockCounter = n;
    }

    public void incRecvSequenceCounter() {
        ++this.rBlockCounter;
    }

    public synchronized byte[] transmit(byte[] byArray) throws T1IOException, T1TimeoutException, T1Exception {
        return this.transmit(this.getRemoteAddress(), byArray);
    }

    public synchronized byte[] transmit(int n, byte[] byArray) throws T1IOException, T1TimeoutException, T1Exception {
        return this.transmit(this.getHostAddress(), n, byArray);
    }

    public synchronized byte[] transmit(int n, int n2, byte[] byArray) throws T1IOException, T1TimeoutException, T1Exception {
        int n3 = 0;
        byte[] byArray2 = null;
        T1Block t1Block = null;
        for (int i = byArray.length; i > 0; i -= n3) {
            T1Block t1Block2;
            if (i > this.ifs) {
                throw new T1IOException("block too long - chaining is not supported!");
            }
            n3 = i;
            boolean bl = false;
            byArray2 = new byte[n3];
            System.arraycopy(byArray, byArray.length - i, byArray2, 0, n3);
            this.blockSequence[this.getSendSequenceCounter() % 2] = t1Block2 = T1BlockFactory.createIBlock(n, n2, 1, this.getSendSequenceCounter(), bl, byArray2);
            t1Block = this.internalTransmit(5, t1Block2);
            if (t1Block2.getBlockType() != 0) continue;
            this.incSendSequenceCounter();
        }
        return t1Block.getDATA();
    }

    protected boolean isBlockComplete(byte[] byArray, int n) {
        int n2;
        boolean bl = false;
        if (byArray != null && n >= 4 && byArray.length >= 4 && (n2 = byArray[2] & 0xFF) + 4 == n) {
            bl = true;
        }
        return bl;
    }

    private void initProtocol() throws T1Exception {
        T1Block t1Block = T1BlockFactory.createSBlock(this.hostAddress, this.remoteAddress, 1, 0, null);
        T1Block t1Block2 = T1BlockFactory.createSBlock(this.hostAddress, this.remoteAddress, 1, 1, new byte[]{(byte)this.ifs});
        for (int i = 0; i < 3; ++i) {
            T1Block t1Block3 = null;
            try {
                ctracer.debug("initProtocol", "Send S-BLOCK to reader for init-request.");
                t1Block3 = this.internalTransmit(5, t1Block);
                if (t1Block3.getBlockType() != 192 || t1Block3.getControlBits() != 32) continue;
                this.sBlockCounter = 0;
                this.rBlockCounter = 0;
                t1Block3 = this.internalTransmit(5, t1Block2);
                if (t1Block3.getBlockType() != 192 || t1Block3.getControlBits() != 33) continue;
                if (t1Block3.getLEN() == 1) {
                    byte by = t1Block3.getDATA()[0];
                    this.ifs = by & 0x7F;
                    if ((by & 0x80) == 128) {
                        this.ifs += 128;
                    }
                    ctracer.debug("initProtocol", "IFS set to " + this.ifs + " + bytes length");
                    return;
                }
                ctracer.error("initProtocol", "IFS response error");
                continue;
            }
            catch (Exception exception) {
                ctracer.critical("initProtocol", "Reader initialization failed.");
            }
        }
        throw new T1Exception("no correct answer on resync request - protocol init failed!");
    }

    protected T1Block internalTransmit(int n, T1Block t1Block) throws T1Exception {
        T1Block t1Block2 = null;
        if (n == 0) {
            throw new T1Exception("to many retries - transfer aborted");
        }
        try {
            t1Block2 = this.exchangeData(t1Block);
            if (t1Block2 == null) {
                throw new T1BlockEDCErrorException();
            }
            switch (t1Block2.getBlockType()) {
                case 0: {
                    this.incRecvSequenceCounter();
                    return t1Block2;
                }
                case 128: {
                    t1Block2 = this.internalTransmit(n - 1, this.blockSequence[t1Block2.getRequestedSequenceNumber() % 2]);
                    break;
                }
                case 192: {
                    if (t1Block2.getControlBits() == 3) {
                        T1Block t1Block3 = T1BlockFactory.createSBlock(t1Block.getSourceAddress(), t1Block.getDestinationAddress(), 1, 35, t1Block2.getDATA());
                        return this.internalTransmit(n - 1, t1Block3);
                    }
                    if (t1Block.getBlockType() != 192 || t1Block.getControlBits() != 0 || t1Block2.getControlBits() != 32) break;
                    return t1Block2;
                }
            }
        }
        catch (T1UnknownBlockException t1UnknownBlockException) {
        }
        catch (T1BlockEDCErrorException t1BlockEDCErrorException) {
            T1Block t1Block4 = T1BlockFactory.createRBlock(this.hostAddress, this.remoteAddress, 1, this.getRecvSequenceCounter(), 1);
            this.incSendSequenceCounter();
            this.blockSequence[this.getSendSequenceCounter() % 2] = t1Block4;
            t1Block2 = this.internalTransmit(n - 1, t1Block4);
        }
        return t1Block2;
    }

    protected abstract T1Block exchangeData(T1Block var1) throws T1IOException, T1TimeoutException, T1BlockLengthException, T1UnknownBlockException, T1BlockEDCErrorException;
}

