/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.terminal;

import java.util.Hashtable;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.opt.terminal.Lockable;
import opencard.opt.terminal.TerminalLockedException;

public abstract class AbstractLockableTerminal
extends CardTerminal
implements Lockable {
    private Object lockHandle_ = null;
    private Hashtable slotHandles_ = new Hashtable();

    protected Object getTerminalLockHandle() {
        return this.lockHandle_;
    }

    protected Thread getSlotLockHandle(int n) {
        return (Thread)this.slotHandles_.get(new Integer(n));
    }

    protected AbstractLockableTerminal(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    @Override
    public final synchronized Object lock() throws CardTerminalException {
        if (this.lockHandle_ != null) {
            throw new TerminalLockedException("terminal already locked", this);
        }
        if (!this.slotHandles_.isEmpty()) {
            throw new TerminalLockedException("terminal has locked slots", this);
        }
        int n = this.getSlots();
        for (int i = 0; i < n; ++i) {
            if (this.isSlotChannelAvailable(i)) continue;
            throw new TerminalLockedException("terminal has open SlotChannel(s)", this);
        }
        this.internalLock();
        this.lockHandle_ = new Integer(0);
        return this.lockHandle_;
    }

    @Override
    public synchronized void unlock(Object object) throws CardTerminalException {
        if (this.lockHandle_ == null) {
            throw new TerminalLockedException("terminal not locked", this);
        }
        if (this.lockHandle_ != object) {
            throw new TerminalLockedException("caller not lock owner", this);
        }
        this.internalUnlock();
        this.lockHandle_ = null;
    }

    @Override
    public Object lockSlot(int n) throws CardTerminalException {
        if (this.lockHandle_ != null) {
            throw new TerminalLockedException("terminal is locked", this);
        }
        Object object = this.getSlotLockHandle(n);
        if (object != null) {
            throw new TerminalLockedException("slot is already locked", this);
        }
        if (this.isSlotChannelAvailable(n)) {
            throw new TerminalLockedException("slot is in use, Slotchannel exists", this);
        }
        this.internalLockSlot(n);
        object = new Integer(n);
        this.slotHandles_.put(new Integer(n), object);
        return object;
    }

    @Override
    public void unlockSlot(int n, Object object) throws CardTerminalException {
        if (!this.isSlotChannelAvailable(n)) {
            throw new TerminalLockedException("can not unlock slot while SlotChannel is open", this);
        }
        Thread thread = this.getSlotLockHandle(n);
        if (thread != object) {
            throw new TerminalLockedException("invalid handle", this);
        }
        if (thread != null) {
            this.internalUnlockSlot(n);
            this.slotHandles_.remove(new Integer(n));
        }
    }

    protected abstract void internalLock() throws CardTerminalException;

    protected abstract void internalUnlock() throws CardTerminalException;

    protected abstract void internalLockSlot(int var1) throws CardTerminalException;

    protected abstract void internalUnlockSlot(int var1) throws CardTerminalException;

    @Override
    protected final void internalOpenSlotChannel(int n) throws CardTerminalException {
        if (this.lockHandle_ != null) {
            throw new TerminalLockedException("terminal is locked", this);
        }
        Thread thread = this.getSlotLockHandle(n);
        if (thread != null) {
            throw new TerminalLockedException("slot is locked", this);
        }
        this.lockableOpenSlotChannel(n);
    }

    @Override
    protected final void internalOpenSlotChannel(int n, Object object) throws CardTerminalException {
        if (this.lockHandle_ != null && this.lockHandle_ != object) {
            throw new TerminalLockedException("terminal locked, invalid handle", this);
        }
        Thread thread = this.getSlotLockHandle(n);
        if (thread != null && thread != object) {
            throw new TerminalLockedException("slot is locked, invalid handle", this);
        }
        this.lockableOpenSlotChannel(n);
    }

    protected abstract void lockableOpenSlotChannel(int var1) throws CardTerminalException;
}

