/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.security;

import java.math.BigInteger;
import java.security.PublicKey;
import opencard.core.util.Tracer;

public class RSAPublicKey
implements PublicKey {
    private Tracer itracer = new Tracer((Object)this, RSAPublicKey.class);
    protected int el;
    protected BigInteger e = null;
    protected BigInteger m = null;
    protected int inputLength;
    protected int outputLength;
    protected int keyLength;

    public RSAPublicKey(int n, byte[] byArray, byte[] byArray2, int n2) {
        this.el = n;
        this.e = new BigInteger(1, byArray);
        this.m = new BigInteger(1, byArray2);
        this.keyLength = n2;
        this.inputLength = byArray2.length;
        this.outputLength = byArray2.length;
    }

    public RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.e = bigInteger;
        this.m = bigInteger2;
        this.el = (bigInteger.bitLength() + 7) / 8;
        this.keyLength = bigInteger2.bitLength();
        this.inputLength = (this.keyLength + 7) / 8;
        this.outputLength = (this.keyLength + 7) / 8;
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    @Override
    public String getFormat() {
        return null;
    }

    public int maxInputLength() {
        return this.inputLength;
    }

    public int maxOutputLength() {
        return this.outputLength;
    }

    public BigInteger modulus() {
        return this.m;
    }

    public BigInteger publicExponent() {
        return this.e;
    }
}

