/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import java.util.Enumeration;
import java.util.Vector;
import opencard.opt.iso.fs.CardFileAppID;
import opencard.opt.iso.fs.CardFileFileID;
import opencard.opt.iso.fs.CardFilePartialAppID;
import opencard.opt.iso.fs.CardFilePathComponent;
import opencard.opt.iso.fs.CardFileShortFileID;
import opencard.opt.iso.fs.CardIOException;
import opencard.opt.security.SecurityDomain;

public class CardFilePath
implements SecurityDomain {
    public static final String SYM_SEPARATOR = "/";
    public static final String FID_SEPARATOR = ":";
    public static final String APPID_PREFIX = "#";
    public static final String PARTIALAPPID_POSTFIX = "*";
    public static final String ROOTFILEID = ":3F00";
    protected CardFilePathComponent[] components = null;
    private String string_representation = null;

    private static int separatorAt(String string, int n, int n2) {
        char[] cArray = new char[]{FID_SEPARATOR.charAt(0), SYM_SEPARATOR.charAt(0)};
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (string.charAt(n) != c) continue;
            if (n + 1 < n2 && string.charAt(n + 1) != c) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    private CardFilePath() {
    }

    public CardFilePath(String string) throws CardIOException {
        int n;
        if (string.length() == 0) {
            throw new CardIOException("empty path");
        }
        Vector<Integer> vector = new Vector<Integer>();
        block5: for (n = 0; n < string.length(); ++n) {
            switch (CardFilePath.separatorAt(string, n, string.length())) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    vector.addElement(new Integer(n));
                    continue block5;
                }
                case 2: {
                    ++n;
                }
            }
        }
        n = vector.size() == 0 ? 1 : ((Integer)vector.elementAt(0) == 0 ? vector.size() : vector.size() + 1);
        this.components = new CardFilePathComponent[n];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            int n4 = (Integer)vector.elementAt(i);
            String string2 = null;
            if (n4 == 0) {
                if (string.length() > 1) continue;
                n4 = 1;
            }
            string2 = string.substring(n2, n4);
            n2 = n4;
            this.components[n3] = CardFilePathComponent.createComponent(string2, n3, string, n);
            ++n3;
        }
        if (n3 < n) {
            String string3 = string.substring(n2);
            this.components[n3] = CardFilePathComponent.createComponent(string3, n3, string, n);
        }
    }

    public CardFilePath(byte[] byArray) {
        this.components = new CardFilePathComponent[byArray.length / 2 + byArray.length % 2];
        int n = 0;
        for (int i = 0; i < byArray.length; i += 2) {
            this.components[n++] = i + 1 == byArray.length ? new CardFileShortFileID(byArray[i]) : new CardFileFileID(byArray[i], byArray[i + 1]);
        }
    }

    public CardFilePath(CardFilePath cardFilePath) {
        this.components = new CardFilePathComponent[cardFilePath.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = cardFilePath.components[i];
        }
    }

    public Enumeration components() {
        return new Enumeration(){
            int idx = 0;

            @Override
            public boolean hasMoreElements() {
                return this.idx < CardFilePath.this.components.length;
            }

            public Object nextElement() {
                return CardFilePath.this.components[this.idx++];
            }
        };
    }

    public CardFilePath append(CardFilePath cardFilePath) {
        int n;
        if (cardFilePath.components[0] instanceof CardFileAppID || cardFilePath.components[0] instanceof CardFilePartialAppID) {
            throw new CardIOException("attempt to append (partial) application ID " + cardFilePath);
        }
        if (this.components[this.components.length - 1] instanceof CardFileShortFileID) {
            throw new CardIOException("attempt to append after short file ID " + this);
        }
        CardFilePathComponent[] cardFilePathComponentArray = this.components;
        this.components = new CardFilePathComponent[cardFilePathComponentArray.length + cardFilePath.components.length];
        for (n = 0; n < cardFilePathComponentArray.length; ++n) {
            this.components[n] = cardFilePathComponentArray[n];
        }
        for (n = 0; n < cardFilePath.components.length; ++n) {
            this.components[cardFilePathComponentArray.length + n] = cardFilePath.components[n];
        }
        this.string_representation = null;
        return this;
    }

    public CardFilePath append(CardFilePathComponent cardFilePathComponent) {
        if (cardFilePathComponent instanceof CardFileAppID || cardFilePathComponent instanceof CardFilePartialAppID) {
            throw new CardIOException("attempt to append (partial) application ID " + cardFilePathComponent);
        }
        if (this.components[this.components.length - 1] instanceof CardFileShortFileID) {
            throw new CardIOException("attempt to append after short file ID " + this);
        }
        CardFilePathComponent[] cardFilePathComponentArray = this.components;
        this.components = new CardFilePathComponent[cardFilePathComponentArray.length + 1];
        for (int i = 0; i < cardFilePathComponentArray.length; ++i) {
            this.components[i] = cardFilePathComponentArray[i];
        }
        this.components[cardFilePathComponentArray.length] = cardFilePathComponent;
        this.string_representation = null;
        return this;
    }

    public boolean startsWith(CardFilePath cardFilePath) {
        if (cardFilePath.numberOfComponents() >= this.numberOfComponents()) {
            return false;
        }
        for (int i = 0; i < cardFilePath.numberOfComponents(); ++i) {
            if (cardFilePath.components[i].equals(this.components[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CardFilePath)) {
            return false;
        }
        CardFilePath cardFilePath = (CardFilePath)object;
        if (this.numberOfComponents() != cardFilePath.numberOfComponents()) {
            return false;
        }
        for (int i = 0; i < cardFilePath.numberOfComponents(); ++i) {
            if (cardFilePath.components[i].equals(this.components[i])) continue;
            return false;
        }
        return true;
    }

    public int commonPrefixLength(CardFilePath cardFilePath) {
        int n = this.components.length <= cardFilePath.components.length ? this.components.length : cardFilePath.components.length;
        int n2 = 0;
        for (n2 = 0; n2 < n && this.components[n2].equals(cardFilePath.components[n2]); ++n2) {
        }
        return n2;
    }

    public CardFilePath greatestCommonPrefix(CardFilePath cardFilePath) {
        int n = this.commonPrefixLength(cardFilePath);
        if (n == 0) {
            throw new IllegalArgumentException("no common prefix");
        }
        CardFilePath cardFilePath2 = new CardFilePath();
        cardFilePath2.components = new CardFilePathComponent[n + 1];
        for (int i = 0; i < cardFilePath2.components.length; ++i) {
            cardFilePath2.components[i] = this.components[i];
        }
        return cardFilePath2;
    }

    public CardFilePath chompPrefix(CardFilePath cardFilePath) {
        if (!this.startsWith(cardFilePath)) {
            throw new IllegalArgumentException("illegal prefix " + cardFilePath + " for path " + this.toString());
        }
        CardFilePathComponent[] cardFilePathComponentArray = this.components;
        this.components = new CardFilePathComponent[cardFilePathComponentArray.length - cardFilePath.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = cardFilePathComponentArray[cardFilePath.components.length + i];
        }
        this.string_representation = null;
        return this;
    }

    public boolean chompTail() {
        if (this.components.length == 1) {
            return false;
        }
        CardFilePathComponent[] cardFilePathComponentArray = this.components;
        this.components = new CardFilePathComponent[cardFilePathComponentArray.length - 1];
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = cardFilePathComponentArray[i];
        }
        this.string_representation = null;
        return true;
    }

    public CardFilePathComponent tail() {
        return this.components[this.components.length - 1];
    }

    public int numberOfComponents() {
        return this.components.length;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.string_representation == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.components.length; ++i) {
                stringBuffer.append(this.components[i].toString());
            }
            this.string_representation = stringBuffer.toString();
        }
        return this.string_representation;
    }
}

