/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import java.io.IOException;
import java.io.OutputStream;
import opencard.core.terminal.CardTerminalException;
import opencard.opt.iso.fs.CardFile;
import opencard.opt.iso.fs.CardIOException;
import opencard.opt.iso.fs.FileAccessCardService;

public class CardFileOutputStream
extends OutputStream {
    private FileAccessCardService fileSystem = null;
    private CardFile cf = null;
    private int filePointer = 0;
    private boolean open;

    public CardFileOutputStream(CardFile cardFile) throws IOException, CardIOException, CardTerminalException {
        this.cf = cardFile;
        this.fileSystem = cardFile.getFileAccessService();
        if (!this.cf.isTransparent()) {
            throw new CardIOException("not transparent: " + cardFile.getPath());
        }
        this.filePointer = 0;
        this.open = true;
    }

    @Override
    public void close() throws IOException, CardTerminalException {
        if (this.open) {
            this.open = false;
        }
        this.fileSystem = null;
        this.cf = null;
    }

    @Override
    public void flush() throws IOException, CardTerminalException {
    }

    @Override
    public void write(int n) throws IOException, CardTerminalException {
        byte[] byArray = new byte[]{(byte)n};
        this.fileSystem.write(this.cf.getPath(), this.filePointer, byArray);
        ++this.filePointer;
    }

    @Override
    public void write(byte[] byArray) throws IOException, CardTerminalException {
        this.fileSystem.write(this.cf.getPath(), this.filePointer, byArray);
        this.filePointer += byArray.length;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException, CardTerminalException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.write(byArray2);
    }

    protected void finalize() throws IOException {
        this.close();
    }
}

