/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import java.io.IOException;
import java.io.InputStream;
import opencard.core.terminal.CardTerminalException;
import opencard.opt.iso.fs.CardFile;
import opencard.opt.iso.fs.CardIOException;
import opencard.opt.iso.fs.FileAccessCardService;

public class CardFileInputStream
extends InputStream {
    private CardFile cf;
    private FileAccessCardService fileSystem;
    private int filePointer;
    private boolean open;

    public CardFileInputStream(CardFile cardFile) throws IOException, CardTerminalException, CardIOException {
        this.cf = cardFile;
        this.fileSystem = cardFile.getFileAccessService();
        if (!this.cf.isTransparent()) {
            throw new CardIOException("not transparent: " + cardFile.getPath());
        }
        this.filePointer = 0;
        this.open = true;
    }

    @Override
    public int available() throws IOException, CardTerminalException {
        return 0;
    }

    @Override
    public void close() throws IOException, CardTerminalException {
        if (this.open) {
            this.open = false;
        }
        this.fileSystem = null;
        this.cf = null;
    }

    @Override
    public int read() throws IOException, CardTerminalException {
        byte[] byArray = this.fileSystem.read(this.cf.getPath(), this.filePointer, 1);
        ++this.filePointer;
        return byArray == null ? -1 : byArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException, CardTerminalException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException, CardTerminalException {
        byte[] byArray2 = this.fileSystem.read(this.cf.getPath(), this.filePointer, n2);
        if (byArray2 == null) {
            return -1;
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        this.filePointer += byArray2.length;
        return byArray2.length;
    }

    @Override
    public long skip(long l) throws IOException, CardTerminalException {
        long l2 = this.filePointer;
        long l3 = l2 + l;
        long l4 = this.cf.getLength();
        if (l3 > l4) {
            l3 = l4;
        }
        this.filePointer = (int)l3;
        return l3 - l2;
    }

    protected void finalize() throws IOException {
        this.close();
    }
}

