/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import opencard.core.util.HexString;
import opencard.opt.iso.fs.CardFilePathComponent;

public class CardFileFileID
extends CardFilePathComponent {
    protected byte[] fileID = null;

    public CardFileFileID(String string) {
        super(string);
        if (!string.startsWith(":")) {
            throw new IllegalArgumentException("file ID components must start with /");
        }
        if (string.length() != 5) {
            throw new IllegalArgumentException("file ID component " + string + " must contain two bytes");
        }
        this.fileID = new byte[]{(byte)(Integer.parseInt(string.substring(1, 3), 16) & 0xFF), (byte)(Integer.parseInt(string.substring(3), 16) & 0xFF)};
    }

    public CardFileFileID(short s) {
        this(new StringBuffer(":").append(HexString.hexifyShort(s & 0xFFFF)).toString());
    }

    public CardFileFileID(byte by, byte by2) {
        this((short)((by & 0xFF) << 8 | by2 & 0xFF));
    }

    public short toShort() {
        return (short)(((this.fileID[0] & 0xFF) << 8 | this.fileID[1] & 0xFF) & 0xFFFF);
    }

    public byte[] toByteArray() {
        return this.fileID;
    }

    public void toByteArray(byte[] byArray, int n) {
        byArray[n] = this.fileID[0];
        byArray[n + 1] = this.fileID[1];
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof CardFileFileID)) {
            return false;
        }
        return this.toShort() == ((CardFileFileID)object).toShort();
    }

    public int hashCode() {
        return this.toShort();
    }
}

