/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import java.io.UnsupportedEncodingException;
import opencard.core.OpenCardConstants;
import opencard.opt.iso.fs.CardFilePathComponent;
import opencard.opt.iso.fs.CardIOException;

public class CardFileAppID
extends CardFilePathComponent
implements OpenCardConstants {
    private boolean asByteSequence = false;

    public CardFileAppID(String string) {
        super(string);
        if (string.startsWith("#")) {
            this.asByteSequence = true;
            if ((string.length() - 1) % 2 != 0) {
                throw new IllegalArgumentException("odd number of characters");
            }
        }
    }

    public byte[] toByteArray() {
        if (!this.asByteSequence) {
            try {
                return this.comp.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CardIOException("cannot retrieve byte representation for \"" + this.comp + "\" via " + "8859_1" + "encoding");
            }
        }
        int n = (this.comp.length() - 1) / 2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)(Integer.parseInt(this.comp.substring(i * 2 + 1, i * 2 + 3), 16) & 0xFF);
        }
        return byArray;
    }

    @Override
    public boolean equals(Object object) {
        byte[] byArray;
        if (!(object instanceof CardFileAppID)) {
            return false;
        }
        byte[] byArray2 = this.toByteArray();
        if (byArray2.length != (byArray = ((CardFileAppID)object).toByteArray()).length) {
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        byte[] byArray = this.toByteArray();
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n = ((n & 0xFF000000) >>> 21) + (n << 8) + byArray[i];
        }
        return n;
    }
}

