/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import java.io.FileNotFoundException;
import opencard.core.OpenCardException;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceInabilityException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.Tracer;
import opencard.opt.iso.fs.CardFileInfo;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.iso.fs.CardFilePathComponent;
import opencard.opt.iso.fs.FileAccessCardService;
import opencard.opt.iso.fs.FileSystemCardService;
import opencard.opt.service.CardServiceObjectNotAvailableException;

public class CardFile
implements CardFileInfo {
    private static final Tracer ctracer = new Tracer(CardFile.class);
    private CardFilePath file_path = null;
    private FileAccessCardService file_access = null;
    private FileSystemCardService file_system = null;
    private CardFile file_parent = null;
    protected CardFileInfo file_info = null;

    public CardFile(FileAccessCardService fileAccessCardService) throws FileNotFoundException, OpenCardException {
        this(fileAccessCardService.getRoot(), fileAccessCardService);
    }

    public CardFile(FileAccessCardService fileAccessCardService, CardFilePath cardFilePath) throws FileNotFoundException, OpenCardException {
        this(new CardFilePath(cardFilePath), fileAccessCardService);
    }

    public CardFile(FileAccessCardService fileAccessCardService, String string) throws FileNotFoundException, OpenCardException {
        this(new CardFilePath(string), fileAccessCardService);
    }

    public CardFile(CardFile cardFile, CardFilePath cardFilePath) throws FileNotFoundException, OpenCardException {
        this(new CardFilePath(cardFile.file_path).append(cardFilePath), cardFile.file_access);
        if (cardFilePath.numberOfComponents() == 1) {
            this.file_parent = cardFile;
        }
    }

    public CardFile(CardFile cardFile, String string) throws FileNotFoundException, OpenCardException {
        this(cardFile, new CardFilePath(string));
    }

    public CardFile(CardFile cardFile, CardFilePathComponent cardFilePathComponent) throws FileNotFoundException, OpenCardException {
        this(new CardFilePath(cardFile.file_path).append(cardFilePathComponent), cardFile.file_access);
        this.file_parent = cardFile;
    }

    protected CardFile(CardFilePath cardFilePath, FileAccessCardService fileAccessCardService) throws FileNotFoundException, CardServiceException, CardTerminalException {
        this.file_path = this.resolvePath(cardFilePath);
        this.file_access = fileAccessCardService;
        this.file_parent = null;
        if (fileAccessCardService instanceof FileSystemCardService) {
            this.file_system = (FileSystemCardService)fileAccessCardService;
        }
        try {
            this.file_info = fileAccessCardService.getFileInfo(cardFilePath);
        }
        catch (CardServiceObjectNotAvailableException cardServiceObjectNotAvailableException) {
            throw new FileNotFoundException(cardFilePath.toString());
        }
    }

    public final CardFilePath getCanonicalPath() {
        return this.file_path;
    }

    public CardFilePath getAbsolutePath() {
        return this.file_path;
    }

    public final CardFilePath getPath() {
        return this.getCanonicalPath();
    }

    public String getName() {
        return this.file_path.tail().toString();
    }

    @Override
    public final short getFileID() {
        return this.file_info.getFileID();
    }

    @Override
    public final boolean isDirectory() {
        return this.file_info.isDirectory();
    }

    public final boolean isFile() {
        return !this.isDirectory();
    }

    public final boolean isDF() {
        return this.isDirectory();
    }

    public final boolean isEF() {
        return this.isFile();
    }

    @Override
    public final boolean isTransparent() {
        return this.file_info.isTransparent();
    }

    @Override
    public final boolean isCyclic() {
        return this.file_info.isCyclic();
    }

    @Override
    public final boolean isVariable() {
        return this.file_info.isVariable();
    }

    @Override
    public final int getLength() {
        return this.file_info.getLength();
    }

    @Override
    public final int getRecordSize() {
        return this.file_info.getRecordSize();
    }

    @Override
    public final byte[] getHeader() {
        if (this.file_info == null) {
            return null;
        }
        return this.file_info.getHeader();
    }

    protected final FileAccessCardService getFileAccessService() {
        return this.file_access;
    }

    protected final FileSystemCardService getFileSystemService() {
        return this.file_system;
    }

    protected CardFilePath resolvePath(CardFilePath cardFilePath) {
        return cardFilePath;
    }

    public CardFile getParent() {
        if (this.file_parent == null) {
            CardFilePath cardFilePath = new CardFilePath(this.file_path);
            try {
                if (cardFilePath.chompTail()) {
                    this.file_parent = new CardFile(this, cardFilePath);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.file_parent;
    }

    public boolean exists(CardFilePath cardFilePath) {
        CardFilePath cardFilePath2 = new CardFilePath(this.file_path);
        cardFilePath2.append(cardFilePath);
        boolean bl = false;
        try {
            bl = this.file_access.exists(cardFilePath2);
        }
        catch (CardServiceObjectNotAvailableException cardServiceObjectNotAvailableException) {
        }
        catch (OpenCardException openCardException) {
            // empty catch block
        }
        return bl;
    }

    public final CardFileInfo getFileInfo() {
        return this.file_info;
    }

    public final void create(byte[] byArray) throws CardServiceInabilityException, OpenCardException {
        if (this.file_system == null) {
            throw new CardServiceInabilityException("create() requires FileSystemCardService");
        }
        this.file_system.create(this.file_path, byArray);
    }

    public void delete(CardFilePath cardFilePath) throws CardServiceInabilityException, OpenCardException {
        if (this.file_system == null) {
            throw new CardServiceInabilityException("delete() requires FileSystemCardService");
        }
        CardFilePath cardFilePath2 = new CardFilePath(this.file_path);
        cardFilePath2.append(cardFilePath);
        this.file_system.delete(cardFilePath2);
    }

    public int hashCode() {
        return this.file_path.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CardFile ");
        stringBuffer.append(this.getAbsolutePath());
        return stringBuffer.toString();
    }
}

