/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.emv.mgmt;

import java.util.Vector;
import opencard.core.OpenCardConstants;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.Tracer;
import opencard.opt.applet.mgmt.AbstractAppletAccessor;
import opencard.opt.applet.mgmt.AppletAccessCardService;
import opencard.opt.applet.mgmt.InvalidAppletInfoException;
import opencard.opt.emv.mgmt.EMVAppletInfo;
import opencard.opt.emv.mgmt.EMVTags;
import opencard.opt.util.TLV;

public class BasicEMVAppletAccess
extends AbstractAppletAccessor
implements AppletAccessCardService,
OpenCardConstants,
EMVTags {
    private Tracer itracer = new Tracer((Object)this, BasicEMVAppletAccess.class);
    private static Tracer ctracer = new Tracer(BasicEMVAppletAccess.class);
    public static final byte CLASS = 0;
    public static final byte SELECT_INS = -92;
    public static final byte SELECT_P1 = 0;
    public static final byte SELECT_P2 = 0;
    public static final byte SELECT_LE = 0;
    public static final byte READ_INS = -78;
    public static final byte READ_P2 = 4;
    public static final byte READ_LE = 0;
    public static byte[] DIR_PATH = new byte[]{47, 0};
    public static final int SW_OK = 36864;
    public static final int SW_WRONG_LENGTH = 26368;
    public static final int SW_INCORRECT_INS = 28160;
    public static final int SW_INCORRECT_CLA = 27904;
    public static final int SW_INCORRECT_P1P2 = 27270;
    public static final int SW_INCORRECT_LC = 27271;
    public static final int SW_DATA_CORRUPTED = 25217;
    public static final int SW_INCOMPATIBLE = 27009;
    public static final int SW_NOTSUPPORTED = 27265;
    public static final int SW_FILENOTFOUND = 27266;
    public static final int SW_MFCFILENOTFOUND = 37892;
    public static final int SW_RECORDNOTFOUND = 27267;
    public static final int SW_FILEINVALIDATED = 25219;
    public static final byte SW1_INCORRECT_P1P2 = 106;
    public static final byte SW1_RESPONSE_PENDING = 97;
    public static final byte SW1_INCORRECT_LE = 108;

    @Override
    public void initialize(CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws CardServiceException {
        super.initialize(cardServiceScheduler, smartCard, bl);
        this.setApplets(this.internalList(cardServiceScheduler.getSlotChannel()));
    }

    @Override
    protected Vector internalList(SlotChannel slotChannel) throws CardServiceException {
        Vector<EMVAppletInfo> vector = new Vector<EMVAppletInfo>();
        boolean bl = false;
        int n = 0;
        try {
            this.selectDirectory(slotChannel);
            while (!bl) {
                try {
                    byte[] byArray = this.readRecord(slotChannel, ++n);
                    if (byArray == null) {
                        bl = true;
                        this.itracer.info("list", "End of EF_DIR has been reached!");
                        continue;
                    }
                    EMVAppletInfo eMVAppletInfo = new EMVAppletInfo(new TLV(byArray));
                    vector.addElement(eMVAppletInfo);
                }
                catch (InvalidAppletInfoException invalidAppletInfoException) {
                    this.itracer.info("list", "Invalid Application Info was ignored!");
                }
            }
        }
        catch (CardTerminalException cardTerminalException) {
            this.itracer.info("list", "CardTerminalException - abort!");
        }
        return vector;
    }

    private void selectDirectory(SlotChannel slotChannel) throws CardTerminalException {
        CommandAPDU commandAPDU = new CommandAPDU(5 + DIR_PATH.length);
        commandAPDU.append((byte)0);
        commandAPDU.append((byte)-92);
        commandAPDU.append((byte)0);
        commandAPDU.append((byte)0);
        commandAPDU.append((byte)DIR_PATH.length);
        commandAPDU.append(DIR_PATH);
        ResponseAPDU responseAPDU = slotChannel.sendAPDU(commandAPDU);
        if (responseAPDU.sw() != 36864) {
            this.itracer.error("list", "error occurred while selecting info information file (" + responseAPDU.sw() + ")");
            this.itracer.error("list", "Command Sent:" + commandAPDU.toString());
            this.itracer.error("list", "Response returned:" + responseAPDU.toString());
            this.traceResponseCode(responseAPDU);
            throw new CardTerminalException();
        }
    }

    private byte[] readRecord(SlotChannel slotChannel, int n) throws CardTerminalException {
        CommandAPDU commandAPDU = new CommandAPDU(5);
        commandAPDU.append((byte)0);
        commandAPDU.append((byte)-78);
        commandAPDU.append((byte)n);
        commandAPDU.append((byte)4);
        commandAPDU.append((byte)0);
        ResponseAPDU responseAPDU = slotChannel.sendAPDU(commandAPDU);
        if (responseAPDU != null && responseAPDU.sw() == 36864) {
            return responseAPDU.data();
        }
        this.itracer.debug("list", "Command Sent:" + commandAPDU.toString());
        this.itracer.debug("list", "Response returned:" + responseAPDU.toString());
        if (responseAPDU.sw() != 36864) {
            this.itracer.debug("list", "Error reading EF_DIR! (" + responseAPDU.sw() + ")");
            this.traceResponseCode(responseAPDU);
        } else {
            this.itracer.debug("list", "No data returned from EF_DIR!");
        }
        return null;
    }

    private void traceResponseCode(ResponseAPDU responseAPDU) {
        if (responseAPDU.sw() == 27266 || responseAPDU.sw() == 37892) {
            this.itracer.debug("list", "File not found");
        } else if (responseAPDU.sw() == 26368) {
            this.itracer.debug("list", "Wrong length specified");
        } else if (responseAPDU.sw() == 28160) {
            this.itracer.debug("list", "Invalid Instruction Byte");
        } else if (responseAPDU.sw() == 27904) {
            this.itracer.debug("list", "Invalid Class Byte");
        } else if (responseAPDU.sw() == 27271) {
            this.itracer.debug("list", "Wrong command length specified");
        } else if (responseAPDU.sw() == 25217) {
            this.itracer.debug("list", "Returned data corrupted");
        } else if (responseAPDU.sw() == 27009) {
            this.itracer.debug("list", "Record File incompatible with file struccture");
        } else if (responseAPDU.sw() == 27265) {
            this.itracer.debug("list", "command not supported");
        } else if (responseAPDU.sw() == 27266) {
            this.itracer.debug("list", "File not found");
        } else if (responseAPDU.sw() == 27267) {
            this.itracer.debug("list", "Record not found");
        } else if (responseAPDU.sw() == 25219) {
            this.itracer.debug("list", "File is invalidated");
        }
        if (responseAPDU.sw1() == 106) {
            this.itracer.debug("list", "Directory File not found on this card");
        } else if (responseAPDU.sw1() == 97) {
            this.itracer.debug("list", "Response from Card is pending");
        } else if (responseAPDU.sw1() == 108) {
            this.itracer.debug("list", "Wrong expected length specified");
        }
    }
}

