/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.applet;

import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.Tracer;
import opencard.opt.applet.AppletID;
import opencard.opt.applet.AppletInfo;
import opencard.opt.applet.AppletSelector;
import opencard.opt.service.CardServiceUnexpectedResponseException;

public class ISOAppletSelector
implements AppletSelector {
    protected static final byte SELECT_CLASS = 0;
    protected static final byte SELECT_INS = -92;
    protected static final byte SELECT_P1 = 4;
    protected static final byte SELECT_P2 = 0;
    protected static final short SW_OK = -28672;
    protected static final byte SELECT_SW1_WARNING = 98;
    protected static final byte SELECT_SW1_ERROR = 106;
    protected static final byte SELECT_SW2_INVALID = -125;
    protected static final byte SELECT_SW2_UNFORMAT = -124;
    protected static final byte SELECT_SW2_UNSUPPORTED = -127;
    protected static final byte SELECT_SW2_NOTFOUND = -126;
    protected static final byte SELECT_SW2_INCORRECTP1P2 = -122;
    protected static final byte SELECT_SW2_INCORRECTLC = -121;
    protected static final int MAX_APDU_SIZE = 192;
    private static Tracer ctracer = new Tracer(ISOAppletSelector.class);

    @Override
    public synchronized AppletInfo selectApplet(CardChannel cardChannel, AppletID appletID) throws CardTerminalException, CardServiceException {
        CommandAPDU commandAPDU = null;
        ResponseAPDU responseAPDU = null;
        AppletInfo appletInfo = null;
        if (cardChannel == null) {
            throw new CardServiceException("selectApplet: No CardChannel!");
        }
        ctracer.debug("selectApplet", "selecting " + appletID);
        commandAPDU = new CommandAPDU(6 + appletID.getBytes().length);
        commandAPDU.setLength(0);
        commandAPDU.append((byte)0);
        commandAPDU.append((byte)-92);
        commandAPDU.append((byte)4);
        commandAPDU.append((byte)0);
        commandAPDU.append((byte)appletID.getBytes().length);
        commandAPDU.append(appletID.getBytes());
        responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
        ctracer.debug("selectApplet", "Selection response sw = 0x" + Integer.toHexString(responseAPDU.sw()));
        switch ((short)(responseAPDU.sw() & 0xFFFF)) {
            case -28672: {
                appletInfo = new AppletInfo();
                appletInfo.setAppletID(appletID);
                appletInfo.setData(responseAPDU);
                break;
            }
            default: {
                throw new CardServiceUnexpectedResponseException("Status Words are 0x" + Integer.toHexString((short)(responseAPDU.sw() & 0xFFFF)));
            }
        }
        return appletInfo;
    }
}

