/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;
import opencard.core.event.TracerEvent;
import opencard.core.event.TracerListener;
import opencard.core.util.SystemAccess;

public class Tracer {
    private static String[] traceList = new String[0];
    private static int[] traceLevels = new int[0];
    private static boolean eventsOnly = false;
    private static boolean condensed = false;
    private static Hashtable tracerListeners = new Hashtable();
    private String myClass;
    private Object me;

    public Tracer(Object object, String string) {
        this.myClass = string;
        this.me = object;
    }

    public static void init() {
        try {
            SystemAccess systemAccess = SystemAccess.getSystemAccess();
            String string = systemAccess.getProperty("OpenCard.trace", "");
            eventsOnly = systemAccess.getBoolean("OpenCard.trace.eventsOnly");
            condensed = systemAccess.getBoolean("OpenCard.trace.condensed");
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = stringTokenizer.countTokens();
            traceList = new String[n];
            traceLevels = new int[n];
            for (int i = 0; i < n; ++i) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
                Tracer.traceList[i] = stringTokenizer2.nextToken();
                try {
                    Tracer.traceLevels[i] = stringTokenizer2.hasMoreTokens() ? Integer.parseInt(stringTokenizer2.nextToken()) : 8;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    Tracer.traceLevels[i] = 8;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public Tracer(Object object, Class clazz) {
        this(object, clazz.getName());
    }

    public Tracer(Class clazz) {
        this((Object)clazz, clazz.getName());
    }

    public int getTraceLevel() {
        int n = -1;
        for (int i = 0; i < traceList.length; ++i) {
            if (traceList[i] == null || !this.myClass.startsWith(traceList[i])) continue;
            n = traceLevels[i];
        }
        return n;
    }

    public static void trace(Object object, String string, int n, String string2, String string3, Throwable throwable) {
        if (string3 == null && throwable == null) {
            return;
        }
        if (string != null) {
            if (traceList == null) {
                return;
            }
            for (int i = 0; i < traceList.length; ++i) {
                Object object2;
                Object object3;
                TracerEvent tracerEvent;
                if (traceList[i] == null || !string.startsWith(traceList[i]) || n > traceLevels[i]) continue;
                TracerEvent tracerEvent2 = tracerEvent = string3 != null ? new TracerEvent(n, object, string2, Thread.currentThread(), string3) : new TracerEvent(n, object, string2, Thread.currentThread(), throwable);
                if (!eventsOnly) {
                    PrintWriter printWriter;
                    StringWriter stringWriter;
                    object3 = new StringBuffer(tracerEvent.getLevelName()).append(" ");
                    if (tracerEvent.getSource() instanceof Class) {
                        ((StringBuffer)object3).append(((Class)tracerEvent.getSource()).getName()).append(".");
                    } else {
                        ((StringBuffer)object3).append(tracerEvent.getSource().getClass().getName()).append(".");
                    }
                    if (condensed) {
                        ((StringBuffer)object3).append(tracerEvent.getMethodName());
                        if (tracerEvent.getMessage() != null) {
                            ((StringBuffer)object3).append(":").append(tracerEvent.getMessage());
                        } else {
                            object2 = tracerEvent.getThrowable();
                            stringWriter = new StringWriter();
                            printWriter = new PrintWriter(stringWriter);
                            ((Throwable)object2).printStackTrace(printWriter);
                            printWriter.flush();
                            ((StringBuffer)object3).append("--- throwable ").append(stringWriter.toString());
                        }
                    } else {
                        ((StringBuffer)object3).append(tracerEvent.getMethodName()).append("\n");
                        if (tracerEvent.getMessage() != null) {
                            ((StringBuffer)object3).append("--- message   ").append(tracerEvent.getMessage()).append("\n");
                        } else {
                            object2 = tracerEvent.getThrowable();
                            stringWriter = new StringWriter();
                            printWriter = new PrintWriter(stringWriter);
                            ((Throwable)object2).printStackTrace(printWriter);
                            printWriter.flush();
                            ((StringBuffer)object3).append("--- throwable ").append(stringWriter.toString()).append("\n");
                        }
                        ((StringBuffer)object3).append("--- thread    ").append(tracerEvent.getThread()).append("\n");
                        ((StringBuffer)object3).append("--- source    ").append(tracerEvent.getSource()).append("\n");
                    }
                    System.out.println(((StringBuffer)object3).toString());
                }
                if (tracerListeners.isEmpty()) break;
                object3 = null;
                object2 = tracerListeners.elements();
                while (object2.hasMoreElements()) {
                    object3 = (TracerListener)object2.nextElement();
                    object3.traceEvent(tracerEvent);
                }
                break;
            }
        }
    }

    protected void trace(int n, String string, String string2) {
        Tracer.trace(this.me, this.myClass, n, string, string2, null);
    }

    protected void trace(int n, String string, Throwable throwable) {
        Tracer.trace(this.me, this.myClass, n, string, null, throwable);
    }

    public void debug(String string, String string2) {
        this.trace(7, string, string2);
    }

    public void debug(String string, Throwable throwable) {
        this.trace(7, string, throwable);
    }

    public void info(String string, String string2) {
        this.trace(6, string, string2);
    }

    public void info(String string, Throwable throwable) {
        this.trace(6, string, throwable);
    }

    public void notice(String string, String string2) {
        this.trace(5, string, string2);
    }

    public void notice(String string, Throwable throwable) {
        this.trace(5, string, throwable);
    }

    public void warning(String string, String string2) {
        this.trace(4, string, string2);
    }

    public void warning(String string, Throwable throwable) {
        this.trace(4, string, throwable);
    }

    public void error(String string, String string2) {
        this.trace(3, string, string2);
    }

    public void error(String string, Throwable throwable) {
        this.trace(3, string, throwable);
    }

    public void critical(String string, String string2) {
        this.trace(2, string, string2);
    }

    public void critical(String string, Throwable throwable) {
        this.trace(2, string, throwable);
    }

    public void alert(String string, String string2) {
        this.trace(1, string, string2);
    }

    public void alert(String string, Throwable throwable) {
        this.trace(1, string, throwable);
    }

    public void emergency(String string, String string2) {
        this.trace(0, string, string2);
    }

    public void emergency(String string, Throwable throwable) {
        this.trace(0, string, throwable);
    }

    public static void addTracerListener(TracerListener tracerListener) {
        Tracer.trace(Tracer.class, Tracer.class.getName(), 7, "addTracerListener", "adding " + tracerListener, null);
        tracerListeners.put(tracerListener, tracerListener);
        Tracer.trace(Tracer.class, Tracer.class.getName(), 7, "addTracerListener", "tracerListener " + tracerListeners, null);
    }

    public static void removeTracerListener(TracerListener tracerListener) {
        tracerListeners.remove(tracerListener);
    }
}

