/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.util;

public class HexString {
    protected static final String[] hexChars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    public static String dump(byte[] byArray) {
        return HexString.dump(byArray, 0, byArray.length);
    }

    public static String dump(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return "null";
        }
        char[] cArray = new char[16];
        StringBuffer stringBuffer = new StringBuffer(256);
        if (n + n2 > byArray.length) {
            n2 = byArray.length - n;
        }
        int n3 = n;
        while (n3 < n + n2) {
            stringBuffer.append(HexString.hexify(n3 >>> 8 & 0xFF));
            stringBuffer.append(HexString.hexify(n3 & 0xFF));
            stringBuffer.append(":  ");
            int n4 = 0;
            while (n4 < 16) {
                if (n3 < n + n2) {
                    int n5 = byArray[n3] & 0xFF;
                    stringBuffer.append(HexString.hexify(n5)).append(' ');
                    cArray[n4] = n5 >= 32 && n5 < 127 ? (int)n5 : 46;
                } else {
                    stringBuffer.append("   ");
                    cArray[n4] = 32;
                }
                ++n4;
                ++n3;
            }
            stringBuffer.append(' ').append(cArray).append("\n");
        }
        return stringBuffer.toString();
    }

    public static String hexify(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(hexChars[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(hexChars[byArray[i] & 0xF]);
            if (++n != 16) continue;
            stringBuffer.append('\n');
            n = 0;
        }
        return stringBuffer.toString();
    }

    public static String hexify(int n) {
        return hexChars[(n & 0xFF & 0xF0) >>> 4] + hexChars[n & 0xF];
    }

    public static String hexifyShort(byte by, byte by2) {
        return HexString.hexifyShort(by & 0xFF, by2 & 0xFF);
    }

    public static String hexifyShort(int n) {
        return hexChars[(n & 0xFFFF & 0xF000) >>> 12] + hexChars[(n & 0xFFF & 0xF00) >>> 8] + hexChars[(n & 0xFF & 0xF0) >>> 4] + hexChars[n & 0xF];
    }

    public static String hexifyShort(int n, int n2) {
        return HexString.hexifyShort(((n & 0xFF) << 8) + (n2 & 0xFF));
    }

    public static byte[] parseHexString(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            String string2 = string.substring(i, i + 2);
            byArray[i / 2] = (byte)Integer.parseInt(string2, 16);
        }
        return byArray;
    }

    public static byte[] parseLittleEndianHexString(String string) {
        byte[] byArray = new byte[string.length() / 2 + 1];
        for (int i = 0; i < string.length(); i += 2) {
            String string2 = string.substring(i, i + 2);
            byArray[(string.length() - i) / 2] = (byte)Integer.parseInt(string2, 16);
        }
        byArray[0] = 0;
        return byArray;
    }
}

