/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.terminal;

import opencard.core.OpenCardRuntimeException;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.Tracer;

public final class Slot {
    private Tracer itracer = new Tracer((Object)this, Slot.class);
    protected CardTerminal terminal;
    protected int slotID;

    public Slot(CardTerminal cardTerminal, int n) {
        if (cardTerminal == null) {
            throw new OpenCardRuntimeException("terminal is null");
        }
        if (n < 0) {
            throw new OpenCardRuntimeException("slotID < 0");
        }
        this.terminal = cardTerminal;
        this.slotID = n;
    }

    public boolean isCardPresent() throws CardTerminalException {
        return this.terminal.isCardPresent(this.slotID);
    }

    public CardID getCardID(int n) throws CardTerminalException {
        return this.terminal.getCardID(this.slotID);
    }

    public CardID getCardID() throws CardTerminalException {
        return this.terminal.getCardID(this.slotID);
    }

    public CardTerminal getCardTerminal() {
        return this.terminal;
    }

    public int getSlotID() {
        return this.slotID;
    }
}

