/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.terminal;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.InvalidSlotChannelException;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.Slot;
import opencard.core.terminal.SlotChannel;
import opencard.core.terminal.VerifiedAPDUInterface;
import opencard.core.util.Tracer;

public abstract class CardTerminal {
    private Tracer itracer = new Tracer((Object)this, CardTerminal.class);
    private static Tracer ctracer = new Tracer(CardTerminal.class);
    private Vector channels = new Vector();
    protected Vector slots = new Vector();
    private int slotCount = 0;
    protected final String name;
    protected final String type;
    protected final String address;
    private Object ctListenerMonitor = new String("ctListenerMonitor");

    protected CardTerminal(String string, String string2, String string3) {
        ctracer.debug("<init>", "(" + string + ", " + string2 + ", " + string3 + ")");
        this.name = string;
        this.type = string2;
        this.address = string3;
    }

    public Enumeration enumerateSlots() {
        return this.slots.elements();
    }

    public final Properties features() {
        Properties properties = new Properties();
        this.internalFeatures(properties);
        if (properties == null) {
            this.itracer.debug("features ", "implementation error in terminal class -> got 'null' instead of Enumeration object");
            properties = new Properties();
        }
        properties.put("name", this.getName());
        properties.put("type", this.getType());
        properties.put("address", this.getAddress());
        properties.put("slots", String.valueOf(this.slotCount));
        return properties;
    }

    public String getAddress() {
        return this.address;
    }

    public abstract CardID getCardID(int var1) throws CardTerminalException;

    public CardID getCardID(int n, int n2) throws CardTerminalException {
        return this.getCardID(n);
    }

    public String getName() {
        return this.name;
    }

    public Slot getSlot(int n) throws IndexOutOfBoundsException {
        if (n >= this.slots.size()) {
            throw new IndexOutOfBoundsException("slotID too large");
        }
        return (Slot)this.slots.elementAt(n);
    }

    public String getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Slot[] slots() {
        Vector vector = this.slots;
        synchronized (vector) {
            Object[] objectArray = new Slot[this.slots.size()];
            this.slots.copyInto(objectArray);
            return objectArray;
        }
    }

    public int getSlots() {
        return this.slotCount;
    }

    public abstract boolean isCardPresent(int var1) throws CardTerminalException;

    public boolean isCardPresent(Slot slot) throws CardTerminalException {
        return this.isCardPresent(slot.getSlotID());
    }

    public synchronized boolean isSlotChannelAvailable(int n) {
        return this.getSlotChannel(n) == null;
    }

    public synchronized boolean isSlotChannelAvailable(Slot slot) {
        return this.isSlotChannelAvailable(slot.getSlotID());
    }

    public abstract void open() throws CardTerminalException;

    public abstract void close() throws CardTerminalException;

    public final SlotChannel openSlotChannel(int n) throws InvalidSlotChannelException, IndexOutOfBoundsException, CardTerminalException {
        return this.openSlotChannel(n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SlotChannel openSlotChannel(int n, Object object) throws InvalidSlotChannelException, IndexOutOfBoundsException, CardTerminalException {
        this.itracer.debug("openSlotChannel", "for slot #" + n);
        if (object == null) {
            this.internalOpenSlotChannel(n);
        } else {
            this.internalOpenSlotChannel(n, object);
        }
        if (n >= this.slots.size()) {
            throw new IndexOutOfBoundsException("slot id out of bounds");
        }
        SlotChannel slotChannel = null;
        Vector vector = this.channels;
        synchronized (vector) {
            if (!this.isSlotChannelAvailable(n)) {
                throw new InvalidSlotChannelException("slot channel already allocated", this);
            }
            slotChannel = new SlotChannel(this, n, object);
            this.channels.addElement(slotChannel);
        }
        this.itracer.debug("openSlotChannel", "new SlotChannel is " + slotChannel);
        return slotChannel;
    }

    public final synchronized SlotChannel openSlotChannel(Slot slot) throws InvalidSlotChannelException, IndexOutOfBoundsException, CardTerminalException {
        return this.openSlotChannel(slot.getSlotID(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeSlotChannel(SlotChannel slotChannel) throws InvalidSlotChannelException, CardTerminalException {
        this.assertSlotChannelValid(slotChannel);
        Vector vector = this.channels;
        synchronized (vector) {
            this.channels.removeElement(slotChannel);
        }
        this.internalCloseSlotChannel(slotChannel);
    }

    public final CardID reset(SlotChannel slotChannel, int n) throws InvalidSlotChannelException, CardTerminalException {
        return this.reset(slotChannel);
    }

    public final CardID reset(SlotChannel slotChannel) throws InvalidSlotChannelException, CardTerminalException {
        this.assertSlotChannelValid(slotChannel);
        return this.internalReset(slotChannel.getSlotNumber(), -1);
    }

    public final CardID reset(SlotChannel slotChannel, boolean bl) throws InvalidSlotChannelException, CardTerminalException {
        this.assertSlotChannelValid(slotChannel);
        return this.internalReset(slotChannel.getSlotNumber(), bl);
    }

    public final ResponseAPDU sendAPDU(SlotChannel slotChannel, CommandAPDU commandAPDU) throws InvalidSlotChannelException, CardTerminalException {
        this.assertSlotChannelValid(slotChannel);
        return this.internalSendAPDU(slotChannel.getSlotNumber(), commandAPDU, -1);
    }

    public final ResponseAPDU sendAPDU(SlotChannel slotChannel, CommandAPDU commandAPDU, int n) throws InvalidSlotChannelException, CardTerminalException {
        this.assertSlotChannelValid(slotChannel);
        return this.internalSendAPDU(slotChannel.getSlotNumber(), commandAPDU, n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("\n");
        stringBuffer.append("+ name    ").append(this.name).append("\n");
        stringBuffer.append("+ type    ").append(this.type).append("\n");
        stringBuffer.append("+ addr    ").append(this.address);
        return stringBuffer.toString();
    }

    protected void addSlots(int n) throws CardTerminalException {
        this.slotCount += n;
        for (int i = 0; i < n; ++i) {
            this.slots.addElement(new Slot(this, i));
        }
        this.slots.trimToSize();
    }

    protected void cardRemoved(int n) {
        this.itracer.debug("cardRemoved", "slotID " + n);
        CardTerminalRegistry.getRegistry().cardRemoved(this, n);
    }

    protected void cardInserted(int n) {
        this.itracer.debug("cardInserted", "slotID " + n + ", " + ")");
        CardTerminalRegistry.getRegistry().cardInserted(this, n);
    }

    protected Properties internalFeatures(Properties properties) {
        return properties;
    }

    protected void internalOpenSlotChannel(int n) throws CardTerminalException {
    }

    protected void internalOpenSlotChannel(int n, Object object) throws CardTerminalException {
        this.internalOpenSlotChannel(n);
    }

    protected void internalCloseSlotChannel(SlotChannel slotChannel) throws CardTerminalException {
    }

    protected abstract CardID internalReset(int var1, int var2) throws CardTerminalException;

    protected CardID internalReset(int n, boolean bl) throws CardTerminalException {
        return this.internalReset(n, -1);
    }

    protected abstract ResponseAPDU internalSendAPDU(int var1, CommandAPDU var2, int var3) throws CardTerminalException;

    private void assertSlotChannelValid(SlotChannel slotChannel) throws InvalidSlotChannelException {
        if (this.getSlotChannel(slotChannel.getSlotNumber()) != slotChannel) {
            throw new InvalidSlotChannelException("illegal SlotChannel", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SlotChannel getSlotChannel(int n) {
        Vector vector = this.channels;
        synchronized (vector) {
            Enumeration enumeration = this.channels.elements();
            while (enumeration.hasMoreElements()) {
                SlotChannel slotChannel = (SlotChannel)enumeration.nextElement();
                if (slotChannel.getSlotNumber() != n) continue;
                return slotChannel;
            }
        }
        return null;
    }

    public ResponseAPDU sendVerifiedCommandAPDU(SlotChannel slotChannel, CommandAPDU commandAPDU, CHVControl cHVControl, int n) throws CardTerminalException {
        VerifiedAPDUInterface verifiedAPDUInterface = (VerifiedAPDUInterface)((Object)this);
        return verifiedAPDUInterface.sendVerifiedCommandAPDU(slotChannel, commandAPDU, cHVControl);
    }
}

