/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.terminal;

import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.Slot;
import opencard.core.util.HexString;

public class CardID {
    protected byte[] atr;
    protected byte[] historicals;
    protected int slotNr = 0;
    protected CardTerminal terminal = null;
    protected String cachedResult = null;

    public CardID(byte[] byArray) throws CardTerminalException {
        this.atr = (byte[])byArray.clone();
        if (this.atr.length < 2) {
            throw new CardTerminalException("Illegal ATR response (length " + this.atr.length + " < 2): " + HexString.hexify(byArray));
        }
        if ((this.atr[0] == 59 || this.atr[0] == 63) && (this.atr[1] & 0xF) > 0) {
            this.historicals = new byte[this.atr[1] & 0xF];
            int n = 1;
            boolean bl = true;
            while (bl) {
                bl = (this.atr[n] & 0x80) != 0;
                n += ((this.atr[n] & 0x80) >>> 7) + ((this.atr[n] & 0x40) >>> 6) + ((this.atr[n] & 0x20) >>> 5) + ((this.atr[n] & 0x10) >>> 4);
            }
            System.arraycopy(this.atr, ++n, this.historicals, 0, this.historicals.length);
            int n2 = this.historicals.length - 1;
        }
    }

    public CardID(Slot slot, byte[] byArray) throws CardTerminalException {
        this(byArray);
        this.slotNr = slot.getSlotID();
        this.terminal = slot.getCardTerminal();
    }

    public CardID(CardTerminal cardTerminal, int n, byte[] byArray) throws CardTerminalException {
        this(byArray);
        this.slotNr = n;
        this.terminal = cardTerminal;
    }

    public byte[] getATR() {
        return this.atr != null ? (byte[])this.atr.clone() : null;
    }

    public byte[] getHistoricals() {
        return this.historicals != null ? (byte[])this.historicals.clone() : null;
    }

    public Slot getSlot() {
        return new Slot(this.terminal, this.slotNr);
    }

    public int getSlotID() {
        return this.slotNr;
    }

    public CardTerminal getCardTerminal() {
        return this.terminal;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CardID)) {
            return false;
        }
        CardID cardID = (CardID)object;
        if (cardID.atr.length != this.atr.length) {
            return false;
        }
        for (int i = 0; i < this.atr.length; ++i) {
            if (this.atr[i] == cardID.atr[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.cachedResult == null) {
            this.cachedResult = super.toString() + " ATR: " + HexString.hexify(this.atr);
        }
        return this.cachedResult;
    }
}

