/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.service.CardRequest;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.Tracer;

class CardWaiter
implements CTListener {
    private static Tracer ctracer = new Tracer(CardWaiter.class);
    private SmartCard smartCard_ = null;
    private CardRequest cardRequest_ = null;
    private Object lockHandle_ = null;
    private CardTerminalException cardTerminalException_ = null;

    public CardWaiter(CardRequest cardRequest, Object object) throws CardTerminalException {
        ctracer.debug("<init>", "Request: " + cardRequest);
        this.cardRequest_ = cardRequest;
        this.lockHandle_ = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cardInserted(CardTerminalEvent cardTerminalEvent) {
        block9: {
            if (this.smartCard_ == null) {
                ctracer.debug("cardInserted", "CTEvent: " + cardTerminalEvent);
                try {
                    this.smartCard_ = SmartCard.getSmartCard(cardTerminalEvent, this.cardRequest_, this.lockHandle_);
                    if (this.smartCard_ == null) break block9;
                    CardWaiter cardWaiter = this;
                    synchronized (cardWaiter) {
                        this.notify();
                    }
                }
                catch (CardTerminalException cardTerminalException) {
                    this.cardTerminalException_ = cardTerminalException;
                    CardWaiter cardWaiter = this;
                    synchronized (cardWaiter) {
                        this.notify();
                    }
                }
            }
        }
    }

    @Override
    public void cardRemoved(CardTerminalEvent cardTerminalEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SmartCard waitForCard() throws CardTerminalException {
        long l = this.cardRequest_.getTimeout() * 1000;
        if (this.cardRequest_.getWaitBehavior() == 1) {
            EventGenerator.getGenerator().createEventsForPresentCards(this);
        }
        try {
            EventGenerator.getGenerator().addCTListener(this);
            while (!(this.cardRequest_.isTimeoutSet() && l <= 0L || this.smartCard_ != null)) {
                long l2 = System.currentTimeMillis();
                try {
                    if (this.cardRequest_.isTimeoutSet()) {
                        this.wait(l);
                    } else {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l -= System.currentTimeMillis() - l2;
                if (this.cardTerminalException_ == null) continue;
                throw this.cardTerminalException_;
            }
            ctracer.debug("waitForCard", "SmartCard obtained: " + this.smartCard_);
            SmartCard smartCard = this.smartCard_;
            return smartCard;
        }
        finally {
            EventGenerator.getGenerator().removeCTListener(this);
        }
    }
}

