/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.CardIDFilter;
import opencard.core.service.CardRequest;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardType;
import opencard.core.service.PrimaryCardServiceFactory;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.Tracer;

public final class CardServiceRegistry {
    private Tracer itracer = new Tracer((Object)this, CardServiceRegistry.class);
    private static Tracer ctracer = new Tracer(CardServiceRegistry.class);
    private static final CardServiceRegistry registry = new CardServiceRegistry();
    private Vector factories = new Vector();
    private Hashtable slot2channel = new Hashtable();

    private CardServiceRegistry() {
        ctracer.debug("<init>", "instantiating");
    }

    public void add(CardServiceFactory cardServiceFactory) {
        this.itracer.debug("add", " " + cardServiceFactory);
        this.factories.addElement(cardServiceFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CardServiceScheduler allocateCardServiceScheduler(SlotChannel slotChannel) throws CardTerminalException {
        CardServiceScheduler cardServiceScheduler = null;
        SlotChannel slotChannel2 = slotChannel;
        synchronized (slotChannel2) {
            cardServiceScheduler = (CardServiceScheduler)slotChannel.getScheduler();
            if (cardServiceScheduler == null) {
                this.itracer.debug("allocateCardServiceScheduler", "instantiating CardServiceScheduler");
                cardServiceScheduler = new CardServiceScheduler(slotChannel);
                slotChannel.setScheduler(cardServiceScheduler);
                Enumeration enumeration = this.getCardServiceFactories();
                while (enumeration.hasMoreElements()) {
                    CardServiceFactory cardServiceFactory = (CardServiceFactory)enumeration.nextElement();
                    if (!(cardServiceFactory instanceof PrimaryCardServiceFactory)) continue;
                    this.itracer.debug("allocateCardServiceScheduler", "setting up card via PrimaryCardServiceFactory" + cardServiceFactory);
                    ((PrimaryCardServiceFactory)((Object)cardServiceFactory)).setupSmartCard(slotChannel);
                    break;
                }
            }
        }
        return cardServiceScheduler;
    }

    protected Class getCardServiceClassFor(Class clazz, CardID cardID, CardServiceScheduler cardServiceScheduler) {
        this.itracer.debug("getCardServiceClass", "for " + clazz + " and " + cardID);
        Enumeration enumeration = this.getCardServiceFactories();
        while (enumeration.hasMoreElements()) {
            CardServiceFactory cardServiceFactory = (CardServiceFactory)enumeration.nextElement();
            this.itracer.debug("getCardServiceClass", "checking " + cardServiceFactory);
            CardType cardType = cardServiceScheduler.getCardTypeFor(cardServiceFactory);
            if (cardType == null) {
                try {
                    cardType = cardServiceFactory.getCardType(cardID, cardServiceScheduler);
                    cardServiceScheduler.setCardTypeFor(cardServiceFactory, cardType);
                }
                catch (CardTerminalException cardTerminalException) {
                    this.itracer.debug("getCardServiceClass", cardTerminalException);
                    cardTerminalException.printStackTrace();
                    continue;
                }
            }
            if (CardType.UNSUPPORTED == cardType) continue;
            Class clazz2 = cardServiceFactory.getClassFor(clazz, cardType);
            this.itracer.debug("getCardServiceClass", "factory " + cardServiceFactory + " produced " + clazz2);
            if (clazz2 == null) continue;
            return clazz2;
        }
        this.itracer.info("getCardServiceClass", "no CardService for " + clazz);
        return null;
    }

    public final Enumeration getCardServiceFactories() {
        return ((Vector)this.factories.clone()).elements();
    }

    protected CardService getCardServiceInstance(Class clazz, CardID cardID, CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws ClassNotFoundException {
        this.itracer.debug("getCardServiceInstance", "for " + clazz + " from " + smartCard);
        Enumeration enumeration = this.getCardServiceFactories();
        while (enumeration.hasMoreElements()) {
            CardServiceFactory cardServiceFactory = (CardServiceFactory)enumeration.nextElement();
            this.itracer.debug("getCardServiceInstance", "checking " + cardServiceFactory);
            CardType cardType = cardServiceScheduler.getCardTypeFor(cardServiceFactory);
            if (cardType == null) {
                try {
                    cardType = cardServiceFactory.getCardType(cardID, cardServiceScheduler);
                    cardServiceScheduler.setCardTypeFor(cardServiceFactory, cardType);
                }
                catch (CardTerminalException cardTerminalException) {
                    this.itracer.debug("getCardServiceInstance", cardTerminalException);
                    cardTerminalException.printStackTrace();
                    continue;
                }
            }
            if (CardType.UNSUPPORTED == cardType) continue;
            try {
                CardService cardService = cardServiceFactory.getCardServiceInstance(clazz, cardType, cardServiceScheduler, smartCard, bl);
                this.itracer.debug("getCardServiceInstance", "factory " + cardServiceFactory + " produced " + cardService);
                if (cardService == null) continue;
                return cardService;
            }
            catch (CardServiceException cardServiceException) {
                this.itracer.info("getCardServiceInstance", "factory " + cardServiceFactory + " failed: " + cardServiceException);
            }
        }
        this.itracer.info("getCardServiceInstance", "no CardService for " + clazz + " found");
        throw new ClassNotFoundException("CardService implementing " + clazz.toString());
    }

    public static CardServiceRegistry getRegistry() {
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SmartCard getSmartCard(CardTerminalEvent cardTerminalEvent, CardRequest cardRequest, Object object) throws CardTerminalException {
        this.itracer.debug("getSmartCard", "CTEvent " + cardTerminalEvent);
        boolean bl = false;
        CardTerminal cardTerminal = (CardTerminal)cardTerminalEvent.getSource();
        SlotChannel slotChannel = null;
        int n = cardTerminalEvent.getSlotID();
        CardID cardID = cardTerminal.getCardID(n);
        Integer n2 = new Integer(cardTerminal.hashCode() + n);
        Object object2 = this.slot2channel;
        synchronized (object2) {
            slotChannel = (SlotChannel)this.slot2channel.get(n2);
            if (slotChannel != null && slotChannel.getLockHandle() == object) {
                this.itracer.debug("getSmartCard", "secondary waitForCard(); don't need to open SlotChannel again");
            } else {
                slotChannel = cardTerminal.openSlotChannel(n, object);
                this.slot2channel.put(n2, slotChannel);
            }
        }
        object2 = (CardServiceScheduler)slotChannel.getScheduler();
        if (object2 == null) {
            object2 = this.allocateCardServiceScheduler(slotChannel);
            bl = true;
        }
        if (cardRequest != null && !this.isCardRequestSatisfied(cardRequest, cardID, cardTerminal, (CardServiceScheduler)object2)) {
            this.itracer.info("getSmartCard", "CardRequest " + cardRequest + " cannot be satisfied with " + cardID);
            if (bl) {
                ((CardServiceScheduler)object2).closeDown();
            }
            return null;
        }
        this.itracer.debug("getSmartCard", "using CardServiceScheduler " + object2);
        return ((CardServiceScheduler)object2).createSmartCard(cardID);
    }

    private boolean isCardRequestSatisfied(CardRequest cardRequest, CardID cardID, CardTerminal cardTerminal, CardServiceScheduler cardServiceScheduler) {
        CardIDFilter cardIDFilter = cardRequest.getFilter();
        if (cardIDFilter != null && !cardIDFilter.isCandidate(cardID)) {
            this.itracer.info("isCardRequestSatisfied", "filtered out by " + cardIDFilter);
            return false;
        }
        if (cardRequest.getCardTerminal() != null && cardRequest.getCardTerminal() != cardTerminal) {
            this.itracer.info("isCardRequestSatisfied", "requested terminal " + cardRequest.getCardTerminal() + " does not match receiving terminal " + cardTerminal);
            return false;
        }
        if (cardRequest.getCardServiceClass() != null && this.getCardServiceClassFor(cardRequest.getCardServiceClass(), cardID, cardServiceScheduler) == null) {
            this.itracer.info("isCardRequestSatisfied", "requested CardService class " + cardRequest.getCardServiceClass() + " not supported for  " + cardID);
            return false;
        }
        return true;
    }

    protected void releaseScheduler(CardServiceScheduler cardServiceScheduler) {
        int n = cardServiceScheduler.getSlotChannel().getCardTerminal().hashCode() + cardServiceScheduler.getSlotChannel().getSlotNumber();
        this.slot2channel.remove(new Integer(n));
    }

    public void remove(CardServiceFactory cardServiceFactory) {
        this.itracer.debug("remove", " " + cardServiceFactory);
        this.factories.removeElement(cardServiceFactory);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        Enumeration enumeration = this.getCardServiceFactories();
        while (enumeration.hasMoreElements()) {
            CardServiceFactory cardServiceFactory = (CardServiceFactory)enumeration.nextElement();
            stringBuffer.append("++ registered factory ").append(cardServiceFactory).append("\n");
        }
        return stringBuffer.toString();
    }
}

