/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import java.util.Enumeration;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardType;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.Tracer;

public abstract class CardServiceFactory {
    private Tracer itracer = new Tracer((Object)this, CardServiceFactory.class);
    private Tracer ctracer = new Tracer(CardServiceFactory.class);

    public CardServiceFactory() {
        this.ctracer.debug("<init>", "instantiating");
    }

    protected CardService getCardServiceInstance(Class clazz, CardType cardType, CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws CardServiceException {
        Class clazz2 = this.getClassFor(clazz, cardType);
        if (clazz2 != null) {
            return this.newCardServiceInstance(clazz2, cardType, cardServiceScheduler, smartCard, bl);
        }
        return null;
    }

    protected Class getClassFor(Class clazz, CardType cardType) {
        Enumeration enumeration = this.getClasses(cardType);
        while (enumeration.hasMoreElements()) {
            Class clazz2 = (Class)enumeration.nextElement();
            this.itracer.debug("getClassFor", "checking " + clazz2);
            if (!clazz.isAssignableFrom(clazz2)) continue;
            return clazz2;
        }
        return null;
    }

    protected CardService newCardServiceInstance(Class clazz, CardType cardType, CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws CardServiceException {
        this.itracer.debug("newCardServiceInstance", "instantiating " + clazz);
        CardService cardService = null;
        try {
            cardService = (CardService)clazz.newInstance();
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        if (cardService != null) {
            cardService.initialize(cardServiceScheduler, smartCard, bl);
        }
        return cardService;
    }

    protected abstract CardType getCardType(CardID var1, CardServiceScheduler var2) throws CardTerminalException;

    protected abstract Enumeration getClasses(CardType var1);
}

