/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import opencard.core.service.CHVDialog;
import opencard.core.service.CardServiceInvalidCredentialException;
import opencard.core.service.DefaultCHVDialog;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalIOControl;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.Tracer;

public final class CardHolderVerificationGUI {
    private Tracer itracer = new Tracer((Object)this, CardHolderVerificationGUI.class);
    private int chvNumber = -1;
    private CHVDialog chvDialog = new DefaultCHVDialog();

    protected CardHolderVerificationGUI() {
    }

    protected void clearDisplay() {
        this.chvNumber = -1;
    }

    protected void display(int n) {
        this.chvNumber = n;
    }

    protected String keyboardInput(CardTerminalIOControl cardTerminalIOControl, CHVDialog cHVDialog) {
        if (cHVDialog != null) {
            return cHVDialog.getCHV(this.chvNumber);
        }
        return this.chvDialog.getCHV(this.chvNumber);
    }

    protected String promptUser(int n, CardTerminalIOControl cardTerminalIOControl, CHVDialog cHVDialog) {
        this.clearDisplay();
        this.display(n);
        return this.keyboardInput(cardTerminalIOControl, cHVDialog);
    }

    public ResponseAPDU sendVerifiedAPDU(SlotChannel slotChannel, CommandAPDU commandAPDU, CHVControl cHVControl, CHVDialog cHVDialog, int n) throws CardTerminalException, CardServiceInvalidCredentialException {
        return this.sendVerifiedAPDU(slotChannel, commandAPDU, cHVControl, cHVDialog);
    }

    public ResponseAPDU sendVerifiedAPDU(SlotChannel slotChannel, CommandAPDU commandAPDU, CHVControl cHVControl, CHVDialog cHVDialog) throws CardTerminalException, CardServiceInvalidCredentialException {
        int n;
        int n2;
        int n3;
        byte[] byArray;
        if (!cHVControl.passwordEncoding().equals("String encoding") && !cHVControl.passwordEncoding().equals("Format 2 Block")) {
            throw new CardTerminalException("verification type not supported: " + cHVControl.toString());
        }
        String string = this.promptUser(cHVControl.chvNumber(), cHVControl.ioControl(), cHVDialog);
        if (string == null) {
            throw new CardServiceInvalidCredentialException("CHV cancelled");
        }
        if (cHVControl.passwordEncoding().equals("String encoding")) {
            byArray = string.getBytes();
            if (byArray.length < (n3 = cHVControl.ioControl().maxInputChars())) {
                n3 = byArray.length;
            }
        } else {
            n3 = 8;
            byArray = new byte[n3];
            for (n2 = 1; n2 < n3; ++n2) {
                byArray[n2] = -1;
            }
            for (n2 = 0; n2 < string.length() && n2 < 14; ++n2) {
                n = string.charAt(n2);
                if (n < 48 && n > 57) {
                    throw new CardTerminalException("CHV must only contain digits");
                }
                byArray[1 + (n2 >> 1)] = (n2 & 1) == 0 ? (byte)(n - 48 << 4 | 0xF) : (byte)(byArray[1 + (n2 >> 1)] & 0xF0 | n - 48);
            }
            byArray[0] = (byte)(0x20 | n2);
        }
        n2 = cHVControl.passwordOffset();
        for (n = 0; n < n3; ++n) {
            commandAPDU.setByte(5 + n2 + n, byArray[n]);
        }
        if (!slotChannel.isOpen()) {
            throw new CardTerminalException("SlotChannel closed");
        }
        ResponseAPDU responseAPDU = slotChannel.sendAPDU(commandAPDU);
        return responseAPDU;
    }
}

