/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.event;

import java.util.Enumeration;
import java.util.Vector;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.Observer;
import opencard.core.terminal.Pollable;
import opencard.core.util.Tracer;

public final class EventGenerator
implements Observer,
Runnable {
    private static Tracer ctracer = new Tracer(EventGenerator.class);
    private Vector listeners = new Vector();
    private static EventGenerator theGenerator = null;
    private Thread t = null;
    private static boolean running;
    private static int pollInterval;
    private Vector pollables = new Vector();

    public static EventGenerator getGenerator() {
        if (theGenerator == null) {
            theGenerator = new EventGenerator();
            CardTerminalRegistry.getRegistry().setObserver(theGenerator);
        }
        return theGenerator;
    }

    public void addCTListener(CTListener cTListener) {
        this.listeners.addElement(cTListener);
    }

    public void createEventsForPresentCards(CTListener cTListener) throws CardTerminalException {
        Enumeration enumeration = CardTerminalRegistry.getRegistry().getCardTerminals();
        while (enumeration.hasMoreElements()) {
            CardTerminal cardTerminal = (CardTerminal)enumeration.nextElement();
            int n = cardTerminal.getSlots();
            for (int i = 0; i < n; ++i) {
                if (!cardTerminal.isCardPresent(i)) continue;
                cTListener.cardInserted(new CardTerminalEvent(cardTerminal, 1, i));
            }
        }
    }

    public void removeCTListener(CTListener cTListener) {
        this.listeners.removeElement(cTListener);
    }

    public void setPollInterval(int n) {
        pollInterval = n;
    }

    public int getPollInterval() {
        return pollInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (running) {
            try {
                Thread.sleep(pollInterval);
                Vector vector = this.pollables;
                synchronized (vector) {
                    Enumeration enumeration = this.pollables.elements();
                    while (enumeration.hasMoreElements()) {
                        Pollable pollable = (Pollable)enumeration.nextElement();
                        try {
                            pollable.poll();
                        }
                        catch (RuntimeException runtimeException) {
                            ctracer.debug("run", runtimeException);
                        }
                        catch (CardTerminalException cardTerminalException) {
                            ctracer.debug("run", cardTerminalException);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    @Override
    public void updateCards(CardTerminal cardTerminal, int n, boolean bl) {
        ctracer.debug("updateCards", "card " + (bl ? "inserted" : "removed") + " slotID = " + n);
        if (!this.listeners.isEmpty()) {
            CTListener cTListener = null;
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                cTListener = (CTListener)enumeration.nextElement();
                try {
                    if (bl) {
                        cTListener.cardInserted(new CardTerminalEvent(cardTerminal, 1, n));
                        continue;
                    }
                    cTListener.cardRemoved(new CardTerminalEvent(cardTerminal, 2, n));
                }
                catch (RuntimeException runtimeException) {
                    ctracer.critical("updateCards", runtimeException);
                }
                catch (CardTerminalException cardTerminalException) {
                    ctracer.critical("updateCards", cardTerminalException);
                }
            }
            ctracer.debug("updateCards", "notified CTListeners");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateTerminals(Pollable pollable, boolean bl) {
        Vector vector = this.pollables;
        synchronized (vector) {
            if (bl) {
                ctracer.debug("updateTerminals", "new pollable Terminal = " + pollable);
                this.pollables.addElement(pollable);
                try {
                    pollable.poll();
                }
                catch (RuntimeException runtimeException) {
                    ctracer.debug("run", runtimeException);
                }
                catch (CardTerminalException cardTerminalException) {
                    ctracer.debug("run", cardTerminalException);
                }
                if (this.t == null) {
                    this.t = new Thread((Runnable)this, "OCF Polling");
                    this.t.setDaemon(true);
                    running = true;
                    this.t.start();
                }
                return true;
            }
            ctracer.debug("updateTerminals", "remove pollable Terminal = " + pollable);
            boolean bl2 = this.pollables.removeElement(pollable);
            if (this.pollables.size() <= 0) {
                running = false;
                this.t = null;
            }
            return bl2;
        }
    }

    private EventGenerator() {
    }

    static {
        pollInterval = 500;
    }
}

