/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import opencard.opt.util.TLV;
import opencard.opt.util.Tag;

public class CapFile {
    public static final int HEADER = 0;
    public static final int DIRECTORY = 1;
    public static final int APPLET = 2;
    public static final int IMPORT = 3;
    public static final int CONSTANTPOOL = 4;
    public static final int CLASS = 5;
    public static final int METHOD = 6;
    public static final int STATICFIELD = 7;
    public static final int REFLOCATION = 8;
    public static final int EXPORT = 9;
    public static final int DESCRIPTOR = 10;
    public static final int DEBUG = 11;
    public static final String[] COMPONENTS = new String[]{"HEADER", "DIRECTORY", "APPLET", "IMPORT", "CONSTANTPOOL", "CLASS", "METHOD", "STATICFIELD", "REFLOCATION", "EXPORT", "DESCRIPTOR", "DEBUG"};
    public static final int[] CAPSEQUENCE = new int[]{0, 1, 3, 2, 5, 6, 7, 4, 8, 10};
    public static final int[] CAPSEQUENCE_JCOP = new int[]{0, 1, 3, 2, 5, 6, 7, 4, 8, 9};
    protected String filename;
    protected byte[][] components = new byte[COMPONENTS.length][];

    public CapFile(String string) {
        this.filename = string;
    }

    public void read() throws IOException {
        int n;
        for (n = 0; n < this.components.length; ++n) {
            this.components[n] = null;
        }
        ZipFile zipFile = new ZipFile(new File(this.filename));
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            int n2;
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName().toUpperCase();
            if (string.startsWith("META-INF")) continue;
            for (n = 0; n < COMPONENTS.length && !string.endsWith("JAVACARD/" + COMPONENTS[n] + ".CAP"); ++n) {
            }
            if (n >= COMPONENTS.length) {
                throw new IOException("Invalid component " + string + " in cap file");
            }
            if (this.components[n] != null) {
                throw new IOException("Duplicate component " + string + " in cap file");
            }
            int n3 = (int)zipEntry.getSize();
            byte[] byArray = new byte[n3];
            this.components[n] = byArray;
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            int n4 = 0;
            while ((n2 = inputStream.read(byArray, n4, byArray.length - n4)) > 0) {
                n4 += n2;
            }
        }
    }

    public byte[] getLoadFile(int[] nArray) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            if (this.components[n] == null) continue;
            n3 += this.components[n].length;
        }
        byte[] byArray = new byte[n3];
        int n4 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            if (this.components[n] == null) continue;
            int n5 = this.components[n].length;
            System.arraycopy(this.components[n], 0, byArray, n4, n5);
            n4 += n5;
        }
        TLV tLV = new TLV(new Tag(4, 3, false), byArray);
        return tLV.toBinary();
    }
}

