/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.terminal.smartcardio;

import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.ResponseAPDU;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.Pollable;
import opencard.core.util.Tracer;
import opencard.opt.terminal.TerminalCommand;

public class SmartCardIOTerminal
extends opencard.core.terminal.CardTerminal
implements TerminalCommand,
Pollable {
    private static final Tracer ctracer = new Tracer(SmartCardIOTerminal.class);
    private boolean polling;
    private CardTerminal ct;
    private Card card;

    public SmartCardIOTerminal(String string, String string2, String string3, CardTerminal cardTerminal) throws CardTerminalException {
        super(string, string2, string3);
        this.polling = !string2.endsWith("-NOPOLL");
        this.ct = cardTerminal;
        this.card = null;
        this.addSlots(1);
    }

    @Override
    public void open() throws CardTerminalException {
        if (this.polling) {
            CardTerminalRegistry.getRegistry().addPollable(this);
        }
    }

    @Override
    public void close() throws CardTerminalException {
        this.disconnect(true);
        if (this.polling) {
            CardTerminalRegistry.getRegistry().removePollable(this);
        }
    }

    @Override
    public CardID getCardID(int n) throws CardTerminalException {
        if (!this.isCardPresent(n)) {
            ctracer.debug("getCardID", "no card in reader");
            return null;
        }
        this.connect();
        return new CardID(this, n, this.card.getATR().getBytes());
    }

    @Override
    protected CardID internalReset(int n, int n2) throws CardTerminalException {
        return this.getCardID(n);
    }

    @Override
    protected CardID internalReset(int n, boolean bl) throws CardTerminalException {
        this.disconnect(true);
        return this.getCardID(n);
    }

    @Override
    protected opencard.core.terminal.ResponseAPDU internalSendAPDU(int n, CommandAPDU commandAPDU, int n2) throws CardTerminalException {
        ResponseAPDU responseAPDU;
        this.connect();
        javax.smartcardio.CommandAPDU commandAPDU2 = new javax.smartcardio.CommandAPDU(commandAPDU.getBytes());
        CardChannel cardChannel = this.card.getBasicChannel();
        try {
            responseAPDU = cardChannel.transmit(commandAPDU2);
        }
        catch (CardException cardException) {
            ctracer.error("internalSendAPDU", cardException);
            throw new CardTerminalException("CardException in transmit(): " + cardException.getMessage());
        }
        return new opencard.core.terminal.ResponseAPDU(responseAPDU.getBytes());
    }

    @Override
    public boolean isCardPresent(int n) throws CardTerminalException {
        boolean bl;
        try {
            bl = this.ct.isCardPresent();
        }
        catch (CardException cardException) {
            ctracer.error("isCardPresent", cardException);
            throw new CardTerminalException("CardException in isCardPresent(): " + cardException.getMessage());
        }
        if (!bl) {
            this.card = null;
        }
        return bl;
    }

    @Override
    public byte[] sendTerminalCommand(byte[] byArray) throws CardTerminalException {
        int n;
        int n2 = 0;
        for (n = 0; n < byArray.length && n < 4; ++n) {
            n2 <<= 8;
            n2 |= byArray[n] & 0xFF;
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
        byte[] byArray3 = null;
        try {
            byArray3 = this.card.transmitControlCommand(n2, byArray2);
        }
        catch (CardException cardException) {
            ctracer.error("sendTerminalCommand", cardException);
            throw new CardTerminalException("CardException in sendTerminalCommand(): " + cardException.getMessage());
        }
        return byArray3;
    }

    @Override
    public void poll() throws CardTerminalException {
    }

    private void connect() throws CardTerminalException {
        try {
            this.card = this.ct.connect("T=1");
        }
        catch (CardException cardException) {
            ctracer.debug("connect", cardException);
            try {
                this.card = this.ct.connect("*");
            }
            catch (CardException cardException2) {
                ctracer.error("connect", cardException2);
                throw new CardTerminalException("Error connecting to card: " + cardException2.getMessage());
            }
        }
    }

    private void disconnect(boolean bl) throws CardTerminalException {
        if (this.card != null) {
            try {
                this.card.disconnect(bl);
            }
            catch (CardException cardException) {
                ctracer.error("disconnect", cardException);
                throw new CardTerminalException("Error connecting to card: " + cardException.getMessage());
            }
            finally {
                this.card = null;
            }
        }
    }
}

