/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.terminal.jcwdpsim;

import de.cardcontact.opencard.terminal.jcwdpsim.JCWDPSimCardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalFactory;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.TerminalInitException;
import opencard.core.util.Tracer;

public class JCWDPSimCardTerminalFactory
implements CardTerminalFactory {
    static Tracer ctracer = new Tracer(JCWDPSimCardTerminal.class);

    @Override
    public void createCardTerminals(CardTerminalRegistry cardTerminalRegistry, String[] stringArray) throws CardTerminalException, TerminalInitException {
        String string = "localhost";
        int n = 9025;
        if (stringArray.length < 3) {
            throw new TerminalInitException("JCWDPSimCardTerminalFactory needs at least 3 parameters.");
        }
        if (!stringArray[1].equals("JCWDPSIM")) {
            throw new TerminalInitException("Requested Terminal type not known.");
        }
        if (stringArray.length >= 4) {
            string = stringArray[3];
        }
        if (stringArray.length >= 5) {
            n = Integer.parseInt(stringArray[4]);
        }
        if (stringArray.length >= 6) {
            throw new TerminalInitException("JCWDPSimCardTerminalFactory needs a maximum of 3 parameters.");
        }
        try {
            cardTerminalRegistry.add(new JCWDPSimCardTerminal(stringArray[0], stringArray[1], stringArray[2], string, n));
        }
        catch (Exception exception) {
            throw new TerminalInitException("JCWDPSimCardTerminal could not be added to card terminal registry! " + exception.getMessage());
        }
    }

    @Override
    public void open() throws CardTerminalException {
    }

    @Override
    public void close() throws CardTerminalException {
    }
}

