/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.terminal.jcwdpsim;

import com.sun.javacard.apduio.Apdu;
import com.sun.javacard.apduio.CadClientInterface;
import com.sun.javacard.apduio.CadDevice;
import com.sun.javacard.apduio.CadTransportException;
import com.sun.javacard.apduio.TLP224Exception;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.Pollable;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import opencard.core.util.Tracer;

public class JCWDPSimCardTerminal
extends CardTerminal
implements Pollable {
    private static final Tracer ctracer = new Tracer(JCWDPSimCardTerminal.class);
    private CadClientInterface cad;
    private Socket socket = null;
    private SocketAddress socketAddr;
    private CardID cid = null;
    private boolean opened = false;
    private boolean connected = false;

    public JCWDPSimCardTerminal(String string, String string2, String string3, String string4, int n) throws CardTerminalException {
        super(string, string2, string3);
        ctracer.info("<init>", "name|type|address|host|port = " + string + "|" + string2 + "|" + string3 + "|" + string4 + "|" + n);
        this.socketAddr = new InetSocketAddress(string4, n);
        this.addSlots(1);
    }

    @Override
    public synchronized void open() {
        ctracer.info("open", "open terminal: " + this.getName());
        ctracer.debug("open", "add terminal to polling-list");
        CardTerminalRegistry.getRegistry().addPollable(this);
        this.opened = true;
    }

    @Override
    public synchronized void close() throws CardTerminalException {
        ctracer.info("close", "close terminal: " + this.getName());
        ctracer.debug("close", "remove terminal from polling-list");
        CardTerminalRegistry.getRegistry().removePollable(this);
        this.cid = null;
        try {
            if (this.cad != null) {
                this.cad.powerDown();
                this.socket.close();
                this.opened = false;
                ctracer.debug("close", "close cad");
            }
        }
        catch (IOException iOException) {
            ctracer.debug("close", "IOException in close:\nMessage: " + iOException.getMessage());
        }
        catch (TLP224Exception tLP224Exception) {
            throw new CardTerminalException("TLP224Exception in close:\nMessage: " + tLP224Exception.getMessage());
        }
        catch (CadTransportException cadTransportException) {
            throw new CardTerminalException("CadTransportException in close:\nMessage: " + cadTransportException.getMessage());
        }
    }

    @Override
    public synchronized boolean isCardPresent(int n) throws CardTerminalException {
        ctracer.info("isCardPresent", "isCardPresent(" + n + " on " + this.getName() + "...");
        if (n == 0) {
            return this.connected;
        }
        throw new IndexOutOfBoundsException("Wrong slotID: only 0 is allowed.");
    }

    @Override
    public synchronized CardID getCardID(int n) throws CardTerminalException {
        ctracer.info("getCardID", "getCardID(" + n + " on " + this.getName() + "...");
        if (this.isCardPresent(n)) {
            try {
                byte[] byArray = this.cad.powerUp();
                ctracer.debug("getCardID", "powered Up");
                this.cid = new CardID(this, n, byArray);
            }
            catch (TLP224Exception tLP224Exception) {
                throw new CardTerminalException("TLP224Exception in getCardID: \nMessage: " + tLP224Exception.getMessage());
            }
            catch (IOException iOException) {
                throw new CardTerminalException("IOException in getCardID: Message: " + iOException.getMessage());
            }
            catch (CadTransportException cadTransportException) {
                throw new CardTerminalException("CadTransportException in getCardID: Message: " + cadTransportException.getMessage());
            }
        }
        return this.cid;
    }

    @Override
    public synchronized void poll() {
        ctracer.info("poll", "polling " + this.getName() + "...");
        if (this.opened && !this.connected) {
            try {
                ctracer.debug("poll", "simulator socket connection");
                this.socket = new Socket();
                this.socket.connect(this.socketAddr, 100);
                InputStream inputStream = this.socket.getInputStream();
                OutputStream outputStream = this.socket.getOutputStream();
                this.cad = CadDevice.getCadClientInstance((byte)1, (InputStream)inputStream, (OutputStream)outputStream);
                ctracer.debug("poll", "CadClient with protocol T=1 created");
                this.connected = true;
                this.cardInserted(0);
            }
            catch (IOException iOException) {
                ctracer.debug("poll", "socket connection failed");
                this.socket = null;
                this.connected = false;
            }
        } else {
            try {
                this.cid = new CardID(this.cad.powerUp());
            }
            catch (TLP224Exception tLP224Exception) {
                ctracer.debug("poll", "TLP224Exception " + tLP224Exception.getMessage());
                this.connected = false;
                this.cardRemoved(0);
            }
            catch (IOException iOException) {
                ctracer.debug("poll", "socket connection failed");
                this.socket = null;
                this.connected = false;
                this.cardRemoved(0);
            }
            catch (CadTransportException cadTransportException) {
                ctracer.debug("poll", "CadTransportException " + cadTransportException.getMessage());
                this.connected = false;
                this.cardRemoved(0);
            }
        }
    }

    @Override
    protected synchronized CardID internalReset(int n, int n2) throws CardTerminalException {
        ctracer.info("internalReset", "internalReset(" + n + ") on " + this.getName());
        if (!this.isCardPresent(n)) {
            this.cid = null;
            return this.getCardID(n);
        }
        return this.cid;
    }

    @Override
    protected synchronized ResponseAPDU internalSendAPDU(int n, CommandAPDU commandAPDU, int n2) throws CardTerminalException {
        ctracer.info("internalReset", "internalReset(" + n + ") on " + this.getName());
        if (this.isCardPresent(n)) {
            byte[] byArray;
            Apdu apdu = new Apdu();
            ctracer.debug("internalSendAPDU", "capdu: " + HexString.hexify(commandAPDU.getBytes()));
            byte[] byArray2 = apdu.command;
            byArray2[0] = (byte)commandAPDU.getByte(0);
            byArray2[1] = (byte)commandAPDU.getByte(1);
            byArray2[2] = (byte)commandAPDU.getByte(2);
            byArray2[3] = (byte)commandAPDU.getByte(3);
            int n3 = 0;
            int n4 = 0;
            if (commandAPDU.getLength() != 4) {
                if (commandAPDU.getLength() == 5) {
                    n4 = commandAPDU.getByte(4);
                } else {
                    n3 = commandAPDU.getByte(4);
                    if (commandAPDU.getLength() != 5 + n3) {
                        n4 = commandAPDU.getByte(commandAPDU.getLength() - 1);
                    }
                }
            }
            apdu.Le = n4;
            ctracer.debug("internalSendAPDU", "cmd : " + HexString.hexify(byArray2));
            if (n3 > 0) {
                byArray = new byte[n3];
                System.arraycopy(commandAPDU.getBuffer(), 5, byArray, 0, byArray.length);
                apdu.setDataIn(byArray);
                ctracer.debug("internalSendAPDU", "data: " + HexString.hexify(byArray));
            }
            try {
                this.cad.exchangeApdu(apdu);
            }
            catch (IOException iOException) {
                throw new CardTerminalException("IOException in internalSendAPDU:\nMessage: " + iOException.getMessage());
            }
            catch (TLP224Exception tLP224Exception) {
                throw new CardTerminalException("TLP224Exception in internalSendAPDU:\nMessage: " + tLP224Exception.getMessage());
            }
            catch (CadTransportException cadTransportException) {
                throw new CardTerminalException("CadTransportException in internalSendAPDU:\nMessage: " + cadTransportException.getMessage());
            }
            byArray = new byte[apdu.getLe() + 2];
            System.arraycopy(apdu.getDataOut(), 0, byArray, 0, apdu.getLe());
            System.arraycopy(apdu.getSw1Sw2(), 0, byArray, apdu.getLe(), 2);
            ctracer.debug("internalSendAPDU", "response: " + HexString.hexify(byArray));
            ctracer.debug("internalSendAPDU", "got response: " + byArray);
            return new ResponseAPDU(byArray);
        }
        throw new CardTerminalException("no card inserted");
    }
}

