/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.terminal.jcopsim;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import opencard.core.util.Tracer;

public class JCOPSimCardTerminal
extends CardTerminal {
    private static final Tracer ctracer = new Tracer(JCOPSimCardTerminal.class);
    public static final int DEFAULT_SOCKET_TIMEOUT = 5000;
    private static final int JCOP_RECV_BUFFER_SIZE = 65636;
    static final byte MTY_WAIT_FOR_CARD = 0;
    static final byte MTY_APDU_DATA = 1;
    static final byte MTY_STATUS = 2;
    static final byte MTY_ERROR_MESSAGE = 3;
    static final byte MTY_TERMINAL_INFO = 4;
    static final byte MTY_INIT_INFO = 5;
    static final byte MTY_ECHO = 6;
    static final byte MTY_DEBUG = 7;
    static final byte NODE_TERMINAL = 33;
    static final byte NODE_CARD = 0;
    static final int NOT_CONNECTED = 1;
    static final int SLOT_EMPTY = 2;
    static final int CARD_PRESENT = 4;
    static final int ERROR = 8;
    static final int PROTOCOL_T0 = 0;
    static final int PROTOCOL_T1 = 1;
    static final int PROTOCOL_TCL = 5;
    private Socket socket = null;
    private SocketAddress socketAddr;
    private int socketTimeout = 5000;
    private BufferedInputStream inStream = null;
    private BufferedOutputStream outStream = null;
    private CardID cid = null;
    private boolean connected = false;
    private byte[] jcopBuffer;

    public JCOPSimCardTerminal(String string, String string2, String string3, String string4, int n, int n2) throws CardTerminalException {
        super(string, string2, string3);
        this.socketAddr = new InetSocketAddress(string4, n);
        this.jcopBuffer = new byte[65636];
        this.socketTimeout = n2;
        this.addSlots(1);
    }

    @Override
    public CardID getCardID(int n) throws CardTerminalException {
        if (!this.connected) {
            this.open();
        }
        if (!this.connected) {
            throw new CardTerminalException("JCOPSimCardTerminal: getCardID(), Terminal not opened.");
        }
        return this.cid;
    }

    @Override
    public boolean isCardPresent(int n) throws CardTerminalException {
        if (!this.connected) {
            this.open();
        }
        return this.connected;
    }

    @Override
    public void open() throws CardTerminalException {
        if (this.connected) {
            return;
        }
        try {
            this.socket = new Socket();
            this.socket.connect(this.socketAddr, 100);
            this.socket.setSoTimeout(this.socketTimeout);
            this.outStream = new BufferedOutputStream(this.socket.getOutputStream());
            this.inStream = new BufferedInputStream(this.socket.getInputStream());
            this.connected = true;
        }
        catch (ConnectException connectException) {
        }
        catch (SocketTimeoutException socketTimeoutException) {
        }
        catch (Exception exception) {
            throw new CardTerminalException("JCOPSimCardTerminal: Card terminal could not be opened! Reason: " + exception.getLocalizedMessage());
        }
        try {
            if (this.connected) {
                byte[] byArray = new byte[]{0, 0, 0, 0};
                this.sendJcop((byte)0, (byte)33, byArray);
                int n = 0;
                n = this.readJcop((byte)0, this.jcopBuffer);
                byte[] byArray2 = new byte[n];
                System.arraycopy(this.jcopBuffer, 0, byArray2, 0, n);
                this.cid = new CardID(byArray2);
                this.cardInserted(0);
            }
        }
        catch (SocketException socketException) {
            this.close();
        }
        catch (Exception exception) {
            this.close();
            throw new CardTerminalException("JCOPSimCardTerminal: Error in socket communication! Reason: " + exception.getLocalizedMessage());
        }
    }

    @Override
    public void close() throws CardTerminalException {
        if (this.connected) {
            try {
                this.connected = false;
                this.outStream.close();
                this.inStream.close();
                this.outStream = null;
                this.inStream = null;
                this.socket.close();
            }
            catch (Exception exception) {
                throw new CardTerminalException("JCOPSimCardTerminal: Error in socket communication! Reason: " + exception.getLocalizedMessage());
            }
        }
    }

    @Override
    protected CardID internalReset(int n, int n2) throws CardTerminalException {
        this.close();
        this.open();
        return this.cid;
    }

    @Override
    protected ResponseAPDU internalSendAPDU(int n, CommandAPDU commandAPDU, int n2) throws CardTerminalException {
        if (!this.connected) {
            this.open();
        }
        if (!this.connected) {
            throw new CardTerminalException("JCOPSimCardTerminal: Error sending APDU! No connection");
        }
        ResponseAPDU responseAPDU = null;
        try {
            byte[] byArray = commandAPDU.getBytes();
            this.sendJcop((byte)1, (byte)0, byArray);
            int n3 = 0;
            n3 = this.readJcop((byte)1, this.jcopBuffer);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(this.jcopBuffer, 0, byArray2, 0, n3);
            responseAPDU = new ResponseAPDU(byArray2);
        }
        catch (Exception exception) {
            ctracer.debug("internalSendAPDU()", "Error sending APDU: " + exception.getMessage());
            throw new CardTerminalException("JCOPSimCardTerminal: Error sending APDU! Reason: " + exception.getLocalizedMessage());
        }
        return responseAPDU;
    }

    private void sendJcop(byte by, byte by2, byte[] byArray) throws CardTerminalException {
        int n = byArray == null ? 0 : byArray.length;
        byte[] byArray2 = new byte[4 + n];
        byArray2[0] = by;
        byArray2[1] = by2;
        byArray2[2] = (byte)(n / 256);
        byArray2[3] = (byte)n;
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray2, 4, n);
        }
        try {
            ctracer.debug("sendJcop()", "SEND: " + HexString.dump(byArray2, 0, byArray2.length));
            this.outStream.write(byArray2);
            this.outStream.flush();
        }
        catch (IOException iOException) {
            this.connected = false;
        }
    }

    private int readJcop(byte by, byte[] byArray) throws Exception {
        int n;
        int n2 = -1;
        int n3 = 0;
        byte[] byArray2 = new byte[byArray.length];
        n3 = this.inStream.read(byArray2, 0, 4);
        if (n3 != 4) {
            this.connected = false;
            ctracer.debug("readJcop()", "JCOP header not received! recv = " + HexString.dump(byArray2, 0, n3) + " (" + n3 + ")");
            throw new CardTerminalException("JCOP header not received!");
        }
        if (byArray2[0] != by) {
            this.connected = false;
            ctracer.debug("readJcop()", "Mismatch of message types");
            throw new CardTerminalException("Mismatch of message types");
        }
        n2 = (byArray2[2] & 0xFF) << 8 | byArray2[3] & 0xFF;
        for (n = 0; n < n2; n += n3) {
            n3 = this.inStream.read(byArray2, 0, byArray2.length);
            System.arraycopy(byArray2, 0, byArray, n, n3);
        }
        if (this.inStream.available() > 0) {
            ctracer.debug("readJcop()", "Warning: not all bytes were read! left = " + this.inStream.available());
        }
        return n;
    }
}

