/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.terminal.ctapi4ocf;

import de.cardcontact.jni2ctapi.cardterminal_api;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.Pollable;
import opencard.core.terminal.ResponseAPDU;
import opencard.opt.terminal.TerminalCommand;

public class CTAPICardTerminal
extends CardTerminal
implements Pollable,
TerminalCommand {
    private static final byte NOCARD = 0;
    private static final byte CARDIN = 1;
    private static final byte CARDDISCONNECTED = 3;
    private static final byte CARDCONNECTED = 5;
    public static final byte[] requestICC = new byte[]{32, 18, 1, 1, 0};
    public static final byte[] getStatus = new byte[]{32, 19, 0, -128, 0};
    protected boolean termopened;
    protected byte[] cardStatus;
    protected CardID[] cardIdTable;
    protected Object sync = "CardTerminalSync";
    protected cardterminal_api CT;
    protected char ctn;
    protected char pn;
    private boolean polling;

    protected CTAPICardTerminal(String string, String string2, String string3, String string4) throws CardTerminalException {
        super(string, string2, string3);
        this.polling = !string2.endsWith("-NOPOLL");
        this.termopened = false;
        this.CT = new cardterminal_api(string4);
        try {
            this.ctn = (char)Integer.decode(this.address).intValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new CardTerminalException("CTAPICardTerminal: Invalid port address.");
        }
        this.pn = this.ctn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws CardTerminalException {
        int n;
        if (this.termopened) {
            throw new CardTerminalException("CTAPICardTerminal: Already opened.");
        }
        Object object = this.sync;
        synchronized (object) {
            n = this.CT.CT_Init(this.ctn, this.pn);
        }
        if (n < 0) {
            throw new CardTerminalException("CTAPICardTerminal: CT_Init failed with rc=" + n);
        }
        this.termopened = true;
        byte[] byArray = this.getStatus();
        int n2 = byArray.length;
        this.addSlots(n2);
        this.cardStatus = new byte[n2];
        this.cardIdTable = new CardID[n2];
        if (this.polling) {
            CardTerminalRegistry.getRegistry().addPollable(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws CardTerminalException {
        if (!this.termopened) {
            throw new CardTerminalException("CTAPICardTerminal: Terminal not opened.");
        }
        if (this.polling) {
            CardTerminalRegistry.getRegistry().removePollable(this);
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.CT.CT_Close(this.ctn) == 0) {
                this.termopened = false;
            }
        }
        if (this.termopened) {
            CardTerminalRegistry.getRegistry().addPollable(this);
            throw new CardTerminalException("CTAPICardTerminal: CT_close failed.");
        }
    }

    @Override
    public boolean isCardPresent(int n) throws CardTerminalException {
        if (!this.termopened) {
            throw new CardTerminalException("CTAPICardTerminal: isCardPresent(), Terminal not opened.");
        }
        if (!this.polling) {
            this.poll();
        }
        return this.cardIdTable[n] != null;
    }

    @Override
    public CardID getCardID(int n) throws CardTerminalException {
        if (!this.termopened) {
            throw new CardTerminalException("CTAPICardTerminal: getCardID(), Terminal not opened.");
        }
        return this.cardIdTable[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CardID internalReset(int n, int n2) throws CardTerminalException {
        CardID cardID;
        int n3;
        byte[] byArray = new byte[258];
        byte[] byArray2 = new byte[]{32, 17, (byte)(n + 1), 1, 0};
        if (!this.termopened) {
            throw new CardTerminalException("CTAPICardTerminal: internalReset(), Terminal not opened.");
        }
        this.cardIdTable[n] = null;
        char c = (char)byArray.length;
        Object object = this.sync;
        synchronized (object) {
            n3 = this.CT.CT_Data(this.ctn, (byte)1, (byte)2, (char)byArray2.length, byArray2, c, byArray);
        }
        if (n3 < 2 || (byArray[n3 - 2] & 0xFF) != 144) {
            throw new CardTerminalException("CTAPICardTerminal: internalReset(), No card inserted.");
        }
        if (n3 < 0) {
            throw new CardTerminalException("CTAPICardTerminal: internalReset(), ERROR=" + n3);
        }
        byte[] byArray3 = new byte[n3 - 2];
        System.arraycopy(byArray, 0, byArray3, 0, n3 - 2);
        this.cardIdTable[n] = cardID = new CardID(this, n, byArray3);
        return cardID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ResponseAPDU internalSendAPDU(int n, CommandAPDU commandAPDU, int n2) throws CardTerminalException {
        int n3;
        byte[] byArray = new byte[258];
        if (!this.termopened) {
            throw new CardTerminalException("CTAPICardTerminal: internalSendAPDU(), Terminal not opened.");
        }
        byte[] byArray2 = commandAPDU.getBytes();
        char c = (char)byArray.length;
        byte by = 0;
        if (n > 0) {
            by = (byte)(1 + n);
        }
        Object object = this.sync;
        synchronized (object) {
            n3 = this.CT.CT_Data(this.ctn, by, (byte)2, (char)byArray2.length, byArray2, c, byArray);
        }
        if (n3 <= 0) {
            throw new CardTerminalException("CTAPICardTerminal: internalSendAPDU(), Error=" + n3);
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, 0, byArray3, 0, n3);
        return new ResponseAPDU(byArray3);
    }

    @Override
    public void poll() throws CardTerminalException {
        boolean bl = false;
        byte[] byArray = this.getStatus();
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == this.cardStatus[i]) continue;
            if (byArray[i] == 0) {
                this.cardIdTable[i] = null;
                this.cardStatus[i] = 0;
                this.cardRemoved(i);
                continue;
            }
            try {
                this.internalReset(i, 0);
                this.cardInserted(i);
            }
            catch (CardTerminalException cardTerminalException) {
                // empty catch block
            }
            bl = true;
        }
        if (bl) {
            this.cardStatus = this.getStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] sendTerminalCommand(byte[] byArray) throws CardTerminalException {
        int n;
        if (!this.termopened) {
            throw new CardTerminalException("CTAPICardTerminal: sendTerminalCommand(), Terminal not opened.");
        }
        byte[] byArray2 = new byte[258];
        char c = (char)byArray2.length;
        Object object = this.sync;
        synchronized (object) {
            n = this.CT.CT_Data(this.ctn, (byte)1, (byte)2, (char)byArray.length, byArray, c, byArray2);
        }
        if (n < 2) {
            throw new CardTerminalException("CTAPICardTerminal: internalSendAPDU(), ERROR!");
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return byArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getStatus() throws CardTerminalException {
        int n;
        byte[] byArray = new byte[258];
        char c = (char)byArray.length;
        Object object = this.sync;
        synchronized (object) {
            n = this.CT.CT_Data(this.ctn, (byte)1, (byte)2, (char)getStatus.length, getStatus, c, byArray);
        }
        if (n <= 0) {
            throw new CardTerminalException("CTAPICardTerminal: GetStatus() failed");
        }
        int n2 = 0;
        if (byArray[0] == -128) {
            n = byArray[1];
            n2 += 2;
        } else {
            n -= 2;
        }
        object = new byte[n];
        System.arraycopy(byArray, n2, object, 0, n);
        return object;
    }
}

