/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.signature;

import de.cardcontact.opencard.service.isocard.IsoCardState;
import java.security.InvalidKeyException;
import opencard.core.service.CardChannel;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceOperationFailedException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import opencard.core.util.Tracer;
import opencard.opt.security.CredentialBag;
import opencard.opt.security.PrivateKeyFile;
import opencard.opt.security.PrivateKeyRef;
import opencard.opt.security.PublicKeyRef;
import opencard.opt.security.SecurityDomain;
import opencard.opt.signature.SignatureCardService;

public class ISSSSignatureService
extends CardService
implements SignatureCardService {
    private static final Tracer ctracer = new Tracer(ISSSSignatureService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize(CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws CardServiceException {
        super.initialize(cardServiceScheduler, smartCard, bl);
        ctracer.debug("initialize", "called");
        try {
            this.allocateCardChannel();
            IsoCardState isoCardState = (IsoCardState)this.getCardChannel().getState();
            if (isoCardState == null) {
                throw new CardServiceException("SignatureCardService requires open card channel");
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    @Override
    public byte[] signData(PrivateKeyRef privateKeyRef, String string, byte[] byArray) throws CardServiceException, InvalidKeyException, CardTerminalException {
        return this.signData(privateKeyRef, string, "", byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] signData(PrivateKeyRef privateKeyRef, String string, String string2, byte[] byArray) throws CardServiceException, InvalidKeyException, CardTerminalException {
        CommandAPDU commandAPDU = new CommandAPDU(256);
        ResponseAPDU responseAPDU = new ResponseAPDU(258);
        byte[] byArray2 = null;
        try {
            this.allocateCardChannel();
            CardChannel cardChannel = this.getCardChannel();
            this.cardSelectKey(cardChannel, privateKeyRef);
            this.cardSelectAlgorithm(cardChannel, string);
            this.cardHash(cardChannel, byArray);
            byArray2 = this.cardSign(cardChannel, null);
        }
        finally {
            this.releaseCardChannel();
        }
        return byArray2;
    }

    @Override
    public byte[] signHash(PrivateKeyRef privateKeyRef, String string, byte[] byArray) throws CardServiceException, InvalidKeyException, CardTerminalException {
        return this.signHash(privateKeyRef, string, "", byArray);
    }

    @Override
    public byte[] signHash(PrivateKeyRef privateKeyRef, String string, String string2, byte[] byArray) throws CardServiceException, InvalidKeyException, CardTerminalException {
        return null;
    }

    @Override
    public boolean verifySignedData(PublicKeyRef publicKeyRef, String string, byte[] byArray, byte[] byArray2) throws CardServiceException, InvalidKeyException, CardTerminalException {
        return false;
    }

    @Override
    public boolean verifySignedData(PublicKeyRef publicKeyRef, String string, String string2, byte[] byArray, byte[] byArray2) throws CardServiceException, InvalidKeyException, CardTerminalException {
        return false;
    }

    @Override
    public boolean verifySignedHash(PublicKeyRef publicKeyRef, String string, byte[] byArray, byte[] byArray2) throws CardServiceException, InvalidKeyException, CardTerminalException {
        return false;
    }

    @Override
    public boolean verifySignedHash(PublicKeyRef publicKeyRef, String string, String string2, byte[] byArray, byte[] byArray2) throws CardServiceException, InvalidKeyException, CardTerminalException {
        return false;
    }

    @Override
    public void provideCredentials(SecurityDomain securityDomain, CredentialBag credentialBag) throws CardServiceException {
    }

    protected void cardSelectKey(CardChannel cardChannel, PrivateKeyRef privateKeyRef) throws CardTerminalException, CardServiceOperationFailedException {
        CommandAPDU commandAPDU = new CommandAPDU(20);
        ResponseAPDU responseAPDU = new ResponseAPDU(2);
        commandAPDU.setLength(0);
        commandAPDU.append((byte)0);
        commandAPDU.append((byte)34);
        commandAPDU.append((byte)65);
        commandAPDU.append((byte)-74);
        commandAPDU.append((byte)5);
        commandAPDU.append((byte)-124);
        commandAPDU.append((byte)3);
        commandAPDU.append((byte)-128);
        commandAPDU.append((byte)((PrivateKeyFile)privateKeyRef).getKeyNumber());
        commandAPDU.append((byte)0);
        responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
        if (responseAPDU.sw() != 36864) {
            throw new CardServiceOperationFailedException("MANAGE_SE failed with SW1/SW2 = " + HexString.hexifyShort(responseAPDU.sw()));
        }
    }

    protected void cardSelectAlgorithm(CardChannel cardChannel, String string) throws CardTerminalException, CardServiceOperationFailedException, InvalidKeyException {
        CommandAPDU commandAPDU = new CommandAPDU(20);
        ResponseAPDU responseAPDU = new ResponseAPDU(2);
        if (!string.equals("SHA1withECDSA")) {
            throw new InvalidKeyException("Only SHA1withECDSA supported");
        }
        commandAPDU.setLength(0);
        commandAPDU.append((byte)0);
        commandAPDU.append((byte)34);
        commandAPDU.append((byte)65);
        commandAPDU.append((byte)-74);
        commandAPDU.append((byte)5);
        commandAPDU.append((byte)-119);
        commandAPDU.append((byte)3);
        commandAPDU.append((byte)19);
        commandAPDU.append((byte)53);
        commandAPDU.append((byte)16);
        responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
        if (responseAPDU.sw() != 36864) {
            throw new CardServiceOperationFailedException("MANAGE_SE failed with SW1/SW2 = " + HexString.hexifyShort(responseAPDU.sw()));
        }
    }

    protected void cardHash(CardChannel cardChannel, byte[] byArray) throws CardTerminalException, CardServiceOperationFailedException {
        CommandAPDU commandAPDU = new CommandAPDU(74);
        ResponseAPDU responseAPDU = new ResponseAPDU(2);
        int n = 0;
        int n2 = byArray.length;
        int n3 = 64;
        byte[] byArray2 = new byte[n3];
        commandAPDU.setLength(0);
        commandAPDU.append((byte)16);
        commandAPDU.append((byte)42);
        commandAPDU.append((byte)-112);
        commandAPDU.append((byte)-96);
        commandAPDU.append((byte)2);
        commandAPDU.append((byte)-112);
        commandAPDU.append((byte)0);
        responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
        if (responseAPDU.sw() != 36864) {
            throw new CardServiceOperationFailedException("PSO_HASH failed with SW1/SW2 = " + HexString.hexifyShort(responseAPDU.sw()));
        }
        while (n2 > 0) {
            boolean bl;
            boolean bl2 = bl = n2 <= 64;
            if (n2 < 64) {
                n3 = n2;
                byArray2 = new byte[n2];
            }
            System.arraycopy(byArray, n, byArray2, 0, n3);
            commandAPDU.setLength(0);
            commandAPDU.append(bl ? (byte)0 : 16);
            commandAPDU.append((byte)42);
            commandAPDU.append((byte)-112);
            commandAPDU.append((byte)-96);
            commandAPDU.append((byte)(byArray2.length + 2));
            commandAPDU.append((byte)-128);
            commandAPDU.append((byte)byArray2.length);
            commandAPDU.append(byArray2);
            responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
            if (responseAPDU.sw() != 36864) {
                throw new CardServiceOperationFailedException("PSO_HASH failed with SW1/SW2 = " + HexString.hexifyShort(responseAPDU.sw()));
            }
            n2 -= n3;
            n += n3;
        }
    }

    protected byte[] cardSign(CardChannel cardChannel, byte[] byArray) throws CardTerminalException, CardServiceOperationFailedException {
        CommandAPDU commandAPDU = new CommandAPDU(5);
        ResponseAPDU responseAPDU = new ResponseAPDU(258);
        commandAPDU.setLength(0);
        commandAPDU.append((byte)0);
        commandAPDU.append((byte)42);
        commandAPDU.append((byte)-98);
        commandAPDU.append((byte)-102);
        if (byArray != null) {
            commandAPDU.append((byte)byArray.length);
            commandAPDU.append(byArray);
        }
        commandAPDU.append((byte)48);
        responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
        if (responseAPDU.sw() != 36864) {
            throw new CardServiceOperationFailedException("PSO_COMPUTE_DIGITAL_SIGNATURE failed with SW1/SW2 = " + HexString.hexifyShort(responseAPDU.sw()));
        }
        int n = responseAPDU.getLength() - 2;
        byte[] byArray2 = new byte[n];
        System.arraycopy(responseAPDU.getBuffer(), 0, byArray2, 0, n);
        return byArray2;
    }

    protected byte[] cardSignDummy(CardChannel cardChannel, byte[] byArray) throws CardTerminalException, CardServiceOperationFailedException {
        CommandAPDU commandAPDU = new CommandAPDU(5);
        ResponseAPDU responseAPDU = new ResponseAPDU(258);
        commandAPDU.setLength(0);
        commandAPDU.append((byte)0);
        commandAPDU.append((byte)-124);
        commandAPDU.append((byte)0);
        commandAPDU.append((byte)0);
        commandAPDU.append((byte)48);
        responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
        if (responseAPDU.sw() != 36864) {
            throw new CardServiceOperationFailedException("PSO_COMPUTE_DIGITAL_SIGNATURE failed with SW1/SW2 = " + HexString.hexifyShort(responseAPDU.sw()));
        }
        int n = responseAPDU.getLength() - 2;
        byte[] byArray2 = new byte[n];
        System.arraycopy(responseAPDU.getBuffer(), 0, byArray2, 0, n);
        return byArray2;
    }
}

