/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.isocard;

import de.cardcontact.opencard.security.IsoCredentialStore;
import de.cardcontact.opencard.security.SecureChannel;
import de.cardcontact.opencard.security.SecureChannelCredential;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.APDUTracer;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.security.CredentialBag;
import opencard.opt.security.SecureService;
import opencard.opt.security.SecurityDomain;
import opencard.opt.util.PassThruCardService;

public class TransparentCardService
extends PassThruCardService
implements SecureService {
    private CredentialBag credentialBag = null;

    @Override
    public void provideCredentials(SecurityDomain securityDomain, CredentialBag credentialBag) throws CardServiceException {
        this.credentialBag = credentialBag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAPDU sendCommandAPDU(CommandAPDU commandAPDU, int n) throws CardTerminalException {
        ResponseAPDU responseAPDU;
        Object object;
        SecureChannelCredential secureChannelCredential = null;
        if (this.credentialBag != null && (object = (IsoCredentialStore)this.credentialBag.getCredentialStore(null, IsoCredentialStore.class)) != null) {
            secureChannelCredential = ((IsoCredentialStore)object).getSecureChannelCredential(new CardFilePath(":3F00"));
        }
        try {
            this.allocateCardChannel();
            object = this.getCardChannel();
            if (secureChannelCredential != null) {
                SlotChannel slotChannel = ((CardChannel)object).getSlotChannel();
                APDUTracer aPDUTracer = slotChannel.getAPDUTracer();
                if (aPDUTracer != null && commandAPDU.getLength() > 5) {
                    aPDUTracer.traceCommandAPDU(slotChannel, commandAPDU);
                }
                SecureChannel secureChannel = secureChannelCredential.getSecureChannel();
                commandAPDU = secureChannel.wrap(commandAPDU, n);
                responseAPDU = ((CardChannel)object).sendCommandAPDU(commandAPDU);
                responseAPDU = secureChannel.unwrap(responseAPDU, n);
                if (aPDUTracer != null && responseAPDU.getLength() > 2) {
                    aPDUTracer.traceResponseAPDU(slotChannel, responseAPDU);
                }
            } else {
                responseAPDU = ((CardChannel)object).sendCommandAPDU(commandAPDU);
            }
        }
        finally {
            this.releaseCardChannel();
        }
        return responseAPDU;
    }
}

