/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.isocard;

import opencard.opt.iso.fs.CardFileInfo;
import opencard.opt.util.TLV;
import opencard.opt.util.Tag;

public class IsoFileControlInformation
implements CardFileInfo {
    private static final Tag tagFCPUSED = new Tag(0, 2, false);
    private static final Tag tagFCPSTRUCTURAL = new Tag(1, 2, false);
    private static final Tag tagFCPFILETYPE = new Tag(2, 2, false);
    private static final Tag tagFCPFID = new Tag(3, 2, false);
    private static final Tag tagFCPPROPRIETARY = new Tag(5, 2, false);
    byte[] fci = null;
    int filelength = -1;
    short fileid = (short)-1;
    int filetype = 8;
    int recordsize = -1;

    public IsoFileControlInformation() {
    }

    public IsoFileControlInformation(byte[] byArray) {
        this.fci = byArray;
        try {
            TLV tLV = new TLV(this.fci);
            TLV tLV2 = null;
            while ((tLV2 = tLV.findTag(null, tLV2)) != null) {
                if (tLV2.tag().isConstructed()) continue;
                if (tLV2.tag().equals(tagFCPUSED)) {
                    this.filelength = tLV2.valueAsNumber();
                    continue;
                }
                if (tLV2.tag().equals(tagFCPFILETYPE)) {
                    byte[] byArray2 = tLV2.valueAsByteArray();
                    this.filetype = byArray2[0] & 7;
                    if (byArray2.length >= 3) {
                        this.recordsize = byArray2[2];
                    }
                    if (byArray2.length < 4) continue;
                    this.recordsize = (this.recordsize << 8) + byArray2[3];
                    continue;
                }
                if (tLV2.tag().equals(tagFCPSTRUCTURAL)) {
                    if (this.filelength != -1) continue;
                    this.filelength = tLV2.valueAsNumber();
                    continue;
                }
                if (!tLV2.tag().equals(tagFCPFID)) continue;
                this.fileid = (short)tLV2.valueAsNumber();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public short getFileID() {
        return this.fileid;
    }

    @Override
    public boolean isDirectory() {
        return this.filetype == 0;
    }

    @Override
    public boolean isTransparent() {
        return this.filetype == 1;
    }

    @Override
    public boolean isCyclic() {
        return (this.filetype & 6) == 6;
    }

    @Override
    public boolean isVariable() {
        return (this.filetype & 6) == 4;
    }

    @Override
    public int getLength() {
        return this.filelength;
    }

    @Override
    public int getRecordSize() {
        return this.recordsize;
    }

    @Override
    public byte[] getHeader() {
        return this.fci;
    }
}

