/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.isocard;

import de.cardcontact.opencard.security.IsoCredentialStore;
import de.cardcontact.opencard.security.SecureChannel;
import de.cardcontact.opencard.security.SecureChannelCredential;
import de.cardcontact.opencard.service.CardServiceUnexpectedStatusWordException;
import de.cardcontact.opencard.service.isocard.CHVCardServiceWithControl;
import de.cardcontact.opencard.service.isocard.IsoCardSelector;
import de.cardcontact.opencard.service.isocard.IsoFileSystemCardService;
import opencard.core.service.CardChannel;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceInabilityException;
import opencard.core.service.CardServiceInvalidParameterException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalIOControl;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.APDUTracer;
import opencard.core.util.Tracer;
import opencard.opt.iso.fs.CardFileAppID;
import opencard.opt.iso.fs.CardFileFileID;
import opencard.opt.iso.fs.CardFileInfo;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.iso.fs.CardFilePathComponent;
import opencard.opt.iso.fs.FileAccessCardService;
import opencard.opt.security.CredentialBag;
import opencard.opt.security.SecureService;
import opencard.opt.security.SecurityDomain;
import opencard.opt.service.CardServiceObjectNotAvailableException;

public class IsoCardService
extends CardService
implements FileAccessCardService,
IsoFileSystemCardService,
CHVCardServiceWithControl,
SecureService {
    private static final CardFilePath root_path = new CardFilePath(":3F00");
    private static final Tracer ctracer = new Tracer(IsoCardService.class);
    CardFilePath credentialDomain = null;
    CredentialBag credentialBag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws CardServiceException {
        super.initialize(cardServiceScheduler, smartCard, bl);
        ctracer.debug("initialize", "called");
        try {
            this.allocateCardChannel();
            IsoCardSelector isoCardSelector = (IsoCardSelector)this.getCardChannel().getState();
            if (isoCardSelector == null) {
                isoCardSelector = new IsoCardSelector(this.getRoot());
                this.getCardChannel().setState(isoCardSelector);
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    @Override
    public boolean exists(CardFilePath cardFilePath) throws CardServiceException, CardTerminalException {
        try {
            this.getFileInfo(cardFilePath);
        }
        catch (CardServiceObjectNotAvailableException cardServiceObjectNotAvailableException) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CardFileInfo getFileInfo(CardFilePath cardFilePath) throws CardServiceException, CardTerminalException {
        CardFileInfo cardFileInfo;
        try {
            this.allocateCardChannel();
            CardChannel cardChannel = this.getCardChannel();
            IsoCardSelector isoCardSelector = (IsoCardSelector)cardChannel.getState();
            isoCardSelector.selectFile(cardChannel, this.getSecureChannelCredential(cardFilePath, 1), cardFilePath, true);
            cardFileInfo = isoCardSelector.getFCI();
        }
        finally {
            this.releaseCardChannel();
        }
        return cardFileInfo;
    }

    @Override
    public CardFilePath getRoot() {
        return root_path;
    }

    protected SecureChannelCredential getSecureChannelCredential(CardFilePath cardFilePath, int n) {
        IsoCredentialStore isoCredentialStore;
        SecureChannelCredential secureChannelCredential = null;
        if (this.credentialDomain != null && (isoCredentialStore = (IsoCredentialStore)this.credentialBag.getCredentialStore(null, IsoCredentialStore.class)) != null) {
            secureChannelCredential = isoCredentialStore.getSecureChannelCredential(cardFilePath, n);
        }
        return secureChannelCredential;
    }

    protected ResponseAPDU sendCommandAPDU(CardChannel cardChannel, SecureChannelCredential secureChannelCredential, int n, CommandAPDU commandAPDU) throws InvalidCardChannelException, CardTerminalException {
        ResponseAPDU responseAPDU;
        if (secureChannelCredential != null) {
            SlotChannel slotChannel = cardChannel.getSlotChannel();
            APDUTracer aPDUTracer = slotChannel.getAPDUTracer();
            if (aPDUTracer != null && commandAPDU.getLength() > 5) {
                aPDUTracer.traceCommandAPDU(slotChannel, commandAPDU);
            }
            SecureChannel secureChannel = secureChannelCredential.getSecureChannel();
            commandAPDU = secureChannel.wrap(commandAPDU, n);
            responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
            responseAPDU = secureChannel.unwrap(responseAPDU, n);
            if (aPDUTracer != null && responseAPDU.getLength() > 2) {
                aPDUTracer.traceResponseAPDU(slotChannel, responseAPDU);
            }
        } else {
            responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
        }
        return responseAPDU;
    }

    protected ResponseAPDU sendCommandAPDU(CardChannel cardChannel, SecureChannelCredential secureChannelCredential, CommandAPDU commandAPDU) throws InvalidCardChannelException, CardTerminalException {
        int n = 0;
        if (secureChannelCredential != null) {
            n = secureChannelCredential.getUsageQualifier();
        }
        return this.sendCommandAPDU(cardChannel, secureChannelCredential, n, commandAPDU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read(CardFilePath cardFilePath, int n, int n2) throws CardServiceException, CardTerminalException {
        CommandAPDU commandAPDU = new CommandAPDU(5);
        byte[] byArray = null;
        if (n < 0 || n > Short.MAX_VALUE || n2 != -1 && n2 < 0) {
            throw new CardServiceInvalidParameterException("read: offset = " + n + ", length = " + n2);
        }
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(cardFilePath, 2);
        try {
            int n3;
            int n4;
            this.allocateCardChannel();
            CardChannel cardChannel = this.getCardChannel();
            IsoCardSelector isoCardSelector = (IsoCardSelector)cardChannel.getState();
            int n5 = isoCardSelector.selectFile(cardChannel, this.getSecureChannelCredential(cardFilePath, 1), cardFilePath);
            if (n5 > 0 && n > 255) {
                throw new CardServiceInvalidParameterException("read: offset = " + n + " out of range when reading with short file identifier");
            }
            int n6 = n4 = secureChannelCredential == null ? 256 : 223;
            for (int i = n2 == -1 ? 32768 : n2; i > 0; i -= n3) {
                commandAPDU.setLength(0);
                commandAPDU.append((byte)0);
                commandAPDU.append((byte)-80);
                if (n5 > 0) {
                    commandAPDU.append((byte)(0x80 | n5));
                } else {
                    commandAPDU.append((byte)(n >> 8));
                }
                commandAPDU.append((byte)n);
                int n7 = n2 == -1 ? n4 : (i > n4 ? n4 : i);
                commandAPDU.append((byte)n7);
                ResponseAPDU responseAPDU = this.sendCommandAPDU(cardChannel, secureChannelCredential, commandAPDU);
                if (responseAPDU.sw() == 26368 && n7 == 256) {
                    n7 = 255;
                    n4 = 255;
                    commandAPDU.setLength(4);
                    commandAPDU.append((byte)n7);
                    responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
                }
                if (responseAPDU.sw1() == 108) {
                    n7 = responseAPDU.sw2() & 0xFF;
                    commandAPDU.setLength(4);
                    commandAPDU.append(responseAPDU.sw2());
                    responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
                }
                if ((responseAPDU.sw() == 27392 || responseAPDU.sw() == 27270) && n2 == -1) {
                    break;
                }
                if (responseAPDU.sw() == 36864 || responseAPDU.sw() == 25218) {
                    if (n5 > 0) {
                        isoCardSelector.setImplicitlySelectedBySFI(cardFilePath);
                        n5 = 0;
                    }
                    n3 = responseAPDU.getLength() - 2;
                    if (byArray == null) {
                        byArray = new byte[n3];
                        System.arraycopy(responseAPDU.getBuffer(), 0, byArray, 0, n3);
                    } else {
                        byte[] byArray2 = new byte[byArray.length + n3];
                        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                        System.arraycopy(responseAPDU.getBuffer(), 0, byArray2, byArray.length, n3);
                        byArray = byArray2;
                    }
                    n += n3;
                    if (responseAPDU.sw() == 25218) break;
                    if (n3 >= n7) continue;
                    break;
                }
                throw new CardServiceUnexpectedStatusWordException("READ_BINARY", responseAPDU.sw());
            }
        }
        finally {
            this.releaseCardChannel();
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readRecord(CardFilePath cardFilePath, int n) throws CardServiceException, CardTerminalException {
        CommandAPDU commandAPDU = new CommandAPDU(5);
        ResponseAPDU responseAPDU = new ResponseAPDU(258);
        byte[] byArray = null;
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(cardFilePath, 2);
        try {
            this.allocateCardChannel();
            CardChannel cardChannel = this.getCardChannel();
            IsoCardSelector isoCardSelector = (IsoCardSelector)cardChannel.getState();
            int n2 = isoCardSelector.selectFile(cardChannel, this.getSecureChannelCredential(cardFilePath, 1), cardFilePath);
            commandAPDU.setLength(0);
            commandAPDU.append((byte)0);
            commandAPDU.append((byte)-78);
            commandAPDU.append((byte)n);
            if (n2 > 0) {
                commandAPDU.append((byte)((n2 << 3) + 4));
            } else {
                commandAPDU.append((byte)4);
            }
            commandAPDU.append((byte)0);
            responseAPDU = this.sendCommandAPDU(cardChannel, secureChannelCredential, commandAPDU);
            if (responseAPDU.sw() != 36864) {
                throw new CardServiceUnexpectedStatusWordException("READ_RECORD", responseAPDU.sw());
            }
            if (n2 > 0) {
                isoCardSelector.setImplicitlySelectedBySFI(cardFilePath);
                n2 = 0;
            }
            byArray = new byte[responseAPDU.data().length];
            System.arraycopy(responseAPDU.data(), 0, byArray, 0, responseAPDU.data().length);
        }
        finally {
            this.releaseCardChannel();
        }
        return byArray;
    }

    @Override
    public byte[][] readRecords(CardFilePath cardFilePath, int n) throws CardServiceException, CardTerminalException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(CardFilePath cardFilePath, int n, byte[] byArray, int n2, int n3) throws CardServiceException, CardTerminalException {
        CommandAPDU commandAPDU = new CommandAPDU(261);
        ResponseAPDU responseAPDU = new ResponseAPDU(2);
        if (n < 0 || n > Short.MAX_VALUE || n3 < 0) {
            throw new CardServiceInvalidParameterException("write: offset = " + n + ", length = " + n3);
        }
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(cardFilePath, 4);
        try {
            this.allocateCardChannel();
            CardChannel cardChannel = this.getCardChannel();
            IsoCardSelector isoCardSelector = (IsoCardSelector)cardChannel.getState();
            int n4 = isoCardSelector.selectFile(cardChannel, this.getSecureChannelCredential(cardFilePath, 1), cardFilePath);
            if (n4 > 0 && n > 255) {
                throw new CardServiceInvalidParameterException("write: offset = " + n + " out of range when writing with short file identifier");
            }
            while (n3 > 0) {
                int n5 = n3 > 220 ? 220 : n3;
                commandAPDU.setLength(0);
                commandAPDU.append((byte)0);
                commandAPDU.append((byte)-42);
                if (n4 > 0) {
                    commandAPDU.append((byte)(0x80 | n4));
                } else {
                    commandAPDU.append((byte)(n >> 8));
                }
                commandAPDU.append((byte)n);
                commandAPDU.append((byte)n5);
                System.arraycopy(byArray, n2, commandAPDU.getBuffer(), 5, n5);
                commandAPDU.setLength(5 + n5);
                responseAPDU = this.sendCommandAPDU(cardChannel, secureChannelCredential, commandAPDU);
                if (responseAPDU.sw() != 36864) {
                    throw new CardServiceUnexpectedStatusWordException("UPDATE_BINARY", responseAPDU.sw());
                }
                if (n4 > 0) {
                    isoCardSelector.setImplicitlySelectedBySFI(cardFilePath);
                    n4 = 0;
                }
                n += n5;
                n2 += n5;
                n3 -= n5;
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    @Override
    public void write(CardFilePath cardFilePath, int n, byte[] byArray) throws CardServiceException, CardTerminalException {
        this.write(cardFilePath, n, byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRecord(CardFilePath cardFilePath, int n, byte[] byArray) throws CardServiceException, CardTerminalException {
        CommandAPDU commandAPDU = new CommandAPDU(261);
        ResponseAPDU responseAPDU = new ResponseAPDU(2);
        if (n < 0 || n > 254) {
            throw new CardServiceInvalidParameterException("writeRecord: recordNumber = " + n);
        }
        if (byArray.length > 255) {
            throw new CardServiceInvalidParameterException("writeRecord: length of data = " + byArray.length);
        }
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(cardFilePath, 4);
        try {
            this.allocateCardChannel();
            CardChannel cardChannel = this.getCardChannel();
            IsoCardSelector isoCardSelector = (IsoCardSelector)cardChannel.getState();
            int n2 = isoCardSelector.selectFile(cardChannel, this.getSecureChannelCredential(cardFilePath, 1), cardFilePath);
            commandAPDU.setLength(0);
            commandAPDU.append((byte)0);
            commandAPDU.append((byte)-36);
            commandAPDU.append((byte)(n + 1));
            if (n2 > 0) {
                commandAPDU.append((byte)((n2 << 3) + 4));
            } else {
                commandAPDU.append((byte)4);
            }
            commandAPDU.append((byte)byArray.length);
            System.arraycopy(byArray, 0, commandAPDU.getBuffer(), 5, byArray.length);
            commandAPDU.setLength(5 + byArray.length);
            responseAPDU = this.sendCommandAPDU(cardChannel, secureChannelCredential, commandAPDU);
            if (responseAPDU.sw() != 36864) {
                throw new CardServiceUnexpectedStatusWordException("UPDATE_RECORD", responseAPDU.sw());
            }
            if (n2 > 0) {
                isoCardSelector.setImplicitlySelectedBySFI(cardFilePath);
                n2 = 0;
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendRecord(CardFilePath cardFilePath, byte[] byArray) throws CardServiceException, CardTerminalException {
        CommandAPDU commandAPDU = new CommandAPDU(261);
        ResponseAPDU responseAPDU = new ResponseAPDU(2);
        if (byArray.length > 255) {
            throw new CardServiceInvalidParameterException("appendRecord: length of data = " + byArray.length);
        }
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(cardFilePath, 8);
        try {
            this.allocateCardChannel();
            CardChannel cardChannel = this.getCardChannel();
            IsoCardSelector isoCardSelector = (IsoCardSelector)cardChannel.getState();
            int n = isoCardSelector.selectFile(cardChannel, this.getSecureChannelCredential(cardFilePath, 1), cardFilePath);
            commandAPDU.setLength(0);
            commandAPDU.append((byte)0);
            commandAPDU.append((byte)-30);
            commandAPDU.append((byte)0);
            if (n > 0) {
                commandAPDU.append((byte)(n << 3));
            } else {
                commandAPDU.append((byte)0);
            }
            commandAPDU.append((byte)byArray.length);
            System.arraycopy(byArray, 0, commandAPDU.getBuffer(), 5, byArray.length);
            commandAPDU.setLength(5 + byArray.length);
            responseAPDU = this.sendCommandAPDU(cardChannel, secureChannelCredential, commandAPDU);
            if (responseAPDU.sw() != 36864) {
                throw new CardServiceUnexpectedStatusWordException("APPEND_RECORD", responseAPDU.sw());
            }
            if (n > 0) {
                isoCardSelector.setImplicitlySelectedBySFI(cardFilePath);
                n = 0;
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAPDU sendCommandAPDU(CardFilePath cardFilePath, CommandAPDU commandAPDU, int n) throws CardServiceException, CardTerminalException {
        ResponseAPDU responseAPDU = null;
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(cardFilePath, 1);
        try {
            this.allocateCardChannel();
            CardChannel cardChannel = this.getCardChannel();
            IsoCardSelector isoCardSelector = (IsoCardSelector)cardChannel.getState();
            int n2 = isoCardSelector.selectFile(cardChannel, secureChannelCredential, cardFilePath);
            if (n2 > 0) {
                throw new CardServiceInvalidParameterException("Can't send APDU to file referenced by short file identifier");
            }
            if (commandAPDU != null) {
                responseAPDU = this.sendCommandAPDU(cardChannel, secureChannelCredential, n, commandAPDU);
            }
        }
        finally {
            this.releaseCardChannel();
        }
        return responseAPDU;
    }

    @Override
    public void provideCredentials(SecurityDomain securityDomain, CredentialBag credentialBag) throws CardServiceException {
        if (!(securityDomain instanceof CardFilePath)) {
            throw new CardServiceInvalidParameterException("domain must be of class CardFilePath");
        }
        this.credentialDomain = (CardFilePath)securityDomain;
        this.credentialBag = credentialBag;
    }

    @Override
    public int getPasswordLength(SecurityDomain securityDomain, int n) throws CardServiceException, CardTerminalException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifyPassword(SecurityDomain securityDomain, int n, CHVControl cHVControl, byte[] byArray) throws CardServiceException, CardTerminalException {
        boolean bl;
        block7: {
            bl = false;
            CommandAPDU commandAPDU = new CommandAPDU(40);
            ResponseAPDU responseAPDU = new ResponseAPDU(2);
            try {
                this.allocateCardChannel();
                CardChannel cardChannel = this.getCardChannel();
                commandAPDU.setLength(0);
                commandAPDU.append((byte)0);
                commandAPDU.append((byte)32);
                commandAPDU.append((byte)0);
                commandAPDU.append(securityDomain == null ? (byte)n : (byte)(n + 128));
                if (byArray != null) {
                    commandAPDU.append((byte)byArray.length);
                    System.arraycopy(byArray, 0, commandAPDU.getBuffer(), 5, byArray.length);
                    commandAPDU.setLength(5 + byArray.length);
                    responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
                } else {
                    commandAPDU.append((byte)8);
                    commandAPDU.append(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
                    responseAPDU = cardChannel.sendVerifiedAPDU(commandAPDU, cHVControl, null);
                }
                if (responseAPDU.sw() == 36864) {
                    bl = true;
                    break block7;
                }
                if ((responseAPDU.sw() & 0xFFF0) == 25536) {
                    bl = false;
                    break block7;
                }
                throw new CardServiceUnexpectedStatusWordException("VERIFY", responseAPDU.sw());
            }
            finally {
                this.releaseCardChannel();
            }
        }
        return bl;
    }

    @Override
    public boolean verifyPassword(SecurityDomain securityDomain, int n, byte[] byArray) throws CardServiceException, CardTerminalException {
        CardTerminalIOControl cardTerminalIOControl = new CardTerminalIOControl(8, 30, "0123456789", "");
        CHVControl cHVControl = new CHVControl("Enter your password", n, "Format 2 Block", 0, cardTerminalIOControl);
        return this.verifyPassword(securityDomain, n, cHVControl, byArray);
    }

    @Override
    public void closeApplication(SecurityDomain securityDomain) throws CardServiceException, CardTerminalException {
    }

    @Override
    public void create(CardFilePath cardFilePath, byte[] byArray) throws CardServiceException, CardTerminalException {
        this.create(cardFilePath, (byte)0, (byte)0, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(CardFilePath cardFilePath, byte by, byte by2, byte[] byArray) throws CardServiceException, CardTerminalException {
        CommandAPDU commandAPDU = new CommandAPDU(261);
        ResponseAPDU responseAPDU = new ResponseAPDU(2);
        if (byArray.length > 255) {
            throw new CardServiceInvalidParameterException("create: length of data = " + byArray.length);
        }
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(cardFilePath, 16);
        try {
            this.allocateCardChannel();
            CardChannel cardChannel = this.getCardChannel();
            IsoCardSelector isoCardSelector = (IsoCardSelector)cardChannel.getState();
            int n = isoCardSelector.selectFile(cardChannel, this.getSecureChannelCredential(cardFilePath, 1), cardFilePath);
            if (n > 0) {
                throw new CardServiceInvalidParameterException("Can't create file in parent referenced by short file identifier");
            }
            commandAPDU.setLength(0);
            commandAPDU.append((byte)0);
            commandAPDU.append((byte)-32);
            commandAPDU.append(by);
            commandAPDU.append(by2);
            commandAPDU.append((byte)byArray.length);
            System.arraycopy(byArray, 0, commandAPDU.getBuffer(), 5, byArray.length);
            commandAPDU.setLength(5 + byArray.length);
            responseAPDU = this.sendCommandAPDU(cardChannel, secureChannelCredential, commandAPDU);
            if (responseAPDU.sw() != 36864) {
                throw new CardServiceUnexpectedStatusWordException("CREATE_FILE", responseAPDU.sw());
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    @Override
    public void delete(CardFilePath cardFilePath) throws CardServiceException, CardTerminalException {
        this.delete(cardFilePath, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(CardFilePath cardFilePath, CardFilePathComponent cardFilePathComponent, boolean bl) throws CardServiceException, CardTerminalException {
        CommandAPDU commandAPDU = new CommandAPDU(261);
        ResponseAPDU responseAPDU = new ResponseAPDU(2);
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(cardFilePath, 32);
        byte[] byArray = null;
        if (cardFilePathComponent != null) {
            if (cardFilePathComponent instanceof CardFileAppID) {
                byArray = ((CardFileAppID)cardFilePathComponent).toByteArray();
            } else if (cardFilePathComponent instanceof CardFileFileID) {
                byArray = ((CardFileFileID)cardFilePathComponent).toByteArray();
            } else {
                throw new CardServiceInvalidParameterException("Child argument must be of type CardFileAppID or CardFileFileID");
            }
        }
        try {
            this.allocateCardChannel();
            CardChannel cardChannel = this.getCardChannel();
            IsoCardSelector isoCardSelector = (IsoCardSelector)cardChannel.getState();
            int n = isoCardSelector.selectFile(cardChannel, this.getSecureChannelCredential(cardFilePath, 1), cardFilePath);
            if (n > 0) {
                throw new CardServiceInvalidParameterException("Can't delete file referenced by short file identifier");
            }
            commandAPDU.setLength(0);
            commandAPDU.append((byte)0);
            commandAPDU.append((byte)-28);
            if (cardFilePathComponent != null) {
                commandAPDU.append(bl ? (byte)1 : 2);
            } else {
                commandAPDU.append((byte)0);
            }
            commandAPDU.append((byte)0);
            if (cardFilePathComponent != null) {
                commandAPDU.append((byte)byArray.length);
                commandAPDU.append(byArray);
            }
            if ((responseAPDU = this.sendCommandAPDU(cardChannel, secureChannelCredential, commandAPDU)).sw() != 36864) {
                throw new CardServiceUnexpectedStatusWordException("DELETE_FILE", responseAPDU.sw());
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(CardFilePath cardFilePath) throws CardServiceInabilityException, CardServiceException, CardTerminalException {
        CommandAPDU commandAPDU = new CommandAPDU(261);
        ResponseAPDU responseAPDU = new ResponseAPDU(2);
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(cardFilePath, 128);
        try {
            this.allocateCardChannel();
            CardChannel cardChannel = this.getCardChannel();
            IsoCardSelector isoCardSelector = (IsoCardSelector)cardChannel.getState();
            int n = isoCardSelector.selectFile(cardChannel, this.getSecureChannelCredential(cardFilePath, 1), cardFilePath, true);
            if (n > 0) {
                throw new CardServiceInvalidParameterException("Can't deactivate file referenced by short file identifier");
            }
            commandAPDU.setLength(0);
            commandAPDU.append((byte)0);
            commandAPDU.append((byte)4);
            commandAPDU.append((byte)0);
            commandAPDU.append((byte)0);
            responseAPDU = this.sendCommandAPDU(cardChannel, secureChannelCredential, commandAPDU);
            if (responseAPDU.sw() != 36864) {
                throw new CardServiceUnexpectedStatusWordException("DEACTIVATE_FILE", responseAPDU.sw());
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rehabilitate(CardFilePath cardFilePath) throws CardServiceInabilityException, CardServiceException, CardTerminalException {
        CommandAPDU commandAPDU = new CommandAPDU(261);
        ResponseAPDU responseAPDU = new ResponseAPDU(2);
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(cardFilePath, 64);
        try {
            this.allocateCardChannel();
            CardChannel cardChannel = this.getCardChannel();
            IsoCardSelector isoCardSelector = (IsoCardSelector)cardChannel.getState();
            int n = isoCardSelector.selectFile(cardChannel, this.getSecureChannelCredential(cardFilePath, 1), cardFilePath, true);
            if (n > 0) {
                throw new CardServiceInvalidParameterException("Can't activate file referenced by short file identifier");
            }
            commandAPDU.setLength(0);
            commandAPDU.append((byte)0);
            commandAPDU.append((byte)68);
            commandAPDU.append((byte)0);
            commandAPDU.append((byte)0);
            responseAPDU = this.sendCommandAPDU(cardChannel, secureChannelCredential, commandAPDU);
            if (responseAPDU.sw() != 36864) {
                throw new CardServiceUnexpectedStatusWordException("ACTIVATE_FILE", responseAPDU.sw());
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }
}

