/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.isocard;

import de.cardcontact.opencard.security.SecureChannel;
import de.cardcontact.opencard.security.SecureChannelCredential;
import de.cardcontact.opencard.service.CardServiceUnexpectedStatusWordException;
import de.cardcontact.opencard.service.isocard.IsoFileControlInformation;
import java.util.Enumeration;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.APDUTracer;
import opencard.core.util.HexString;
import opencard.core.util.Tracer;
import opencard.opt.iso.fs.CardFileAppID;
import opencard.opt.iso.fs.CardFileFileID;
import opencard.opt.iso.fs.CardFileInfo;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.iso.fs.CardFilePathComponent;
import opencard.opt.iso.fs.CardFileShortFileID;
import opencard.opt.service.CardServiceObjectNotAvailableException;

public class IsoCardSelector {
    private static final CardFileFileID root_file = new CardFileFileID(16128);
    private static final Tracer ctracer = new Tracer(IsoCardSelector.class);
    private static final int ALREADY_SELECTED = -1;
    private static final int NEWLY_SELECTED = 0;
    private CardFilePath rootPath;
    private CardFilePath currentPath;
    private CardFileInfo currentFCI;
    private boolean isElementaryFile;
    private byte selectFCI;
    private boolean leInSelectEnabled;
    private boolean supportsP1InSelect;

    public IsoCardSelector(CardFilePath cardFilePath) {
        this.rootPath = cardFilePath;
        this.currentPath = cardFilePath;
        this.currentFCI = null;
        this.selectFCI = (byte)4;
        this.isElementaryFile = false;
        this.leInSelectEnabled = true;
        this.supportsP1InSelect = true;
    }

    public CardFilePath getPath() {
        return this.currentPath;
    }

    public CardFileInfo getFCI() {
        return this.currentFCI;
    }

    public boolean elementaryFileSelected() {
        return this.isElementaryFile;
    }

    public void setSelectCommandResponseQualifier(byte by) {
        this.selectFCI = by;
    }

    public byte getSelectCommandResponseQualifier() {
        return this.selectFCI;
    }

    public void setLeInSelectFlag(boolean bl) {
        this.leInSelectEnabled = bl;
    }

    public boolean isLeInSelectEnabled() {
        return this.leInSelectEnabled;
    }

    public void setImplicitlySelectedBySFI(CardFilePath cardFilePath) {
        this.currentPath = cardFilePath;
        this.currentFCI = null;
        this.isElementaryFile = true;
    }

    protected ResponseAPDU doSelect(CardChannel cardChannel, CardFilePathComponent cardFilePathComponent, boolean bl, byte by, SecureChannelCredential secureChannelCredential) throws InvalidCardChannelException, CardTerminalException {
        ResponseAPDU responseAPDU;
        Object object;
        CommandAPDU commandAPDU = new CommandAPDU(30);
        commandAPDU.append((byte)0);
        commandAPDU.append((byte)-92);
        if (by != -1) {
            commandAPDU.append(by);
        } else if (cardFilePathComponent == null) {
            commandAPDU.append((byte)3);
        } else if (cardFilePathComponent instanceof CardFileAppID) {
            commandAPDU.append((byte)4);
        } else if (cardFilePathComponent.equals(root_file)) {
            commandAPDU.append((byte)0);
        } else if (this.supportsP1InSelect) {
            commandAPDU.append(bl ? (byte)1 : 2);
        } else {
            commandAPDU.append((byte)0);
        }
        commandAPDU.append(this.selectFCI);
        if (cardFilePathComponent != null) {
            if (cardFilePathComponent instanceof CardFileFileID) {
                commandAPDU.append((byte)2);
                commandAPDU.append(((CardFileFileID)cardFilePathComponent).toByteArray());
            } else if (cardFilePathComponent instanceof CardFileAppID) {
                object = ((CardFileAppID)cardFilePathComponent).toByteArray();
                commandAPDU.append((byte)((Object)object).length);
                commandAPDU.append((byte[])object);
            }
        }
        if (this.leInSelectEnabled) {
            commandAPDU.append((byte)0);
        }
        if (secureChannelCredential != null) {
            object = cardChannel.getSlotChannel();
            APDUTracer aPDUTracer = ((SlotChannel)object).getAPDUTracer();
            if (aPDUTracer != null && commandAPDU.getLength() > 5) {
                aPDUTracer.traceCommandAPDU((SlotChannel)object, commandAPDU);
            }
            int n = secureChannelCredential.getUsageQualifier();
            SecureChannel secureChannel = secureChannelCredential.getSecureChannel();
            commandAPDU = secureChannel.wrap(commandAPDU, n);
            responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
            responseAPDU = secureChannel.unwrap(responseAPDU, n);
            if (aPDUTracer != null && responseAPDU.getLength() > 2) {
                aPDUTracer.traceResponseAPDU((SlotChannel)object, responseAPDU);
            }
        } else {
            responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
        }
        if (responseAPDU.sw1() == 97) {
            commandAPDU.setLength(0);
            commandAPDU.append((byte)0);
            commandAPDU.append((byte)-64);
            commandAPDU.append((byte)0);
            commandAPDU.append((byte)0);
            commandAPDU.append(responseAPDU.sw2());
            responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
        }
        return responseAPDU;
    }

    public synchronized int selectFile(CardChannel cardChannel, SecureChannelCredential secureChannelCredential, CardFilePath cardFilePath, boolean bl) throws InvalidCardChannelException, CardTerminalException, CardServiceObjectNotAvailableException, CardServiceUnexpectedStatusWordException {
        boolean bl2 = false;
        ResponseAPDU responseAPDU = new ResponseAPDU(new byte[]{-112, 0});
        if (cardFilePath.equals(this.currentPath) && !bl) {
            ctracer.info("selectFile", "File already selected");
            return -1;
        }
        CardFilePath cardFilePath2 = new CardFilePath(this.currentPath);
        if (this.isElementaryFile) {
            ctracer.info("selectFile", "Stripping last element of current path");
            if (!cardFilePath2.chompTail()) {
                bl2 = true;
            } else if (cardFilePath2.equals(cardFilePath) && !bl) {
                ctracer.info("selectFile", "Directory already selected");
                this.currentFCI = null;
                return -1;
            }
        }
        CardFilePath cardFilePath3 = new CardFilePath(cardFilePath);
        if (cardFilePath.startsWith(cardFilePath2)) {
            cardFilePath3.chompPrefix(cardFilePath2);
        } else {
            int n = cardFilePath3.commonPrefixLength(cardFilePath2);
            if (n > 0 && cardFilePath2.numberOfComponents() - n == 1) {
                responseAPDU = this.doSelect(cardChannel, null, false, (byte)-1, secureChannelCredential);
                if (responseAPDU.sw() == 36864 || responseAPDU.sw() == 25219) {
                    this.isElementaryFile = false;
                    cardFilePath2.chompTail();
                    if (cardFilePath2.equals(cardFilePath3)) {
                        ctracer.info("selectFile", "FCI = " + HexString.hexify(responseAPDU.data()));
                        this.currentFCI = responseAPDU.getLength() > 2 ? new IsoFileControlInformation(responseAPDU.data()) : new IsoFileControlInformation();
                        this.currentPath = cardFilePath2;
                        return 0;
                    }
                    cardFilePath3.chompPrefix(cardFilePath2);
                } else {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
        }
        if (bl2) {
            cardFilePath2 = null;
        }
        ctracer.info("selectFile", "Going to select " + cardFilePath3.toString());
        Enumeration enumeration = cardFilePath3.components();
        int n = cardFilePath3.numberOfComponents();
        boolean bl3 = true;
        while (enumeration.hasMoreElements()) {
            CardFilePathComponent cardFilePathComponent = (CardFilePathComponent)enumeration.nextElement();
            if (cardFilePathComponent instanceof CardFileShortFileID) {
                if (cardFilePath2 != null) {
                    this.currentPath = cardFilePath2;
                }
                this.isElementaryFile = false;
                ctracer.info("selectFile", "Last path component is a short file identifier" + cardFilePathComponent);
                return ((CardFileShortFileID)cardFilePathComponent).toByte();
            }
            if (cardFilePathComponent instanceof CardFileFileID && n == 1) {
                bl3 = false;
            }
            if ((responseAPDU = this.doSelect(cardChannel, cardFilePathComponent, bl3, (byte)-1, secureChannelCredential)).sw1() == 103 && bl2) {
                ctracer.info("selectFile", "Invalid length when selecting MF - Trying without data");
                responseAPDU = this.doSelect(cardChannel, null, bl3, (byte)0, secureChannelCredential);
            }
            if (responseAPDU.sw() == 27270 || responseAPDU.sw() == 27392 || responseAPDU.sw() == 27265 || responseAPDU.sw() == 27136 || responseAPDU.sw1() == 103) {
                ctracer.info("selectFile", "Invalid P1/P2 - Trying FCI instead of FCP");
                this.selectFCI = 0;
                responseAPDU = this.doSelect(cardChannel, cardFilePathComponent, bl3, (byte)-1, secureChannelCredential);
                if (responseAPDU.sw() == 27270 || responseAPDU.sw() == 27392 || responseAPDU.sw() == 27265 || responseAPDU.sw() == 27136 || responseAPDU.sw1() == 103) {
                    ctracer.info("selectFile", "Invalid P1/P2 - Trying with P1 = 0");
                    this.supportsP1InSelect = false;
                    responseAPDU = this.doSelect(cardChannel, cardFilePathComponent, bl3, (byte)-1, secureChannelCredential);
                }
                if (responseAPDU.sw() == 26368) {
                    ctracer.info("selectFile", "Wrong length - Trying without Le");
                    this.leInSelectEnabled = false;
                    responseAPDU = this.doSelect(cardChannel, cardFilePathComponent, bl3, (byte)-1, secureChannelCredential);
                }
                if (responseAPDU.sw() == 26368) {
                    ctracer.info("selectFile", "Wrong length - Trying with P1='0C' and without Le");
                    this.leInSelectEnabled = false;
                    this.supportsP1InSelect = true;
                    this.selectFCI = (byte)12;
                    responseAPDU = this.doSelect(cardChannel, cardFilePathComponent, bl3, (byte)-1, secureChannelCredential);
                }
            }
            if (responseAPDU.sw() == 27266 && !bl3) {
                ctracer.info("selectFile", "EF not found - Trying DF");
                bl3 = true;
                responseAPDU = this.doSelect(cardChannel, cardFilePathComponent, bl3, (byte)-1, secureChannelCredential);
            }
            if (responseAPDU.sw() == 36864 || responseAPDU.sw() == 25219 || responseAPDU.sw1() == 97) {
                if (cardFilePath2 == null) {
                    cardFilePath2 = new CardFilePath(cardFilePathComponent.toString());
                    bl3 = true;
                } else {
                    cardFilePath2.append(cardFilePathComponent);
                }
                ctracer.info("selectFile", "FCI = " + HexString.hexify(responseAPDU.data()));
                this.currentFCI = responseAPDU.getLength() > 2 ? new IsoFileControlInformation(responseAPDU.data()) : new IsoFileControlInformation();
            } else {
                ctracer.error("selectFile", "SW1SW2 = " + HexString.hexifyShort(responseAPDU.sw()));
                bl3 = true;
                break;
            }
            --n;
        }
        if (cardFilePath2 != null) {
            this.currentPath = cardFilePath2;
            boolean bl4 = this.isElementaryFile = !bl3;
        }
        if (responseAPDU.sw() == 27266) {
            throw new CardServiceObjectNotAvailableException("File not found");
        }
        if (responseAPDU.sw() != 36864 && responseAPDU.sw() != 25219 && responseAPDU.sw1() != 97) {
            throw new CardServiceUnexpectedStatusWordException("SELECT", responseAPDU.sw());
        }
        return 0;
    }

    public synchronized int selectFile(CardChannel cardChannel, SecureChannelCredential secureChannelCredential, CardFilePath cardFilePath) throws InvalidCardChannelException, CardTerminalException, CardServiceObjectNotAvailableException, CardServiceUnexpectedStatusWordException {
        return this.selectFile(cardChannel, secureChannelCredential, cardFilePath, false);
    }
}

