/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.gemxcos;

import opencard.opt.iso.fs.CardFileInfo;

public class GemXCosFileControlInformation
implements CardFileInfo {
    byte[] fci = null;
    int filelength = -1;
    short fileid = (short)-1;
    int filetype = 8;
    int recordsize = -1;

    public GemXCosFileControlInformation() {
    }

    public GemXCosFileControlInformation(byte[] byArray) {
        this.fci = byArray;
        if (byArray.length >= 2) {
            this.filelength = ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
        }
        if (byArray.length >= 3) {
            this.filetype = byArray[2] & 0xFF;
        }
        if (byArray.length >= 5) {
            this.fileid = (short)(((byArray[3] & 0xFF) << 8) + (byArray[4] & 0xFF) & 0xFFFF);
        }
    }

    @Override
    public short getFileID() {
        return this.fileid;
    }

    @Override
    public boolean isDirectory() {
        return this.filetype == 56;
    }

    @Override
    public boolean isTransparent() {
        return (this.filetype & 1) == 1;
    }

    @Override
    public boolean isCyclic() {
        return (this.filetype & 6) == 6;
    }

    @Override
    public boolean isVariable() {
        return (this.filetype & 6) == 4;
    }

    @Override
    public int getLength() {
        return this.filelength;
    }

    @Override
    public int getRecordSize() {
        return this.recordsize;
    }

    @Override
    public byte[] getHeader() {
        return this.fci;
    }
}

