/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.gemxcos;

import de.cardcontact.opencard.service.CardServiceUnexpectedStatusWordException;
import de.cardcontact.opencard.service.gemxcos.GemXCosFileControlInformation;
import de.cardcontact.opencard.service.isocard.IsoCardService;
import de.cardcontact.opencard.service.isocard.IsoCardState;
import java.util.Enumeration;
import opencard.core.service.CardChannel;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceInabilityException;
import opencard.core.service.CardServiceInvalidParameterException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalIOControl;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import opencard.core.util.Tracer;
import opencard.opt.iso.fs.CardFileAppID;
import opencard.opt.iso.fs.CardFileFileID;
import opencard.opt.iso.fs.CardFileInfo;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.iso.fs.CardFilePathComponent;
import opencard.opt.iso.fs.CardIOException;
import opencard.opt.iso.fs.FileAccessCardService;
import opencard.opt.iso.fs.FileSystemCardService;
import opencard.opt.security.CHVCardService;
import opencard.opt.security.CredentialBag;
import opencard.opt.security.SecurityDomain;
import opencard.opt.service.CardServiceObjectNotAvailableException;

public class GemXCosCardService
extends CardService
implements FileAccessCardService,
FileSystemCardService,
CHVCardService {
    private static final CardFileFileID root_file = new CardFileFileID(16128);
    private static final CardFilePath root_path = new CardFilePath(":3F00");
    private static final Tracer ctracer = new Tracer(IsoCardService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize(CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws CardServiceException {
        super.initialize(cardServiceScheduler, smartCard, bl);
        ctracer.debug("initialize", "called");
        try {
            this.allocateCardChannel();
            IsoCardState isoCardState = (IsoCardState)this.getCardChannel().getState();
            if (isoCardState == null) {
                isoCardState = new IsoCardState();
                isoCardState.setPath(root_path);
                isoCardState.setSelectCommandResponseQualifier((byte)0);
                isoCardState.setLeInSelectFlag(false);
                this.getCardChannel().setState(isoCardState);
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    @Override
    public boolean exists(CardFilePath cardFilePath) throws CardServiceException, CardTerminalException {
        try {
            this.getFileInfo(cardFilePath);
        }
        catch (CardServiceObjectNotAvailableException cardServiceObjectNotAvailableException) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CardFileInfo getFileInfo(CardFilePath cardFilePath) throws CardServiceException, CardTerminalException {
        CardFileInfo cardFileInfo;
        try {
            this.allocateCardChannel();
            cardFileInfo = this.selectFile(this.getCardChannel(), cardFilePath);
        }
        finally {
            this.releaseCardChannel();
        }
        return cardFileInfo;
    }

    @Override
    public CardFilePath getRoot() {
        return root_path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read(CardFilePath cardFilePath, int n, int n2) throws CardServiceException, CardTerminalException {
        CommandAPDU commandAPDU = new CommandAPDU(5);
        ResponseAPDU responseAPDU = new ResponseAPDU(258);
        byte[] byArray = null;
        if (n < 0 || n > Short.MAX_VALUE || n2 != -1 && n2 < 0) {
            throw new CardServiceInvalidParameterException("read: offset = " + n + ", length = " + n2);
        }
        try {
            int n3;
            this.allocateCardChannel();
            CardChannel cardChannel = this.getCardChannel();
            if (this.selectFile(cardChannel, cardFilePath) == null) {
                throw new CardIOException("File not found");
            }
            for (int i = n2 == -1 ? 32768 : n2; i > 0; i -= n3) {
                commandAPDU.setLength(0);
                commandAPDU.append((byte)0);
                commandAPDU.append((byte)-80);
                commandAPDU.append((byte)(n >> 8));
                commandAPDU.append((byte)n);
                byte by = n2 == -1 ? (byte)-36 : (byte)(i > 220 ? 220 : i);
                commandAPDU.append(by);
                responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
                if (responseAPDU.sw1() == 108) {
                    commandAPDU.setLength(4);
                    commandAPDU.append(responseAPDU.sw2());
                    responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
                }
                if (responseAPDU.sw() == 27392 && n2 == -1) {
                    break;
                }
                if (responseAPDU.sw() == 36864 || responseAPDU.sw() == 25218) {
                    n3 = responseAPDU.getLength() - 2;
                    if (byArray == null) {
                        byArray = new byte[n3];
                        System.arraycopy(responseAPDU.getBuffer(), 0, byArray, 0, n3);
                    } else {
                        byte[] byArray2 = new byte[byArray.length + n3];
                        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                        System.arraycopy(responseAPDU.getBuffer(), 0, byArray2, byArray.length, n3);
                        byArray = byArray2;
                    }
                    n += n3;
                    if (responseAPDU.sw() == 25218) break;
                    if (by != 0 || n3 >= 256) continue;
                    break;
                }
                throw new CardServiceUnexpectedStatusWordException("READ_BINARY", responseAPDU.sw());
            }
        }
        finally {
            this.releaseCardChannel();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readRecord(CardFilePath cardFilePath, int n) throws CardServiceException, CardTerminalException {
        CommandAPDU commandAPDU = new CommandAPDU(5);
        ResponseAPDU responseAPDU = new ResponseAPDU(258);
        byte[] byArray = null;
        try {
            this.allocateCardChannel();
            CardChannel cardChannel = this.getCardChannel();
            if (this.selectFile(cardChannel, cardFilePath) == null) {
                throw new CardIOException("File not found");
            }
            commandAPDU.setLength(0);
            commandAPDU.append((byte)0);
            commandAPDU.append((byte)-78);
            commandAPDU.append((byte)n);
            commandAPDU.append((byte)4);
            commandAPDU.append((byte)0);
            responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
            if (responseAPDU.sw() != 36864) {
                throw new CardServiceUnexpectedStatusWordException("READ_RECORD", responseAPDU.sw());
            }
            byArray = new byte[responseAPDU.data().length];
            System.arraycopy(responseAPDU.data(), 0, byArray, 0, responseAPDU.data().length);
        }
        finally {
            this.releaseCardChannel();
        }
        return byArray;
    }

    @Override
    public byte[][] readRecords(CardFilePath cardFilePath, int n) throws CardServiceException, CardTerminalException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(CardFilePath cardFilePath, int n, byte[] byArray, int n2, int n3) throws CardServiceException, CardTerminalException {
        CommandAPDU commandAPDU = new CommandAPDU(261);
        ResponseAPDU responseAPDU = new ResponseAPDU(2);
        if (n < 0 || n > Short.MAX_VALUE || n3 < 0) {
            throw new CardServiceInvalidParameterException("write: offset = " + n + ", length = " + n3);
        }
        try {
            this.allocateCardChannel();
            CardChannel cardChannel = this.getCardChannel();
            if (this.selectFile(cardChannel, cardFilePath) == null) {
                throw new CardIOException("File not found");
            }
            while (n3 > 0) {
                int n4 = n3 > 220 ? 220 : n3;
                commandAPDU.setLength(0);
                commandAPDU.append((byte)0);
                commandAPDU.append((byte)-42);
                commandAPDU.append((byte)(n >> 8));
                commandAPDU.append((byte)n);
                commandAPDU.append((byte)n4);
                System.arraycopy(byArray, n2, commandAPDU.getBuffer(), 5, n4);
                commandAPDU.setLength(5 + n4);
                responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
                if (responseAPDU.sw() != 36864) {
                    throw new CardServiceUnexpectedStatusWordException("UPDATE_BINARY", responseAPDU.sw());
                }
                n += n4;
                n2 += n4;
                n3 -= n4;
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    @Override
    public void write(CardFilePath cardFilePath, int n, byte[] byArray) throws CardServiceException, CardTerminalException {
        this.write(cardFilePath, n, byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRecord(CardFilePath cardFilePath, int n, byte[] byArray) throws CardServiceException, CardTerminalException {
        CommandAPDU commandAPDU = new CommandAPDU(261);
        ResponseAPDU responseAPDU = new ResponseAPDU(2);
        if (n < 0 || n > 254) {
            throw new CardServiceInvalidParameterException("writeRecord: recordNumber = " + n);
        }
        if (byArray.length > 255) {
            throw new CardServiceInvalidParameterException("writeRecord: length of data = " + byArray.length);
        }
        try {
            this.allocateCardChannel();
            CardChannel cardChannel = this.getCardChannel();
            if (this.selectFile(cardChannel, cardFilePath) == null) {
                throw new CardIOException("File not found");
            }
            commandAPDU.setLength(0);
            commandAPDU.append((byte)0);
            commandAPDU.append((byte)-36);
            commandAPDU.append((byte)(n + 1));
            commandAPDU.append((byte)4);
            commandAPDU.append((byte)byArray.length);
            System.arraycopy(byArray, 0, commandAPDU.getBuffer(), 5, byArray.length);
            commandAPDU.setLength(5 + byArray.length);
            responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
            if (responseAPDU.sw() != 36864) {
                throw new CardServiceUnexpectedStatusWordException("UPDATE_RECORD", responseAPDU.sw());
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendRecord(CardFilePath cardFilePath, byte[] byArray) throws CardServiceException, CardTerminalException {
        CommandAPDU commandAPDU = new CommandAPDU(261);
        ResponseAPDU responseAPDU = new ResponseAPDU(2);
        if (byArray.length > 255) {
            throw new CardServiceInvalidParameterException("appendRecord: length of data = " + byArray.length);
        }
        try {
            this.allocateCardChannel();
            CardChannel cardChannel = this.getCardChannel();
            if (this.selectFile(cardChannel, cardFilePath) == null) {
                throw new CardIOException("File not found");
            }
            commandAPDU.setLength(0);
            commandAPDU.append((byte)0);
            commandAPDU.append((byte)-30);
            commandAPDU.append((byte)0);
            commandAPDU.append((byte)0);
            commandAPDU.append((byte)byArray.length);
            System.arraycopy(byArray, 0, commandAPDU.getBuffer(), 5, byArray.length);
            commandAPDU.setLength(5 + byArray.length);
            responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
            if (responseAPDU.sw() != 36864) {
                throw new CardServiceUnexpectedStatusWordException("APPEND_RECORD", responseAPDU.sw());
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    @Override
    public void provideCredentials(SecurityDomain securityDomain, CredentialBag credentialBag) throws CardServiceException {
    }

    protected ResponseAPDU doSelect(CardChannel cardChannel, CardFilePathComponent cardFilePathComponent, boolean bl, byte by, byte by2, boolean bl2) throws InvalidCardChannelException, CardTerminalException {
        ResponseAPDU responseAPDU;
        CommandAPDU commandAPDU = new CommandAPDU(30);
        commandAPDU.append((byte)0);
        commandAPDU.append((byte)-92);
        if (by != -1) {
            commandAPDU.append(by);
        } else if (cardFilePathComponent == null) {
            commandAPDU.append((byte)3);
        } else if (cardFilePathComponent instanceof CardFileAppID) {
            commandAPDU.append((byte)4);
        } else if (cardFilePathComponent.equals(root_file)) {
            commandAPDU.append((byte)0);
        } else {
            commandAPDU.append(bl ? (byte)1 : 2);
        }
        commandAPDU.append(by2);
        if (cardFilePathComponent != null) {
            if (cardFilePathComponent instanceof CardFileFileID) {
                commandAPDU.append((byte)2);
                commandAPDU.append(((CardFileFileID)cardFilePathComponent).toByteArray());
            } else if (cardFilePathComponent instanceof CardFileAppID) {
                byte[] byArray = ((CardFileAppID)cardFilePathComponent).toByteArray();
                commandAPDU.append((byte)byArray.length);
                commandAPDU.append(byArray);
            }
        }
        if (bl2) {
            commandAPDU.append((byte)0);
        }
        if ((responseAPDU = cardChannel.sendCommandAPDU(commandAPDU)).sw1() == 97) {
            commandAPDU.setLength(0);
            commandAPDU.append((byte)0);
            commandAPDU.append((byte)-64);
            commandAPDU.append((byte)0);
            commandAPDU.append((byte)0);
            commandAPDU.append(responseAPDU.sw2());
            responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
        }
        return responseAPDU;
    }

    public synchronized CardFileInfo selectFile(CardChannel cardChannel, CardFilePath cardFilePath) throws InvalidCardChannelException, CardTerminalException, CardServiceObjectNotAvailableException, CardServiceUnexpectedStatusWordException {
        boolean bl = false;
        ResponseAPDU responseAPDU = new ResponseAPDU(new byte[]{-112, 0});
        IsoCardState isoCardState = (IsoCardState)cardChannel.getState();
        CardFileInfo cardFileInfo = isoCardState.getFCI();
        if (!cardFilePath.equals(isoCardState.getPath()) || cardFileInfo == null) {
            CardFilePath cardFilePath2 = new CardFilePath(isoCardState.getPath());
            if ((isoCardState.elementaryFileSelected() || cardFileInfo == null) && !cardFilePath2.chompTail()) {
                bl = true;
            }
            CardFilePath cardFilePath3 = new CardFilePath(cardFilePath);
            if (cardFilePath.startsWith(cardFilePath2)) {
                cardFilePath3.chompPrefix(cardFilePath2);
            } else {
                int n = cardFilePath3.commonPrefixLength(cardFilePath2);
                if (n >= 1 && cardFilePath2.numberOfComponents() - n == 1) {
                    responseAPDU = this.doSelect(cardChannel, null, false, (byte)-1, isoCardState.getSelectCommandResponseQualifier(), isoCardState.isLeInSelectEnabled());
                    if (responseAPDU.sw() == 36864 || responseAPDU.sw() == 25219) {
                        cardFilePath2.chompTail();
                        cardFilePath3.chompPrefix(cardFilePath2);
                    } else {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            }
            if (bl) {
                cardFilePath2 = null;
            }
            ctracer.info("selectFile", "Going to select " + cardFilePath3.toString());
            Enumeration enumeration = cardFilePath3.components();
            int n = cardFilePath3.numberOfComponents();
            boolean bl2 = true;
            while (enumeration.hasMoreElements()) {
                CardFilePathComponent cardFilePathComponent = (CardFilePathComponent)enumeration.nextElement();
                if (cardFilePathComponent instanceof CardFileFileID && n == 1) {
                    bl2 = false;
                }
                if ((responseAPDU = this.doSelect(cardChannel, cardFilePathComponent, bl2, (byte)-1, isoCardState.getSelectCommandResponseQualifier(), isoCardState.isLeInSelectEnabled())).sw1() == 103 && bl) {
                    ctracer.info("selectFile", "Invalid length when selecting MF - Trying without data");
                    responseAPDU = this.doSelect(cardChannel, null, bl2, (byte)0, isoCardState.getSelectCommandResponseQualifier(), isoCardState.isLeInSelectEnabled());
                }
                if (responseAPDU.sw() == 27270 || responseAPDU.sw() == 27392 || responseAPDU.sw() == 27136) {
                    ctracer.info("selectFile", "Invalid P1/P2 - Trying FCI instead of FCP");
                    isoCardState.setSelectCommandResponseQualifier((byte)0);
                    responseAPDU = this.doSelect(cardChannel, cardFilePathComponent, bl2, (byte)-1, isoCardState.getSelectCommandResponseQualifier(), isoCardState.isLeInSelectEnabled());
                    if (responseAPDU.sw() == 26368) {
                        ctracer.info("selectFile", "Wrong length - Trying without Le");
                        isoCardState.setLeInSelectFlag(false);
                        responseAPDU = this.doSelect(cardChannel, cardFilePathComponent, bl2, (byte)-1, isoCardState.getSelectCommandResponseQualifier(), isoCardState.isLeInSelectEnabled());
                    }
                }
                if (responseAPDU.sw() == 27266 && !bl2) {
                    ctracer.info("selectFile", "EF not found - Trying DF");
                    bl2 = true;
                    responseAPDU = this.doSelect(cardChannel, cardFilePathComponent, bl2, (byte)-1, isoCardState.getSelectCommandResponseQualifier(), isoCardState.isLeInSelectEnabled());
                }
                if (responseAPDU.sw() == 36864 || responseAPDU.sw() == 25219 || responseAPDU.sw1() == 97) {
                    if (cardFilePath2 == null) {
                        cardFilePath2 = new CardFilePath(cardFilePathComponent.toString());
                        bl2 = true;
                    } else {
                        cardFilePath2.append(cardFilePathComponent);
                    }
                    ctracer.info("selectFile", "FCI = " + HexString.hexify(responseAPDU.data()));
                    cardFileInfo = responseAPDU.getLength() > 2 ? new GemXCosFileControlInformation(responseAPDU.data()) : new GemXCosFileControlInformation();
                } else {
                    ctracer.error("selectFile", "SW1SW2 = " + HexString.hexifyShort(responseAPDU.sw()));
                    bl2 = true;
                    break;
                }
                --n;
            }
            if (cardFilePath2 != null) {
                isoCardState.setPath(cardFilePath2);
                isoCardState.setFCI(cardFileInfo, !bl2);
            }
            if (responseAPDU.sw() == 27266) {
                throw new CardServiceObjectNotAvailableException("File not found");
            }
            if (responseAPDU.sw() != 36864 && responseAPDU.sw() != 25219 && responseAPDU.sw1() != 97) {
                throw new CardServiceUnexpectedStatusWordException("SELECT", responseAPDU.sw());
            }
        }
        return cardFileInfo;
    }

    @Override
    public int getPasswordLength(SecurityDomain securityDomain, int n) throws CardServiceException, CardTerminalException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifyPassword(SecurityDomain securityDomain, int n, byte[] byArray) throws CardServiceException, CardTerminalException {
        boolean bl;
        block8: {
            bl = false;
            CommandAPDU commandAPDU = new CommandAPDU(40);
            ResponseAPDU responseAPDU = new ResponseAPDU(2);
            try {
                Object object;
                this.allocateCardChannel();
                CardChannel cardChannel = this.getCardChannel();
                if (securityDomain != null && this.selectFile(cardChannel, (CardFilePath)(object = (CardFilePath)securityDomain)) == null) {
                    throw new CardIOException("File not found");
                }
                commandAPDU.setLength(0);
                commandAPDU.append((byte)0);
                commandAPDU.append((byte)32);
                commandAPDU.append((byte)0);
                commandAPDU.append((byte)0);
                if (byArray != null) {
                    commandAPDU.append((byte)byArray.length);
                    System.arraycopy(byArray, 0, commandAPDU.getBuffer(), 5, byArray.length);
                    commandAPDU.setLength(5 + byArray.length);
                    responseAPDU = cardChannel.sendCommandAPDU(commandAPDU);
                } else {
                    commandAPDU.append((byte)8);
                    commandAPDU.append(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1});
                    object = new CardTerminalIOControl(8, 30, "0123456789", "");
                    CHVControl cHVControl = new CHVControl(null, n, "String encoding", 0, (CardTerminalIOControl)object);
                    responseAPDU = cardChannel.sendVerifiedAPDU(commandAPDU, cHVControl, null);
                }
                if (responseAPDU.sw() == 36864) {
                    bl = true;
                    break block8;
                }
                if ((responseAPDU.sw() & 0xFFF0) == 25536) {
                    bl = false;
                    break block8;
                }
                throw new CardServiceUnexpectedStatusWordException("VERIFY", responseAPDU.sw());
            }
            finally {
                this.releaseCardChannel();
            }
        }
        return bl;
    }

    @Override
    public void closeApplication(SecurityDomain securityDomain) throws CardServiceException, CardTerminalException {
    }

    @Override
    public void create(CardFilePath cardFilePath, byte[] byArray) throws CardServiceException, CardTerminalException {
    }

    @Override
    public void delete(CardFilePath cardFilePath) throws CardServiceException, CardTerminalException {
    }

    @Override
    public void invalidate(CardFilePath cardFilePath) throws CardServiceInabilityException, CardServiceException, CardTerminalException {
    }

    @Override
    public void rehabilitate(CardFilePath cardFilePath) throws CardServiceInabilityException, CardServiceException, CardTerminalException {
    }
}

