/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service;

import opencard.core.util.HexString;

public class StatusWordTable {
    public static String StringForSW(int n) {
        String string = null;
        if ((n & 0xFFF0) == 25536) {
            string = "Warning processing: Counter at " + (n & 0xF);
        } else {
            block0 : switch (n & 0xFF00) {
                case 36864: {
                    string = "Normal processing: No error";
                    break;
                }
                case 24832: {
                    string = "Normal processing: " + (n & 0xFF) + " additional bytes available";
                    break;
                }
                case 27648: {
                    string = "Checking error: Invalid Le, " + (n & 0xFF) + " bytes are available";
                    break;
                }
                case 27904: {
                    string = "Checking error: Invalid instruction (" + (n & 0xFF) + ")";
                    break;
                }
                case 26368: {
                    string = "Checking error: Wrong length";
                    break;
                }
                default: {
                    switch (n) {
                        case 25218: {
                            string = "Warning processing: End of file reached before reading Ne bytes ";
                            break block0;
                        }
                        case 25219: {
                            string = "Warning processing: Selected file deactivated";
                            break block0;
                        }
                        case 25344: {
                            string = "Warning processing: State of non-volatile memory changed";
                            break block0;
                        }
                        case 26624: {
                            string = "Checking error: Function in CLA byte not supported";
                            break block0;
                        }
                        case 26753: {
                            string = "Checking error: Logical channel not supported";
                            break block0;
                        }
                        case 26754: {
                            string = "Checking error: Secure Messaging not supported";
                            break block0;
                        }
                        case 26755: {
                            string = "Checking error: Last command of the chain expected";
                            break block0;
                        }
                        case 26756: {
                            string = "Checking error: Command chaining not supported";
                            break block0;
                        }
                        case 26880: {
                            string = "Checking error: Command not allowed";
                            break block0;
                        }
                        case 27009: {
                            string = "Checking error: Command incompatible with file structure";
                            break block0;
                        }
                        case 27010: {
                            string = "Checking error: Security condition not satisfied";
                            break block0;
                        }
                        case 27011: {
                            string = "Checking error: Authentication method locked";
                            break block0;
                        }
                        case 27012: {
                            string = "Checking error: Reference data not usable";
                            break block0;
                        }
                        case 27013: {
                            string = "Checking error: Condition of use not satisfied";
                            break block0;
                        }
                        case 27014: {
                            string = "Checking error: Command not allowed (no current EF)";
                            break block0;
                        }
                        case 27015: {
                            string = "Checking error: Expected secure messaging object missing";
                            break block0;
                        }
                        case 27016: {
                            string = "Checking error: Incorrect secure messaging data object";
                            break block0;
                        }
                        case 27136: {
                            string = "Checking error: Wrong parameter P1-P2";
                            break block0;
                        }
                        case 27264: {
                            string = "Checking error: Incorrect parameter in the command data field";
                            break block0;
                        }
                        case 27265: {
                            string = "Checking error: Function not supported";
                            break block0;
                        }
                        case 27266: {
                            string = "Checking error: File not found";
                            break block0;
                        }
                        case 27267: {
                            string = "Checking error: Record not found";
                            break block0;
                        }
                        case 27268: {
                            string = "Checking error: Not enough memory space in the file";
                            break block0;
                        }
                        case 27269: {
                            string = "Checking error: Nc inconsistent with TLV structure";
                            break block0;
                        }
                        case 27270: {
                            string = "Checking error: Incorrect P1-P2";
                            break block0;
                        }
                        case 27271: {
                            string = "Checking error: Lc inconsistent with P1-P2";
                            break block0;
                        }
                        case 27272: {
                            string = "Checking error: Reference data not found";
                            break block0;
                        }
                        case 27273: {
                            string = "Checking error: File already exists";
                            break block0;
                        }
                        case 27274: {
                            string = "Checking error: DF name already exists";
                            break block0;
                        }
                        case 27392: {
                            string = "Checking error: Wrong parameter P1-P2";
                            break block0;
                        }
                        case 28160: {
                            string = "Checking error: Class not supported";
                            break block0;
                        }
                        case 28416: {
                            string = "Checking error: No precise diagnosis";
                        }
                    }
                }
            }
        }
        return string;
    }

    public static String MessageForSW(int n) {
        String string = StatusWordTable.StringForSW(n);
        if (string == null) {
            return "SW1/SW2=" + HexString.hexifyShort((short)n);
        }
        return "SW1/SW2=" + HexString.hexifyShort((short)n) + " (" + string + ")";
    }
}

