/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.security;

import de.cardcontact.opencard.security.SecureChannel;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import opencard.core.service.CardServiceInvalidCredentialException;
import opencard.core.service.CardServiceInvalidParameterException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import opencard.opt.util.TLV;
import opencard.opt.util.Tag;

public class IsoSecureChannel
implements SecureChannel {
    protected String provider;
    protected String macalgorithm;
    protected String cipheralgorithm;
    protected Key kenc;
    protected Key kmac;
    protected byte[] encssc;
    protected byte[] macssc;
    protected byte[] iv;
    protected byte[] crt;
    protected int maclen;
    protected int blocklen;
    protected SSCPolicyEnum sscpolicy = SSCPolicyEnum.DEFAULT;
    private static byte[] one = new byte[]{1};
    private static final boolean singleByteT97 = false;

    public IsoSecureChannel() {
        this("BC");
    }

    public IsoSecureChannel(String string) {
        this.provider = string;
        this.kenc = null;
        this.kmac = null;
        this.encssc = null;
        this.macssc = null;
        this.iv = new byte[8];
        this.maclen = 8;
        this.blocklen = 8;
        this.crt = null;
    }

    protected static byte[] incrementSSC(byte[] byArray) {
        int n;
        int n2;
        int n3;
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = new BigInteger(one);
        bigInteger = bigInteger.add(bigInteger2);
        byte[] byArray2 = new byte[byArray.length];
        byte[] byArray3 = bigInteger.toByteArray();
        if (byArray3.length > byArray2.length) {
            n3 = byArray3.length - byArray2.length;
            n2 = 0;
            n = byArray2.length;
        } else {
            n3 = 0;
            n2 = byArray2.length - byArray3.length;
            n = byArray3.length;
        }
        System.arraycopy(byArray3, n3, byArray2, n2, n);
        return byArray2;
    }

    protected void incrementMACSSC() {
        this.macssc = IsoSecureChannel.incrementSSC(this.macssc);
    }

    protected void incrementENCSSC() {
        this.encssc = IsoSecureChannel.incrementSSC(this.encssc);
    }

    protected byte[] getIV(Cipher cipher) throws GeneralSecurityException {
        byte[] byArray = this.iv;
        if (this.sscpolicy == SSCPolicyEnum.SYNC_AND_ENCRYPT) {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            cipher.init(1, this.kenc, ivParameterSpec);
            byArray = cipher.doFinal(this.macssc);
        } else if (this.sscpolicy == SSCPolicyEnum.SYNC) {
            byArray = this.macssc;
        } else if (this.encssc != null) {
            byArray = this.encssc;
        }
        return byArray;
    }

    protected byte[] encodeBodyEvenINS(byte[] byArray, boolean bl, boolean bl2) {
        TLV tLV = null;
        if (bl) {
            if (this.encssc != null) {
                this.incrementENCSSC();
            }
            int n = (byArray.length & ~(this.blocklen - 1)) + this.blocklen;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray2[byArray.length] = -128;
            try {
                Cipher cipher = Cipher.getInstance(this.cipheralgorithm, this.provider);
                byte[] byArray3 = this.getIV(cipher);
                IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3);
                cipher.init(1, this.kenc, ivParameterSpec);
                byte[] byArray4 = cipher.doFinal(byArray2);
                byte[] byArray5 = new byte[byArray4.length + 1];
                byArray5[0] = 1;
                System.arraycopy(byArray4, 0, byArray5, 1, byArray4.length);
                tLV = new TLV(new Tag(bl2 ? 7 : 6, 2, false), byArray5);
            }
            catch (Exception exception) {
                throw new CardServiceInvalidParameterException(exception.getMessage());
            }
            if (!bl2 && this.macssc != null) {
                this.incrementMACSSC();
            }
        } else {
            tLV = new TLV(new Tag(bl2 ? 1 : 0, 2, false), byArray);
        }
        return tLV.toBinary();
    }

    protected byte[] encodeBodyOddINS(byte[] byArray, boolean bl, boolean bl2) {
        TLV tLV = null;
        if (bl) {
            if (this.encssc != null) {
                this.incrementENCSSC();
            }
            int n = (byArray.length & ~(this.blocklen - 1)) + this.blocklen;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray2[byArray.length] = -128;
            try {
                Cipher cipher = Cipher.getInstance(this.cipheralgorithm, this.provider);
                byte[] byArray3 = this.getIV(cipher);
                IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3);
                cipher.init(1, this.kenc, ivParameterSpec);
                byte[] byArray4 = cipher.doFinal(byArray2);
                tLV = new TLV(new Tag(bl2 ? 5 : 4, 2, false), byArray4);
            }
            catch (Exception exception) {
                throw new CardServiceInvalidParameterException(exception.getMessage());
            }
            if (!bl2 && this.macssc != null) {
                this.incrementMACSSC();
            }
        } else {
            tLV = new TLV(new Tag(bl2 ? 3 : 2, 2, true), byArray);
        }
        return tLV.toBinary();
    }

    protected byte[] calculateMAC(byte by, byte by2, byte by3, byte by4, byte[] byArray, byte[] byArray2) {
        byte[] byArray3;
        int n = this.blocklen;
        boolean bl = false;
        if (this.macssc != null) {
            n += this.macssc.length;
        }
        if (this.crt != null && (this.crt[0] & 1) == 1) {
            n += this.crt.length;
            bl = true;
        }
        if (byArray != null) {
            n += byArray.length;
            bl = true;
        }
        if (byArray2 != null) {
            n += byArray2.length;
            bl = true;
        }
        if (bl) {
            n = (n & ~(this.blocklen - 1)) + this.blocklen;
        }
        byte[] byArray4 = new byte[n];
        int n2 = 0;
        if (this.macssc != null) {
            System.arraycopy(this.macssc, 0, byArray4, n2, this.macssc.length);
            n2 += this.macssc.length;
        }
        byArray4[n2++] = (byte)(by | 0xC);
        byArray4[n2++] = by2;
        byArray4[n2++] = by3;
        byArray4[n2++] = by4;
        byArray4[n2++] = -128;
        for (int i = this.blocklen - 5; i > 0; --i) {
            byArray4[n2++] = 0;
        }
        if (this.crt != null && (this.crt[0] & 1) == 1) {
            System.arraycopy(this.crt, 0, byArray4, n2, this.crt.length);
            n2 += this.crt.length;
        }
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray4, n2, byArray.length);
            n2 += byArray.length;
        }
        if (byArray2 != null) {
            System.arraycopy(byArray2, 0, byArray4, n2, byArray2.length);
            n2 += byArray2.length;
        }
        if (bl) {
            byArray4[n2++] = -128;
            while (n2 < n) {
                byArray4[n2++] = 0;
            }
        }
        try {
            Mac mac = Mac.getInstance(this.macalgorithm, this.provider);
            mac.init(this.kmac);
            byte[] byArray5 = mac.doFinal(byArray4);
            byArray3 = new byte[2 + this.maclen];
            byArray3[0] = -114;
            byArray3[1] = (byte)this.maclen;
            System.arraycopy(byArray5, 0, byArray3, 2, this.maclen);
        }
        catch (Exception exception) {
            throw new CardServiceInvalidParameterException(exception.getMessage());
        }
        return byArray3;
    }

    @Override
    public CommandAPDU wrap(CommandAPDU commandAPDU, int n) {
        boolean bl = (n & 1) > 0;
        boolean bl2 = (n & 2) > 0;
        int n2 = -1;
        byte[] byArray = null;
        byte by = (byte)(commandAPDU.getByte(0) | 8);
        byte by2 = (byte)commandAPDU.getByte(1);
        byte by3 = (byte)commandAPDU.getByte(2);
        byte by4 = (byte)commandAPDU.getByte(3);
        boolean bl3 = (by2 & 1) == 1;
        boolean bl4 = false;
        int n3 = commandAPDU.getLength() - 4;
        if (n3 > 0) {
            int n4;
            int n5 = 4;
            if ((n4 = commandAPDU.getByte(n5++)) == 0 && --n3 > 0) {
                bl4 = true;
                if (n3 < 2) {
                    throw new CardServiceInvalidParameterException("Invalid Le in extended APDU");
                }
                n4 = (commandAPDU.getByte(n5) << 8) + commandAPDU.getByte(n5 + 1);
                n5 += 2;
                n3 -= 2;
            }
            if (n3 > 0) {
                if (n3 < n4) {
                    throw new CardServiceInvalidParameterException("Invalid Lc in APDU");
                }
                byArray = new byte[n4];
                System.arraycopy(commandAPDU.getBuffer(), n5, byArray, 0, n4);
                n5 += n4;
                if ((n3 -= n4) > 0) {
                    n2 = commandAPDU.getByte(n5++);
                    --n3;
                    if (bl4) {
                        if (n3 < 1) {
                            throw new CardServiceInvalidParameterException("Invalid Le in extended APDU");
                        }
                        n2 = (n2 << 8) + commandAPDU.getByte(n5++);
                        --n3;
                    }
                }
            } else {
                n2 = n4;
            }
            if (n3 > 0) {
                throw new CardServiceInvalidParameterException("Unexpected bytes in APDU");
            }
        }
        if (bl && this.macssc != null) {
            this.incrementMACSSC();
        }
        byte[] byArray2 = null;
        if (byArray != null || this.crt != null) {
            byArray2 = bl3 ? this.encodeBodyOddINS(byArray, bl2, bl) : this.encodeBodyEvenINS(byArray, bl2, bl);
        }
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (n2 >= 0) {
            byArray3 = new byte[bl4 ? 4 : 3];
            int n6 = byArray3[0] = bl ? -105 : -106;
            if (bl4) {
                byArray3[1] = 2;
                byArray3[2] = (byte)(n2 >> 8);
                byArray3[3] = (byte)(n2 & 0xFF);
            } else {
                byArray3[1] = 1;
                byArray3[2] = (byte)(n2 & 0xFF);
            }
        }
        if (bl) {
            by = (byte)(by | 4);
            byArray4 = this.calculateMAC(by, by2, by3, by4, byArray2, byArray3);
        }
        int n7 = 0;
        if (this.crt != null) {
            n7 += this.crt.length;
        }
        if (byArray2 != null) {
            n7 += byArray2.length;
        }
        if (byArray3 != null) {
            n7 += byArray3.length;
        }
        if (byArray4 != null) {
            n7 += byArray4.length;
        }
        if (n7 > 255) {
            bl4 = true;
        }
        CommandAPDU commandAPDU2 = new CommandAPDU(10 + n7);
        commandAPDU2.append(by);
        commandAPDU2.append(by2);
        commandAPDU2.append(by3);
        commandAPDU2.append(by4);
        if (n7 > 0) {
            if (bl4) {
                commandAPDU2.append((byte)0);
                commandAPDU2.append((byte)(n7 >> 8));
                commandAPDU2.append((byte)(n7 & 0xFF));
            } else {
                commandAPDU2.append((byte)n7);
            }
        }
        if (this.crt != null) {
            commandAPDU2.append(this.crt);
        }
        if (byArray2 != null) {
            commandAPDU2.append(byArray2);
        }
        if (byArray3 != null) {
            commandAPDU2.append(byArray3);
        }
        if (byArray4 != null) {
            commandAPDU2.append(byArray4);
        }
        if (n2 != -1 || (n & 0xC) > 0) {
            commandAPDU2.append((byte)0);
            if (bl4) {
                commandAPDU2.append((byte)0);
            }
        }
        return commandAPDU2;
    }

    @Override
    public ResponseAPDU unwrap(ResponseAPDU responseAPDU, int n) {
        int n2;
        byte[] byArray;
        Object object;
        int n3;
        byte[] byArray2;
        boolean bl = (n & 4) > 0;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        byte[] byArray6 = responseAPDU.getBuffer();
        int[] nArray = new int[]{0};
        block11: for (n3 = responseAPDU.getLength(); n3 > 2; n3 -= byArray2.length) {
            try {
                object = new TLV(byArray6, nArray);
                byArray2 = ((TLV)object).toBinary();
            }
            catch (Exception exception) {
                throw new CardServiceInvalidParameterException("Invalid encoding of TLV object in secure messaging response detected");
            }
            switch (byArray2[0]) {
                case -128: 
                case -127: 
                case -124: 
                case -123: 
                case -122: 
                case -121: 
                case -78: 
                case -77: {
                    if (byArray3 != null) {
                        throw new CardServiceInvalidParameterException("Data object " + HexString.hexify(byArray2[0]) + " detected in secure messaging response that contains data object 80,81,84,85,86,86,B2 or B3 as well");
                    }
                    byArray3 = byArray2;
                    continue block11;
                }
                case -103: {
                    if (byArray4 != null) {
                        throw new CardServiceInvalidParameterException("Duplicate data object 99 (SW) found in secure messaging response");
                    }
                    byArray4 = byArray2;
                    continue block11;
                }
                case -114: {
                    if (byArray5 != null) {
                        throw new CardServiceInvalidParameterException("Duplicate data object 8E (MAC) found in secure messaging response");
                    }
                    byArray5 = byArray2;
                    continue block11;
                }
                default: {
                    throw new CardServiceInvalidParameterException("Unknown data object found in secure messaging response");
                }
            }
        }
        if (n3 != 2) {
            throw new CardServiceInvalidParameterException("Length of secure messaging response message invalid");
        }
        if (bl) {
            if (byArray5 == null) {
                if (responseAPDU.sw() == 27015 || responseAPDU.sw() == 27016) {
                    return responseAPDU;
                }
                throw new CardServiceInvalidParameterException("MAC data object missing from secure messaging response");
            }
            if (byArray5.length != this.maclen + 2) {
                throw new CardServiceInvalidParameterException("MAC data object has wrong length");
            }
            int n4 = 0;
            if (this.macssc != null) {
                this.incrementMACSSC();
                n4 += this.macssc.length;
            }
            if (byArray3 != null) {
                n4 += byArray3.length;
            }
            if (byArray4 != null) {
                n4 += byArray4.length;
            }
            n4 = (n4 & ~(this.blocklen - 1)) + this.blocklen;
            object = new byte[n4];
            int n5 = 0;
            if (this.macssc != null) {
                System.arraycopy(this.macssc, 0, object, n5, this.macssc.length);
                n5 += this.macssc.length;
            }
            if (byArray3 != null) {
                System.arraycopy(byArray3, 0, object, n5, byArray3.length);
                n5 += byArray3.length;
            }
            if (byArray4 != null) {
                System.arraycopy(byArray4, 0, object, n5, byArray4.length);
                n5 += byArray4.length;
            }
            object[n5++] = -128;
            while (n5 < n4) {
                object[n5++] = false;
            }
            try {
                Mac mac = Mac.getInstance(this.macalgorithm, this.provider);
                mac.init(this.kmac);
                byArray = mac.doFinal((byte[])object);
            }
            catch (Exception exception) {
                throw new CardServiceInvalidParameterException(exception.getMessage());
            }
            if (byArray5[1] != this.maclen) {
                throw new CardServiceInvalidParameterException("MAC data object has wrong length");
            }
            for (n2 = 0; n2 < this.maclen; ++n2) {
                if (byArray5[n2 + 2] == byArray[n2]) continue;
                throw new CardServiceInvalidCredentialException("MAC verification failed");
            }
        }
        byArray2 = null;
        if (byArray3 != null) {
            int n6 = byArray3[0] & 0xFE;
            if ((n & 8) > 0) {
                if (n6 != 132 && n6 != 134) {
                    throw new CardServiceInvalidParameterException("Expected enciphered response");
                }
                TLV tLV = new TLV(byArray3);
                byArray = tLV.valueAsByteArray();
                n2 = 0;
                if (n6 == 134) {
                    n2 = 1;
                    if (byArray[0] != 1) {
                        throw new CardServiceInvalidParameterException("Invalid padding indicator in enciphered block");
                    }
                }
                if (this.encssc != null) {
                    this.incrementENCSSC();
                }
                byte[] byArray7 = new byte[byArray.length - n2];
                System.arraycopy(byArray, n2, byArray7, 0, byArray7.length);
                try {
                    int n7;
                    Cipher cipher = Cipher.getInstance(this.cipheralgorithm, this.provider);
                    byte[] byArray8 = this.getIV(cipher);
                    IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray8);
                    cipher.init(2, this.kenc, ivParameterSpec);
                    byte[] byArray9 = cipher.doFinal(byArray7);
                    for (n7 = byArray9.length - 1; n7 > 0 && byArray9[n7] == 0; --n7) {
                    }
                    if (byArray9[n7] != -128) {
                        throw new CardServiceInvalidCredentialException("Invalid padding in enciphered block");
                    }
                    byArray2 = new byte[n7];
                    System.arraycopy(byArray9, 0, byArray2, 0, n7);
                }
                catch (Exception exception) {
                    throw new CardServiceInvalidParameterException(exception.getMessage());
                }
                if (!bl && this.macssc != null) {
                    this.incrementMACSSC();
                }
            } else {
                if (n6 != 128 && n6 != 178) {
                    throw new CardServiceInvalidParameterException("Expected plain response");
                }
                TLV tLV = new TLV(byArray3);
                byArray2 = tLV.toBinaryContent();
            }
        }
        ResponseAPDU responseAPDU2 = new ResponseAPDU((byArray2 == null ? 0 : byArray2.length) + 2);
        if (byArray2 != null) {
            responseAPDU2.append(byArray2);
        }
        if (byArray4 != null) {
            responseAPDU2.append(byArray4[2]);
            responseAPDU2.append(byArray4[3]);
        } else {
            responseAPDU2.append(byArray6[responseAPDU.getLength() - 2]);
            responseAPDU2.append(byArray6[responseAPDU.getLength() - 1]);
        }
        return responseAPDU2;
    }

    public void setEncKey(Key key) {
        this.kenc = key;
        String string = key.getAlgorithm();
        this.cipheralgorithm = string + "/CBC/NoPadding";
    }

    public void setMacKey(Key key) {
        this.kmac = key;
        String string = key.getAlgorithm();
        if (string.equals("DESede")) {
            this.macalgorithm = "ISO9797ALG3Mac";
            this.blocklen = 8;
        } else if (string.equals("AES")) {
            this.macalgorithm = "AESCMAC";
            this.blocklen = 16;
        } else {
            throw new CardServiceInvalidParameterException("Unsupported key type " + string + ". Only DESede or AES allowed.");
        }
        this.iv = new byte[this.blocklen];
    }

    public void setMacAlgorithm(String string) {
        this.macalgorithm = string;
    }

    public void setCipherAlgorithm(String string) {
        this.cipheralgorithm = string;
    }

    public void setIV(byte[] byArray) {
        this.iv = byArray;
    }

    public void setMacLength(int n) {
        this.maclen = n;
    }

    public void setSendSequenceCounter(byte[] byArray) {
        this.macssc = byArray;
    }

    public void setEncryptionSendSequenceCounter(byte[] byArray) {
        this.encssc = byArray;
    }

    public void setMACSendSequenceCounter(byte[] byArray) {
        this.macssc = byArray;
    }

    public byte[] getSendSequenceCounter() {
        return this.macssc;
    }

    public byte[] getEncryptionSendSequenceCounter() {
        return this.encssc;
    }

    public byte[] getMACSendSequenceCounter() {
        return this.macssc;
    }

    public void setSendSequenceCounterPolicy(SSCPolicyEnum sSCPolicyEnum) {
        this.sscpolicy = sSCPolicyEnum;
    }

    public void setCRT(byte[] byArray) {
        this.crt = byArray;
    }

    public static enum SSCPolicyEnum {
        DEFAULT,
        SYNC,
        SYNC_AND_ENCRYPT;

    }
}

