/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.security;

import de.cardcontact.opencard.security.SecureChannelCredential;
import opencard.core.terminal.CardID;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.security.Credential;
import opencard.opt.security.CredentialStore;
import opencard.opt.security.SecurityDomain;

public class IsoCredentialStore
extends CredentialStore {
    public static final int SELECT = 1;
    public static final int READ = 2;
    public static final int UPDATE = 4;
    public static final int APPEND = 8;
    public static final int CREATE = 16;
    public static final int DELETE = 32;
    public static final int ACTIVATE = 64;
    public static final int DEACTIVATE = 128;
    public static final int SIZE_ACCESS_MATRIX = 8;

    @Override
    public boolean supports(CardID cardID) {
        return true;
    }

    public void setSecureChannelCredential(SecurityDomain securityDomain, SecureChannelCredential secureChannelCredential) {
        this.storeCredential(securityDomain, secureChannelCredential);
    }

    public SecureChannelCredential getSecureChannelCredential(SecurityDomain securityDomain) {
        Credential credential = this.fetchCredential(securityDomain);
        if (credential instanceof SecureChannelCredential) {
            SecureChannelCredential secureChannelCredential = (SecureChannelCredential)credential;
            return secureChannelCredential;
        }
        return null;
    }

    public SecureChannelCredential getSecureChannelCredential(SecurityDomain securityDomain, int n) {
        Object object;
        CardFilePath cardFilePath = new CardFilePath((CardFilePath)securityDomain);
        do {
            if ((object = this.fetchCredential(cardFilePath.toString() + "\u00a7" + n)) == null) {
                object = this.fetchCredential(cardFilePath.toString());
            }
            if (object == null || !(object instanceof SecureChannelCredential)) continue;
            SecureChannelCredential secureChannelCredential = (SecureChannelCredential)object;
            return secureChannelCredential;
        } while (cardFilePath.chompTail());
        object = new CardFilePath(":3F00");
        if (!cardFilePath.equals(object)) {
            Credential credential = this.fetchCredential(((CardFilePath)object).toString() + "\u00a7" + n);
            if (credential == null) {
                credential = this.fetchCredential(((CardFilePath)object).toString());
            }
            if (credential != null && credential instanceof SecureChannelCredential) {
                SecureChannelCredential secureChannelCredential = (SecureChannelCredential)credential;
                return secureChannelCredential;
            }
        }
        return null;
    }

    public void setSecureChannelCredential(SecurityDomain securityDomain, int n, SecureChannelCredential secureChannelCredential) {
        for (int i = 0; i < 8; ++i) {
            if ((n & 1 << i) <= 0) continue;
            this.storeCredential(securityDomain.toString() + "\u00a7" + (1 << i), secureChannelCredential);
        }
    }
}

