/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.factory;

import de.cardcontact.opencard.service.acos.ACOSCardService;
import de.cardcontact.opencard.service.isocard.IsoCardService;
import de.cardcontact.opencard.service.isocard.TransparentCardService;
import de.cardcontact.opencard.service.signature.ISSSSignatureService;
import java.util.Enumeration;
import java.util.Vector;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardType;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.Tracer;

public class IsoCardServiceFactory
extends CardServiceFactory {
    private static final byte[] Micardo20 = new byte[]{0, 0, 104, -46, 118, 0, 0, 40, -1, 5, 30};
    private static final byte[] Micardo21 = new byte[]{0, 0, 104, -46, 118, 0, 0, 40, -1, 5, 36};
    private static final byte[] Micardo23 = new byte[]{0, 0, 104, -46, 118, 0, 0, 40, -1, 5, 35};
    private static final byte[] Starcos30 = new byte[]{-128, 103, 4, 18, -80, 2, 1, -126, 1};
    private static final byte[] Starcos30_P5CC036 = new byte[]{-128, 103, 4, 20, -80, 1, 1, -126, 1};
    private static final byte[] JCOP41CL1 = new byte[]{65, 32, 0, 17, 51, -80, 74, 67, 79, 80, 52, 49, 86, 50};
    private static final byte[] JCOP41CL2 = new byte[]{65, 40, 0, 17, 51, -80, 74, 67, 79, 80, 52, 49, 86, 50};
    private static final byte[] JCOP41 = new byte[]{74, 67, 79, 80, 52, 49, 86, 50, 50};
    private static final byte[] TCOSICAOPHICL = new byte[]{65, 32, 0, 65, 34, -31, 2, 0, 100, 4, 0, 3, 0, 49};
    private static final byte[] TCOSICAOIFXCL = new byte[]{66, 0, 1, 51, -31};
    private static final byte[] EC = new byte[]{101, 99};
    private static final byte[] ACOS = new byte[]{59, -65, 24, 0, -127, 49, -2, 69};
    private static Tracer ctracer = new Tracer(IsoCardServiceFactory.class);

    @Override
    protected CardType getCardType(CardID cardID, CardServiceScheduler cardServiceScheduler) throws CardTerminalException {
        Vector<Class<IsoCardService>> vector = new Vector<Class<IsoCardService>>();
        vector.addElement(TransparentCardService.class);
        byte[] byArray = cardID.getHistoricals();
        int n = 0;
        if (byArray != null) {
            if (byArray[0] != 0 && byArray[0] != -128) {
                ctracer.info("[IsoCardServiceFactory.getCardType]", "Historical bytes do not indicate an ISO card");
                if (IsoCardServiceFactory.partialMatch(byArray, JCOP41CL1)) {
                    n = 1089;
                    vector.addElement(IsoCardService.class);
                } else if (IsoCardServiceFactory.partialMatch(byArray, JCOP41CL2)) {
                    n = 1089;
                    vector.addElement(IsoCardService.class);
                } else if (IsoCardServiceFactory.partialMatch(byArray, JCOP41)) {
                    n = 1089;
                    vector.addElement(IsoCardService.class);
                } else if (IsoCardServiceFactory.partialMatch(byArray, TCOSICAOPHICL)) {
                    n = 816;
                    vector.addElement(IsoCardService.class);
                } else if (IsoCardServiceFactory.partialMatch(byArray, TCOSICAOIFXCL)) {
                    n = 816;
                    vector.addElement(IsoCardService.class);
                } else if (IsoCardServiceFactory.partialMatch(byArray, EC)) {
                    n = 1280;
                    vector.addElement(IsoCardService.class);
                } else if (IsoCardServiceFactory.partialMatch(cardID.getATR(), ACOS)) {
                    n = 1792;
                    vector.addElement(ACOSCardService.class);
                } else {
                    vector.addElement(IsoCardService.class);
                }
            } else {
                vector.addElement(IsoCardService.class);
                if (IsoCardServiceFactory.partialMatch(byArray, Micardo20)) {
                    n = 288;
                } else if (IsoCardServiceFactory.partialMatch(byArray, Micardo21)) {
                    n = 289;
                } else if (IsoCardServiceFactory.partialMatch(byArray, Micardo23)) {
                    n = 291;
                    vector.addElement(ISSSSignatureService.class);
                } else if (IsoCardServiceFactory.partialMatch(byArray, Starcos30)) {
                    n = 560;
                } else if (IsoCardServiceFactory.partialMatch(byArray, Starcos30_P5CC036)) {
                    n = 560;
                }
            }
        } else {
            vector.addElement(IsoCardService.class);
        }
        CardType cardType = new CardType(n);
        cardType.setInfo(vector);
        return cardType;
    }

    @Override
    protected Enumeration getClasses(CardType cardType) {
        ctracer.info("[getClasses]", "card type is " + cardType.getType());
        Vector vector = (Vector)cardType.getInfo();
        return vector.elements();
    }

    private static boolean partialMatch(byte[] byArray, byte[] byArray2) {
        int n;
        if (byArray.length < byArray2.length) {
            return false;
        }
        for (n = 0; n < byArray2.length && byArray[n] == byArray2[n]; ++n) {
        }
        return n == byArray2.length;
    }
}

