/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.factory;

import de.cardcontact.opencard.service.gemxcos.GemXCosCardService;
import java.util.Enumeration;
import java.util.Vector;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardType;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.Tracer;

public class GemXCosCardServiceFactory
extends CardServiceFactory {
    private static final byte[] GemXCosHIC = new byte[]{59, 43, 0, 0, 100, 5, 62, 2, 15, 49, -128, 14, -112, 0};
    private static final byte[] GemXCosHPC = new byte[]{59, 43, 0, 0, 100, 5, 62, 2, -16, 49, -128, 14, -112, 0};
    private final Vector service_classes = new Vector();
    private static Tracer ctracer = new Tracer(GemXCosCardServiceFactory.class);

    public GemXCosCardServiceFactory() {
        this.service_classes.addElement(GemXCosCardService.class);
    }

    @Override
    protected CardType getCardType(CardID cardID, CardServiceScheduler cardServiceScheduler) throws CardTerminalException {
        byte[] byArray = cardID.getATR();
        if (GemXCosCardServiceFactory.match(byArray, GemXCosHIC) || GemXCosCardServiceFactory.match(byArray, GemXCosHPC)) {
            return new CardType(1536);
        }
        return CardType.UNSUPPORTED;
    }

    @Override
    protected Enumeration getClasses(CardType cardType) {
        ctracer.info("[getClasses]", "card type is " + cardType.getType());
        return this.service_classes.elements();
    }

    private static boolean match(byte[] byArray, byte[] byArray2) {
        int n;
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (n = 0; n < byArray2.length && byArray[n] == byArray2[n]; ++n) {
        }
        return n == byArray2.length;
    }
}

