/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.opencard.terminal.pcsc10;

import com.ibm.opencard.terminal.pcsc10.OCFPCSC1;
import com.ibm.opencard.terminal.pcsc10.Pcsc10CardTerminal;
import com.ibm.opencard.terminal.pcsc10.PcscException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalFactory;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.util.Tracer;

public class Pcsc10CardTerminalFactory
implements CardTerminalFactory {
    private Tracer itracer = new Tracer((Object)this, Pcsc10CardTerminalFactory.class);
    private OCFPCSC1 pcsc = null;

    public Pcsc10CardTerminalFactory() throws CardTerminalException {
        this.open();
    }

    @Override
    public void createCardTerminals(CardTerminalRegistry cardTerminalRegistry, String[] stringArray) throws CardTerminalException {
        String[] stringArray2;
        String string = "PCSC10";
        if (stringArray.length >= 2) {
            string = stringArray[1];
        }
        if ((stringArray2 = this.ListReaders()) != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                cardTerminalRegistry.add(new Pcsc10CardTerminal(stringArray2[i], string, ""));
            }
        }
    }

    @Override
    public void open() throws CardTerminalException {
        if (this.pcsc == null) {
            try {
                this.itracer.debug("Pcsc10CardTerminalFactory", "connect to PCSC 1.0 resource manager");
                OCFPCSC1.loadLib();
                this.pcsc = new OCFPCSC1();
                this.itracer.debug("Pcsc10CardTerminalFactory", "Driver initialized");
            }
            catch (PcscException pcscException) {
                throw new CardTerminalException("Pcsc10CardTerminalFactory: " + pcscException.getMessage());
            }
        }
    }

    @Override
    public void close() throws CardTerminalException {
        this.pcsc = null;
    }

    protected String[] ListReaders() throws CardTerminalException {
        this.itracer.debug("Pcsc10CardTerminalFactory", "get reader list from PC/SC");
        String[] stringArray = null;
        try {
            stringArray = this.pcsc.SCardListReaders(null);
        }
        catch (PcscException pcscException) {
            throw new CardTerminalException("Pcsc10CardTerminalFactory: " + pcscException.getMessage());
        }
        return stringArray;
    }
}

