/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.opencard.terminal.pcsc10;

import com.ibm.opencard.terminal.pcsc.PcscError;
import com.ibm.opencard.terminal.pcsc10.OCFPCSC1;
import com.ibm.opencard.terminal.pcsc10.PcscException;
import com.ibm.opencard.terminal.pcsc10.PcscReaderState;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.Pollable;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.Tracer;
import opencard.opt.terminal.TerminalCommand;

public class Pcsc10CardTerminal
extends CardTerminal
implements TerminalCommand,
Pollable {
    private Tracer itracer = new Tracer((Object)this, Pcsc10CardTerminal.class);
    private OCFPCSC1 pcsc;
    private int context = 0;
    private boolean closed;
    private boolean cardInserted;
    private int cardHandle = 0;
    private static final int SCARD_STATE_MUTE = 512;
    private static final int SCARD_STATE_PRESENT = 32;
    private CardID cid = null;
    private byte[] cachedATR;
    private boolean polling;

    protected Pcsc10CardTerminal(String string, String string2, String string3) throws CardTerminalException {
        super(string, string2, string3);
        this.polling = !string2.endsWith("-NOPOLL");
        try {
            this.itracer.debug("Pcsc10CardTerminal", "connect to PCSC 1.0 resource manager");
            OCFPCSC1.loadLib();
            this.pcsc = new OCFPCSC1();
            this.context = this.pcsc.SCardEstablishContext(0);
            this.itracer.debug("Pcsc10CardTerminal", "Driver initialized");
        }
        catch (PcscException pcscException) {
            throw this.translatePcscException(pcscException);
        }
        this.addSlots(1);
    }

    @Override
    public void open() throws CardTerminalException {
        if (this.polling) {
            CardTerminalRegistry.getRegistry().addPollable(this);
        }
        this.closed = false;
    }

    @Override
    public void close() throws CardTerminalException {
        if (!this.closed) {
            this.itracer.debug("close", "disable polling");
            if (this.polling) {
                CardTerminalRegistry.getRegistry().removePollable(this);
            }
            this.closed = true;
            if (this.cardInserted && this.cid != null) {
                this.itracer.debug("close", "card inserted - try to power down card");
                this.cid = null;
                this.cardDisconnect(3);
            } else {
                this.itracer.debug("close", "no card inserted");
            }
            try {
                this.itracer.debug("close", "release context");
                this.pcsc.SCardReleaseContext(this.context);
            }
            catch (PcscException pcscException) {
                throw this.translatePcscException(pcscException);
            }
        } else {
            this.itracer.debug("close", "Terminal already closed!");
            throw new CardTerminalException("Pcsc10CardTerminal: already closed");
        }
    }

    @Override
    protected CardID internalReset(int n, int n2) throws CardTerminalException {
        if (this.isCardConnected()) {
            this.itracer.debug("internalReset", "cardHandle exists - try reconnect");
            this.cid = null;
            Integer n3 = new Integer(0);
            try {
                this.pcsc.SCardReconnect(this.cardHandle, 1, 3, 2, n3);
                this.cid = new CardID(this, 0, this.cachedATR);
            }
            catch (PcscException pcscException) {
                throw this.translatePcscException(pcscException);
            }
            return this.getCardID(n, n2);
        }
        this.itracer.debug("internalReset", "card reset failed - no card inserted");
        return null;
    }

    @Override
    protected CardID internalReset(int n, boolean bl) throws CardTerminalException {
        if (this.isCardConnected()) {
            this.itracer.debug("internalReset", "cardHandle exists - try reconnect");
            this.cid = null;
            Integer n2 = new Integer(0);
            int n3 = bl ? 1 : 2;
            try {
                this.pcsc.SCardReconnect(this.cardHandle, 1, 3, n3, n2);
                if (!this.isCardPresent(n)) {
                    this.itracer.debug("internalReset", "card reset failed - no card inserted");
                    return null;
                }
                this.cid = new CardID(this, 0, this.cachedATR);
            }
            catch (PcscException pcscException) {
                throw this.translatePcscException(pcscException);
            }
            return this.getCardID(n, -1);
        }
        this.itracer.debug("internalReset", "card reset failed - no card inserted");
        return null;
    }

    @Override
    public synchronized boolean isCardPresent(int n) throws CardTerminalException {
        if (!this.closed) {
            if (n != 0) {
                throw new CardTerminalException("Invalid Slot number: " + n);
            }
            PcscReaderState[] pcscReaderStateArray = new PcscReaderState[]{new PcscReaderState()};
            pcscReaderStateArray[0].CurrentState = 0;
            pcscReaderStateArray[0].Reader = this.getName();
            try {
                this.pcsc.SCardGetStatusChange(this.context, 1, pcscReaderStateArray);
                if ((pcscReaderStateArray[0].EventState & 0x200) != 0 && (pcscReaderStateArray[0].EventState & 0x20) != 0) {
                    throw new CardTerminalException("Card present but unresponsive in slot " + n);
                }
            }
            catch (PcscException pcscException) {
                throw this.translatePcscException(pcscException);
            }
            this.cachedATR = pcscReaderStateArray[0].ATR;
            if (this.cachedATR != null) {
                return this.cachedATR.length > 0;
            }
            return false;
        }
        return false;
    }

    @Override
    public CardID getCardID(int n, int n2) throws CardTerminalException {
        return this.getCardID(n);
    }

    @Override
    public CardID getCardID(int n) throws CardTerminalException {
        if (n != 0) {
            throw new CardTerminalException("Invalid slot number: " + n);
        }
        if (this.cid == null && this.cachedATR != null) {
            this.cid = new CardID(this, 0, this.cachedATR);
        }
        return this.cid;
    }

    @Override
    protected synchronized void internalOpenSlotChannel(int n) throws CardTerminalException {
        this.cardConnect();
    }

    @Override
    protected void internalCloseSlotChannel(SlotChannel slotChannel) throws CardTerminalException {
        super.internalCloseSlotChannel(slotChannel);
        this.cardDisconnect(0);
    }

    private boolean isCardConnected() {
        return this.cardHandle != 0;
    }

    private int getCardHandle() {
        return this.cardHandle;
    }

    private void cardConnect() throws CardTerminalException {
        Integer n = new Integer(0);
        try {
            this.itracer.debug("cardConnect", "connect to smartcard");
            this.cardHandle = this.pcsc.SCardConnect(this.context, this.getName(), 1, 2, n);
            this.itracer.debug("cardConnect", "got card handle: " + this.cardHandle);
        }
        catch (PcscException pcscException) {
            if (pcscException.returnCode() == -2146435057 || pcscException.returnCode() == 50) {
                try {
                    this.cardHandle = this.pcsc.SCardConnect(this.context, this.getName(), 1, 1, n);
                    this.itracer.debug("cardConnect", "got card handle: " + this.cardHandle);
                }
                catch (PcscException pcscException2) {
                    throw this.translatePcscException(pcscException2);
                }
            }
            throw this.translatePcscException(pcscException);
        }
    }

    private void cardDisconnect(int n) throws CardTerminalException {
        if (this.cardHandle != 0) {
            try {
                this.itracer.debug("cardDisconnect", "disconnect smartcard - cardHandle=" + this.cardHandle);
                this.pcsc.SCardDisconnect(this.cardHandle, n);
            }
            catch (PcscException pcscException) {
                throw this.translatePcscException(pcscException);
            }
            finally {
                this.itracer.debug("cardDisconnect", "invalidate card handle");
                this.cardHandle = 0;
            }
        } else {
            this.itracer.debug("cardDisconnect", "cardHandle already 0 - disconnect impossible");
        }
    }

    @Override
    public byte[] sendTerminalCommand(byte[] byArray) throws CardTerminalException {
        if (this.cardHandle == 0) {
            throw new CardTerminalException("no card present", this);
        }
        try {
            byte[] byArray2 = this.pcsc.SCardControl(this.cardHandle, 0, byArray);
            return byArray2;
        }
        catch (PcscException pcscException) {
            throw this.translatePcscException(pcscException);
        }
    }

    @Override
    protected ResponseAPDU internalSendAPDU(int n, CommandAPDU commandAPDU, int n2) throws CardTerminalException {
        if (n != 0) {
            throw new CardTerminalException("Invalid slot: " + n);
        }
        this.itracer.debug("internalSendAPDU", "sending " + commandAPDU);
        byte[] byArray = null;
        try {
            byArray = this.pcsc.SCardTransmit(this.cardHandle, commandAPDU.getBytes());
        }
        catch (PcscException pcscException) {
            if (pcscException.returnCode() == 121) {
                this.internalReset(0, 5000);
                throw new CardTerminalException("PC/SC Error: semaphore timeout - perhaps forbidden or wrong card command.");
            }
            throw this.translatePcscException(pcscException);
        }
        ResponseAPDU responseAPDU = new ResponseAPDU(byArray);
        this.itracer.debug("internalSendAPDU", "receiving " + responseAPDU);
        return responseAPDU;
    }

    @Override
    protected void cardRemoved(int n) {
        super.cardRemoved(n);
        try {
            this.cardDisconnect(0);
        }
        catch (CardTerminalException cardTerminalException) {
            // empty catch block
        }
    }

    @Override
    public void poll() throws CardTerminalException {
        if (!this.closed) {
            try {
                boolean bl = this.isCardPresent(0);
                if (this.cardInserted != bl) {
                    this.itracer.debug("poll", "status change");
                    boolean bl2 = this.cardInserted = !this.cardInserted;
                    if (this.cardInserted) {
                        this.cid = new CardID(this, 0, this.cachedATR);
                        this.cardInserted(0);
                    } else {
                        this.cardRemoved(0);
                    }
                } else {
                    this.itracer.debug("poll", "no status change");
                }
            }
            catch (CardTerminalException cardTerminalException) {
                this.itracer.debug("poll", cardTerminalException);
                this.cardInserted(0);
            }
        }
    }

    protected CardTerminalException translatePcscException(PcscException pcscException) {
        String string = PcscError.getMessage(pcscException.returnCode());
        string = string == null ? pcscException.getMessage() : pcscException.getMessage() + string;
        return new CardTerminalException("Pcsc10CardTerminal: " + string, this);
    }
}

