/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import opencard.opt.iso.fs.CardFileAppID;
import opencard.opt.iso.fs.CardFileFileID;
import opencard.opt.iso.fs.CardFilePartialAppID;
import opencard.opt.iso.fs.CardFileShortFileID;
import opencard.opt.iso.fs.CardFileSymbolicName;
import opencard.opt.iso.fs.CardIOException;

public abstract class CardFilePathComponent {
    protected String comp;

    protected CardFilePathComponent() {
    }

    protected CardFilePathComponent(String string) {
        this.comp = string;
    }

    private static boolean hex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    protected static CardFilePathComponent createComponent(String string, int n, String string2, int n2) throws CardIOException {
        if (string.startsWith("/")) {
            return new CardFileSymbolicName(string);
        }
        if (string.startsWith(":")) {
            int n3 = 1;
            while (n3 < string.length()) {
                if (!CardFilePathComponent.hex(string.charAt(n3))) {
                    throw new CardIOException("file ID can only contain hexadecimal characters (" + string + ")");
                }
                ++n3;
            }
            if (string.length() == 1) {
                throw new CardIOException("illegal empty file ID ':' \"" + string + "\"");
            }
            if (string.length() > 3) {
                return new CardFileFileID(string);
            }
            if (string.length() == 3 && n == n2 - 1) {
                return new CardFileShortFileID(string);
            }
            if (string.length() == 3 && n != n2 - 1) {
                throw new CardIOException("short file ID \"" + string + "\" of path " + string2 + " must be the last component");
            }
            throw new CardIOException("malformed file ID component " + string);
        }
        if (string.startsWith("#") && !string.startsWith("##")) {
            int n4 = 1;
            while (n4 < string.length()) {
                if (!CardFilePathComponent.hex(string.charAt(n4))) {
                    throw new CardIOException("file ID can only contain hexadecimal characters (" + string + ")");
                }
                ++n4;
            }
            if (string.endsWith("*") && !string.endsWith("**")) {
                return new CardFilePartialAppID(string);
            }
            return new CardFileAppID(string);
        }
        if (string.endsWith("*") && !string.endsWith("**")) {
            return new CardFilePartialAppID(string);
        }
        return new CardFileAppID(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CardFilePathComponent)) {
            return false;
        }
        return this.comp.equals(((CardFilePathComponent)object).comp);
    }

    public String toString() {
        return this.comp;
    }
}

