/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.database;

import opencard.core.terminal.CardTerminalException;
import opencard.opt.database.SCQLException;
import opencard.opt.database.SecurityAttribute;
import opencard.opt.service.CardServiceInterface;

public interface DatabaseCardService
extends CardServiceInterface {
    public void createTable(String var1, String var2, byte var3, SecurityAttribute var4) throws CardTerminalException, SCQLException;

    public void createView(String var1, String var2, String var3, String var4, SecurityAttribute var5) throws CardTerminalException, SCQLException;

    public void createDictionary(String var1) throws CardTerminalException, SCQLException;

    public void dropTable(String var1) throws CardTerminalException, SCQLException;

    public void dropView(String var1) throws CardTerminalException, SCQLException;

    public void grant(String var1, String var2, String var3) throws CardTerminalException, SCQLException;

    public void revoke(String var1, String var2, String var3) throws CardTerminalException, SCQLException;

    public void declareCursor(String var1, String var2, String var3) throws CardTerminalException, SCQLException;

    public void open() throws CardTerminalException, SCQLException;

    public void next() throws CardTerminalException, SCQLException;

    public String[] fetch(byte var1) throws CardTerminalException, SCQLException;

    public String[] fetchNext(byte var1) throws CardTerminalException, SCQLException;

    public String[] fetch() throws CardTerminalException, SCQLException;

    public String[] fetchNext() throws CardTerminalException, SCQLException;

    public void insert(String var1, String var2) throws CardTerminalException, SCQLException;

    public void update(String var1) throws CardTerminalException, SCQLException;

    public void delete() throws CardTerminalException, SCQLException;

    public void begin() throws CardTerminalException, SCQLException;

    public void commit() throws CardTerminalException, SCQLException;

    public void rollback() throws CardTerminalException, SCQLException;

    public void presentUser(String var1) throws CardTerminalException, SCQLException;

    public void presentUser(String var1, SecurityAttribute var2) throws CardTerminalException, SCQLException;

    public void createUser(String var1, String var2, SecurityAttribute var3) throws CardTerminalException, SCQLException;

    public void deleteUser(String var1) throws CardTerminalException, SCQLException;

    public static interface Constants {
        public static final byte SCQL_OPERATION = 16;
        public static final byte TRANSACTION_OPERATION = 18;
        public static final byte USER_OPERATION = 20;
        public static final byte CREATE_TABLE = -128;
        public static final byte CREATE_VIEW = -127;
        public static final byte CREATE_DICTIONARY = -126;
        public static final byte DROP_TABLE = -125;
        public static final byte DROP_VIEW = -124;
        public static final byte GRANT = -123;
        public static final byte REVOKE = -122;
        public static final byte DECLARE_CURSOR = -121;
        public static final byte OPEN = -120;
        public static final byte NEXT = -119;
        public static final byte FETCH = -118;
        public static final byte FETCH_NEXT = -117;
        public static final byte INSERT = -116;
        public static final byte UPDATE = -115;
        public static final byte DELETE = -114;
        public static final byte BEGIN = -128;
        public static final byte COMMIT = -127;
        public static final byte ROLLBACK = -126;
        public static final byte PRESENT_USER = -128;
        public static final byte CREATE_USER = -127;
        public static final byte DELETE_USER = -126;
        public static final byte EQUAL_TO = 61;
        public static final byte LESS_THAN = 60;
        public static final byte GREATER_THAN = 62;
        public static final byte LESS_THAN_OR_EQUAL_TO = 76;
        public static final byte GREATER_THAN_OR_EQUAL_TO = 71;
        public static final byte NOT_EQUAL_TO = 35;
        public static final byte PRIV_INSERT = 65;
        public static final byte PRIV_SELECT = 66;
        public static final byte PRIV_UPDATE = 68;
        public static final byte PRIV_DELETE = 72;
        public static final byte PRIV_ALL = 79;
        public static final byte SW1_OK = -112;
        public static final byte SW1_OK_WITH_RETURN = 97;
        public static final byte SW2_OK = 0;
        public static final byte SW1_WARNING = 98;
        public static final byte SW2_WARNING = -126;
        public static final byte SW1_EXEC_ERROR = 101;
        public static final byte SW2_EXEC_ERROR = 0;
        public static final byte SW2_MEM_FAILURE = 98;
        public static final byte SW1_CHECK_ERROR = 103;
        public static final byte SW2_CHECK_ERROR = 0;
        public static final byte SW1_COMMAND_NOT_ALLOWED = 105;
        public static final byte SW2_COMMAND_NOT_ALLOWED = 0;
        public static final byte SW2_SECURITY = -126;
        public static final byte SW2_REQUIRED_OPERATION = -123;
        public static final byte SW1_WRONG_PARAM = 106;
        public static final byte SW2_WRONG_PARAM = -128;
        public static final byte SW2_INCORRECT_PARAM = -127;
        public static final byte SW2_OPERATION_NOT_SUPPORTED = -124;
        public static final byte SW2_OBJECT_NOT_FOUND = -120;
        public static final byte SW2_OBJECT_ALREADY_EXISTS = -119;
        public static final byte SW1_WRONG_LENGTH = 108;
        public static final byte SW1_INSTRUCTION_CODE_NOT_SUPPORTED = 109;
        public static final byte SW2_INSTRUCTION_CODE_NOT_SUPPORTED = 0;
        public static final byte TAG_CH_CERTIFICATE_1 = 127;
        public static final byte TAG_CH_CERTIFICATE_2 = 33;
        public static final byte TAG_CH_NAME_1 = 95;
        public static final byte TAG_CH_NAME_2 = 32;
    }
}

