/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.database;

import opencard.core.terminal.ResponseAPDU;
import opencard.opt.database.DatabaseCardService;
import opencard.opt.database.WrongIdentifierSyntaxException;

public class DataObject
implements DatabaseCardService.Constants {
    public static final char INHIBITOR = '/';
    public static final char SEPARATOR = ',';

    protected static void isIdentifier(String string) throws WrongIdentifierSyntaxException {
        boolean bl = true;
        if (string.charAt(0) == '_') {
            bl = false;
        } else {
            int n = 0;
            while (n < string.length() && bl) {
                if (!(Character.isUpperCase(string.charAt(n)) && Character.isLetter(string.charAt(n)) || Character.isDigit(string.charAt(n)) || string.charAt(n) == '_')) {
                    bl = false;
                }
                ++n;
            }
        }
        if (!bl) {
            throw new WrongIdentifierSyntaxException(string);
        }
    }

    protected static void isDictionaryIdentifier(String string) throws WrongIdentifierSyntaxException {
        DataObject.isIdentifier(string);
        if (string.length() > 6) {
            throw new WrongIdentifierSyntaxException(string);
        }
    }

    protected static boolean isOperator(char c) {
        return c == '<' || c == '>' || c == '=' || c == '!';
    }

    protected static byte parsePrivilege(String string) {
        byte by = 0;
        if ((string = string.toUpperCase()).indexOf("A") > -1) {
            return 79;
        }
        if (string.indexOf("I") > -1) {
            by = (byte)(by | 0x41);
        }
        if (string.indexOf("S") > -1) {
            by = (byte)(by | 0x42);
        }
        if (string.indexOf("U") > -1) {
            by = (byte)(by | 0x44);
        }
        if (string.indexOf("D") > -1) {
            by = (byte)(by | 0x48);
        }
        return by;
    }

    protected static byte operator(String string) {
        string = String.valueOf(string) + " ";
        char c = string.charAt(0);
        char c2 = string.charAt(1);
        switch (c) {
            case '<': {
                switch (c2) {
                    case '=': {
                        return 76;
                    }
                }
                return 60;
            }
            case '>': {
                switch (c2) {
                    case '=': {
                        return 71;
                    }
                }
                return 62;
            }
            case '=': {
                return 61;
            }
            case '!': {
                if (c2 != '=') break;
                return 35;
            }
        }
        return 0;
    }

    protected static String[] dictionaryResponseToString(char c, ResponseAPDU responseAPDU) {
        byte[] byArray = responseAPDU.data();
        if (c == 'U') {
            char c2 = DataObject.hexToChar(byArray[1]);
            String[] stringArray = new String[4];
            int n = byArray[2] + 3;
            switch (c2) {
                case 'A': {
                    stringArray[0] = "DB_O";
                }
                case 'E': {
                    stringArray[0] = "DBBO";
                }
                case 'U': {
                    stringArray[0] = "DBBU";
                }
            }
            stringArray[1] = "";
            int n2 = 3;
            while (n2 < n) {
                stringArray[1] = String.valueOf(stringArray[1]) + DataObject.hexToChar(byArray[n2]);
                ++n2;
            }
            int n3 = byArray[n++] + n;
            stringArray[2] = "";
            n2 = n;
            while (n2 < n3) {
                stringArray[2] = String.valueOf(stringArray[2]) + DataObject.hexToChar(byArray[n2]);
                ++n2;
            }
            stringArray[3] = "";
            n = byArray[++n3] + n3;
            n2 = ++n3;
            while (n2 < n) {
                stringArray[3] = String.valueOf(stringArray[3]) + DataObject.hexToChar(byArray[n2]);
                ++n2;
            }
            return stringArray;
        }
        if (c == 'P') {
            String[] stringArray = new String[4];
            int n = byArray[2] + 3;
            stringArray[0] = String.valueOf(DataObject.hexToChar(byArray[1]));
            stringArray[1] = "";
            int n4 = 3;
            while (n4 < n) {
                stringArray[1] = String.valueOf(stringArray[1]) + DataObject.hexToChar(byArray[n4]);
                ++n4;
            }
            int n5 = byArray[n++] + n;
            stringArray[2] = "";
            n4 = n;
            while (n4 < n5) {
                stringArray[2] = String.valueOf(stringArray[2]) + DataObject.hexToChar(byArray[n4]);
                ++n4;
            }
            stringArray[3] = "";
            n = byArray[n5++] + n5;
            n4 = n5;
            while (n4 < n) {
                stringArray[3] = String.valueOf(stringArray[3]) + DataObject.hexToChar(byArray[n4]);
                ++n4;
            }
            return stringArray;
        }
        if (c == 'O') {
            if (responseAPDU.data()[0] == 3) {
                String[] stringArray = new String[19];
                int n = byArray[2] + 3;
                stringArray[0] = "VIEW";
                stringArray[1] = "";
                int n6 = 3;
                while (n6 < n) {
                    stringArray[1] = String.valueOf(stringArray[1]) + DataObject.hexToChar(byArray[n6]);
                    ++n6;
                }
                stringArray[2] = "";
                n6 = ++n;
                while (n6 < byArray.length) {
                    stringArray[2] = String.valueOf(stringArray[2]) + DataObject.hexToChar(byArray[n6]);
                    ++n6;
                }
                n6 = 3;
                while (n6 < 19) {
                    stringArray[n6] = "";
                    ++n6;
                }
                return stringArray;
            }
            if (responseAPDU.data()[0] == 5) {
                String[] stringArray = new String[19];
                char c3 = DataObject.hexToChar(byArray[1]);
                switch (c3) {
                    case 'V': {
                        stringArray[0] = "VIEW";
                    }
                    case 'T': {
                        stringArray[0] = "TABLE";
                    }
                }
                int n = byArray[2] + 3;
                stringArray[1] = "";
                int n7 = 3;
                while (n7 < n) {
                    stringArray[1] = String.valueOf(stringArray[1]) + DataObject.hexToChar(byArray[n7]);
                    ++n7;
                }
                stringArray[2] = "";
                int n8 = n + byArray[n++] + 1;
                n7 = n;
                while (n7 < n8) {
                    stringArray[2] = String.valueOf(stringArray[2]) + DataObject.hexToChar(byArray[n7]);
                    ++n7;
                }
                stringArray[3] = "";
                n = n8 + byArray[n8] + 1;
                n7 = n8;
                while (n7 < n) {
                    stringArray[3] = String.valueOf(stringArray[3]) + DataObject.hexToChar(byArray[n7]);
                    ++n7;
                }
                byte by = byArray[n++];
                n7 = 0;
                while (n7 < by) {
                    stringArray[n7 + 3] = "";
                    n8 = byArray[n++] + n;
                    int n9 = n;
                    while (n9 < n8) {
                        int n10 = n7 + 3;
                        stringArray[n10] = String.valueOf(stringArray[n10]) + DataObject.hexToChar(byArray[n9]);
                        ++n9;
                    }
                    n = n8;
                    ++n7;
                }
                n7 = n8 + 3;
                while (n7 < 19) {
                    stringArray[n7] = "";
                    ++n7;
                }
                return stringArray;
            }
        }
        return null;
    }

    protected static String[] responseToString(ResponseAPDU responseAPDU) {
        byte[] byArray = responseAPDU.data();
        String[] stringArray = new String[byArray[0]];
        int n = 0;
        byte by = (byte)(byArray[1] + 2);
        int n2 = 0;
        while (n2 < byArray[0]) {
            stringArray[n2] = "";
            n2 = (byte)(n2 + 1);
        }
        n2 = 2;
        while (n2 < byArray.length) {
            if (n2 != by) {
                int n3 = n;
                stringArray[n3] = String.valueOf(stringArray[n3]) + DataObject.hexToChar(byArray[n2]);
            } else {
                n = (byte)(n + 1);
                by = (byte)(by + (byte)(byArray[n2] + 1));
            }
            n2 = (byte)(n2 + 1);
        }
        return stringArray;
    }

    protected static String[] parseString(String string) {
        int n = 0;
        int n2 = 0;
        String[] stringArray = new String[string.length()];
        String string2 = new String("");
        if (string.equals("")) {
            return new String[0];
        }
        n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '/') {
                if (n < string.length() - 1) {
                    string2 = String.valueOf(string2) + string.charAt(++n);
                }
            } else if (string.charAt(n) == ',') {
                stringArray[n2++] = string2;
                string2 = "";
            } else {
                string2 = String.valueOf(string2) + string.charAt(n);
            }
            ++n;
        }
        stringArray[n2] = string2;
        String[] stringArray2 = new String[++n2];
        n = 0;
        while (n < n2) {
            stringArray2[n] = stringArray[n];
            ++n;
        }
        return stringArray2;
    }

    protected static byte charToHex(char c) {
        return (byte)((byte)(c - 32) + 32);
    }

    protected static char hexToChar(byte by) {
        return (char)((char)(by - 32) + 32);
    }

    public static byte[] bodyAPDU(String string) {
        byte[] byArray = new byte[string.length() + 1];
        byArray[0] = (byte)string.length();
        int n = 0;
        while (n < string.length()) {
            byArray[n + 1] = DataObject.charToHex(string.charAt(n));
            ++n;
        }
        return byArray;
    }

    public static byte[] bodyAPDU(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = (byte)byArray.length;
        int n = 0;
        while (n < byArray.length) {
            byArray2[n + 1] = byArray[n];
            ++n;
        }
        return byArray2;
    }

    public static byte[] headerAPDU(byte by, byte by2, byte by3, byte by4) {
        byte[] byArray = new byte[5];
        byArray[0] = by;
        byArray[1] = by2;
        byArray[2] = by3;
        byArray[3] = by4;
        byte[] byArray2 = byArray;
        return byArray2;
    }

    public static byte[] headerAPDU(byte by, byte by2, byte by3, byte by4, byte by5) {
        if (by5 > 0) {
            byte[] byArray = new byte[]{by, by2, by3, by4, by5};
            return byArray;
        }
        byte[] byArray = new byte[]{by, by2, by3, by4};
        return byArray;
    }
}

