/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.applet;

import java.util.Hashtable;
import opencard.core.service.CardChannel;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.Tracer;
import opencard.opt.applet.AppletID;
import opencard.opt.applet.AppletInfo;
import opencard.opt.applet.AppletSelector;
import opencard.opt.applet.AppletState;
import opencard.opt.applet.CardState;
import opencard.opt.applet.ISOAppletSelector;

public class BasicAppletCardService
extends CardService {
    private AppletSelector selector_ = new ISOAppletSelector();
    private static Tracer ctracer = new Tracer(class$opencard$opt$applet$BasicAppletCardService != null ? class$opencard$opt$applet$BasicAppletCardService : (class$opencard$opt$applet$BasicAppletCardService = BasicAppletCardService.class$("opencard.opt.applet.BasicAppletCardService")));
    private static final AppletID CARD_STATE_AID = new AppletID("SAID".getBytes());
    static /* synthetic */ Class class$opencard$opt$applet$BasicAppletCardService;

    protected AppletSelector getAppletSelector() {
        return this.selector_;
    }

    protected CardState getCardState(CardChannel cardChannel) {
        return (CardState)((Hashtable)cardChannel.getState()).get(CARD_STATE_AID);
    }

    protected void initialize(CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws CardServiceException {
        block3: {
            super.initialize(cardServiceScheduler, smartCard, bl);
            ctracer.debug("<init>", "(" + cardServiceScheduler + "," + smartCard + "," + bl + ")");
            try {
                this.allocateCardChannel();
                System.out.println("BasicAppletCardService - allocated CardChannel()");
                CardChannel cardChannel = this.getCardChannel();
                Hashtable<AppletID, CardState> hashtable = (Hashtable<AppletID, CardState>)cardChannel.getState();
                if (hashtable == null) {
                    hashtable = new Hashtable<AppletID, CardState>();
                    cardChannel.setState(hashtable);
                }
                if (hashtable.get(CARD_STATE_AID) != null) break block3;
                hashtable.put(CARD_STATE_AID, new CardState());
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.releaseCardChannel();
                throw throwable;
            }
        }
        Object var5_6 = null;
        this.releaseCardChannel();
    }

    private void selectApplet(CardChannel cardChannel, AppletID appletID) throws CardServiceException, CardTerminalException {
        CardState cardState = this.getCardState(cardChannel);
        if (cardState.getSelectedAppletID() == null || !cardState.getSelectedAppletID().equals(appletID)) {
            ctracer.debug("selectApplet", "selecting " + appletID);
            AppletInfo appletInfo = this.selector_.selectApplet(cardChannel, appletID);
            ResponseAPDU cfr_ignored_0 = (ResponseAPDU)appletInfo.getData();
            AppletID appletID2 = cardState.setSelectedAppletID(appletID);
            if (appletID2 != null) {
                Hashtable hashtable = (Hashtable)this.getCardChannel().getState();
                ctracer.debug("selectApplet", "previouslySelectedAID = " + appletID2);
                ctracer.debug("selectApplet", "channelState = " + hashtable);
                AppletState appletState = (AppletState)hashtable.get(appletID2);
                appletState.appletDeselected();
            }
        }
    }

    protected ResponseAPDU sendCommandAPDU(CardChannel cardChannel, AppletID appletID, CommandAPDU commandAPDU) throws CardTerminalException, CardServiceException {
        ctracer.debug("sendCommandAPDU(channel,...)", "sending " + commandAPDU + " to <" + appletID + ">");
        this.selectApplet(cardChannel, appletID);
        return cardChannel.sendCommandAPDU(commandAPDU);
    }

    public ResponseAPDU sendCommandAPDU(AppletID appletID, CommandAPDU commandAPDU) throws CardTerminalException, CardServiceException {
        ResponseAPDU responseAPDU;
        ctracer.debug("sendCommandAPDU(...)", "sending " + commandAPDU + " to " + appletID);
        try {
            this.allocateCardChannel();
            responseAPDU = this.sendCommandAPDU(this.getCardChannel(), appletID, commandAPDU);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseCardChannel();
            throw throwable;
        }
        this.releaseCardChannel();
        return responseAPDU;
    }

    protected ResponseAPDU sendVerifiedAPDU(CardChannel cardChannel, AppletID appletID, CommandAPDU commandAPDU, CHVControl cHVControl, int n) throws CardServiceException, CardTerminalException {
        this.selectApplet(cardChannel, appletID);
        return cardChannel.sendVerifiedAPDU(commandAPDU, cHVControl, this.getCHVDialog(), -1);
    }

    protected void setAppletSelector(AppletSelector appletSelector) {
        this.selector_ = appletSelector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

