/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.terminal;

import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.Slot;
import opencard.core.util.HexString;

public class CardID {
    protected byte[] atr;
    protected byte[] historicals;
    protected int slotNr;
    protected CardTerminal terminal;
    protected String cachedResult;

    public CardID(byte[] byArray) throws CardTerminalException {
        this.atr = (byte[])byArray.clone();
        if (this.atr.length < 2) {
            throw new CardTerminalException("Illegal ATR response (length " + this.atr.length + " < 2): " + HexString.hexify(byArray));
        }
        if ((this.atr[1] & 0xF) > 0) {
            this.historicals = new byte[this.atr[1] & 0xF];
            int n = 1;
            boolean bl = true;
            while (bl) {
                bl = (this.atr[n] & 0x80) != 0;
                n += ((this.atr[n] & 0x80) >>> 7) + ((this.atr[n] & 0x40) >>> 6) + ((this.atr[n] & 0x20) >>> 5) + ((this.atr[n] & 0x10) >>> 4);
            }
            System.arraycopy(this.atr, ++n, this.historicals, 0, this.historicals.length);
        }
    }

    public CardID(Slot slot, byte[] byArray) throws CardTerminalException {
        this(byArray);
        this.slotNr = slot.getSlotID();
        this.terminal = slot.getCardTerminal();
    }

    public CardID(CardTerminal cardTerminal, int n, byte[] byArray) throws CardTerminalException {
        this(byArray);
        this.slotNr = n;
        this.terminal = cardTerminal;
    }

    public byte[] getATR() {
        if (this.atr != null) {
            return (byte[])this.atr.clone();
        }
        return null;
    }

    public byte[] getHistoricals() {
        if (this.historicals != null) {
            return (byte[])this.historicals.clone();
        }
        return null;
    }

    public Slot getSlot() {
        return new Slot(this.terminal, this.slotNr);
    }

    public int getSlotID() {
        return this.slotNr;
    }

    public CardTerminal getCardTerminal() {
        return this.terminal;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CardID)) {
            return false;
        }
        CardID cardID = (CardID)object;
        if (cardID.atr.length != this.atr.length) {
            return false;
        }
        int n = 0;
        while (n < this.atr.length) {
            if (this.atr[n] != cardID.atr[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String toString() {
        if (this.cachedResult == null) {
            this.cachedResult = String.valueOf(super.toString()) + " ATR: " + HexString.hexify(this.atr);
        }
        return this.cachedResult;
    }
}

