/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.terminal;

import opencard.core.util.HexString;

public abstract class APDU {
    protected byte[] apdu_buffer;
    protected int apdu_length;

    public APDU(byte[] byArray) {
        this.apdu_buffer = byArray;
        this.apdu_length = byArray.length;
    }

    public APDU(byte[] byArray, int n) {
        this.apdu_buffer = byArray;
        this.apdu_length = n;
    }

    public APDU(int n) {
        this.apdu_buffer = new byte[n];
        this.apdu_length = 0;
    }

    public void append(byte[] byArray) throws IndexOutOfBoundsException {
        System.arraycopy(byArray, 0, this.apdu_buffer, this.apdu_length, byArray.length);
        this.apdu_length += byArray.length;
    }

    public void append(byte by) throws IndexOutOfBoundsException {
        this.apdu_buffer[this.apdu_length++] = by;
    }

    public final byte[] getBuffer() {
        return this.apdu_buffer;
    }

    public final int getByte(int n) {
        if (n >= this.apdu_length) {
            return -1;
        }
        return this.apdu_buffer[n] & 0xFF;
    }

    public final byte[] getBytes() {
        byte[] byArray = new byte[this.apdu_length];
        System.arraycopy(this.apdu_buffer, 0, byArray, 0, this.apdu_length);
        return byArray;
    }

    public final int getLength() {
        return this.apdu_length;
    }

    public final void setByte(int n, int n2) {
        if (n < this.apdu_length) {
            this.apdu_buffer[n] = (byte)n2;
        }
    }

    public final void setLength(int n) throws IndexOutOfBoundsException {
        if (n > this.apdu_buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        this.apdu_length = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\n");
        stringBuffer.append(HexString.dump(this.apdu_buffer, 0, this.apdu_length));
        return stringBuffer.toString();
    }
}

